/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals.metrics;

import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.IncrementalResourceDistributionStatsSnapshot;
import io.confluent.databalancer.metrics.DataBalancerMetricsRegistry;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class IncrementalResourceDistributionGoalMetrics {
    static final String NUM_BROKERS_ABOVE_LOWER_BOUND_METRIC_NAME = "num-brokers-above-lower-bound-threshold";
    static final String DESIRED_MEAN_UTILIZATION_METRIC_NAME = "desired-mean-utilization";
    private volatile int numBrokersAboveLowerBoundThreshold;
    private volatile double meanUtilizationThresholdValue;
    private final Map<String, String> tags;
    private final DataBalancerMetricsRegistry metricsRegistry;

    public IncrementalResourceDistributionGoalMetrics(String goalName, DataBalancerMetricsRegistry metricsRegistry, Class<?> metricClass) {
        this.tags = Collections.singletonMap("goal", goalName);
        this.metricsRegistry = metricsRegistry;
        this.registerMetrics(metricClass);
    }

    public void update(IncrementalResourceDistributionStatsSnapshot snapshot) {
        this.numBrokersAboveLowerBoundThreshold = snapshot.numBrokersAboveLowerBoundThreshold();
        this.meanUtilizationThresholdValue = snapshot.meanUtilizationPercentage();
    }

    private void registerMetrics(Class<?> metricClass) {
        this.metricsRegistry.newGauge(metricClass, NUM_BROKERS_ABOVE_LOWER_BOUND_METRIC_NAME, () -> this.numBrokersAboveLowerBoundThreshold, new TreeMap<String, String>(this.tags));
        this.metricsRegistry.newGauge(metricClass, DESIRED_MEAN_UTILIZATION_METRIC_NAME, () -> this.meanUtilizationThresholdValue, new TreeMap<String, String>(this.tags));
    }
}

