/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals.util;

import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.DistributionThresholdUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.ResourceDistributionStatsSnapshot;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceDistributionLogger {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceDistributionLogger.class);
    private final String goalName;
    private final DistributionThresholdUtils.ResourcePercentageThresholds thresholds;
    private final OptimizationOptions optimizationOptions;
    private final ResourceDistributionStatsSnapshot statsSnapshot;

    private ResourceDistributionLogger(Builder builder) {
        this.goalName = Objects.requireNonNull(builder.goalName, "Cannot create ResourceDistributionLogger with null goalName");
        this.thresholds = Objects.requireNonNull(builder.thresholds, "Cannot create ResourceDistributionLogger with null ResourceDistributionThresholds");
        this.optimizationOptions = Objects.requireNonNull(builder.optimizationOptions, "Cannot create ResourceDistributionLogger with null OptimizationOptions");
        this.statsSnapshot = builder.statsSnapshot;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void logResourceDistribution() {
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append("Initiated ");
        messageBuilder.append(this.goalName);
        messageBuilder.append(" with percentage thresholds (");
        messageBuilder.append(this.thresholds);
        messageBuilder.append(")");
        if (this.statsSnapshot != null) {
            messageBuilder.append(" and absolute thresholds (");
            messageBuilder.append(this.statsSnapshot.resourceValueThresholds());
            messageBuilder.append(")");
        }
        if (this.optimizationOptions.isTriggeredByGoalViolation()) {
            messageBuilder.append(" as part of evaluating whether to trigger the even-cluster load task");
        }
        if (this.statsSnapshot != null) {
            messageBuilder.append(" (all distribution statistics ");
            messageBuilder.append(this.statsSnapshot);
            messageBuilder.append(")");
        }
        String message = messageBuilder.toString();
        if (this.optimizationOptions.isTriggeredByGoalViolation()) {
            LOG.info(message);
        } else {
            LOG.debug(message);
        }
    }

    public static class Builder {
        private String goalName = null;
        private DistributionThresholdUtils.ResourcePercentageThresholds thresholds = null;
        private OptimizationOptions optimizationOptions = null;
        private ResourceDistributionStatsSnapshot statsSnapshot = null;

        public Builder goalName(String goalName) {
            this.goalName = goalName;
            return this;
        }

        public Builder thresholds(DistributionThresholdUtils.ResourcePercentageThresholds thresholds) {
            this.thresholds = thresholds;
            return this;
        }

        public Builder optimizationOptions(OptimizationOptions optimizationOptions) {
            this.optimizationOptions = optimizationOptions;
            return this;
        }

        public Builder statsSnapshot(ResourceDistributionStatsSnapshot statsSnapshot) {
            this.statsSnapshot = statsSnapshot;
            return this;
        }

        public ResourceDistributionLogger build() {
            return new ResourceDistributionLogger(this);
        }
    }
}

