/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.common;

import java.util.Optional;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class KafkaCruiseControlThreadFactory
implements ThreadFactory {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaCruiseControlThreadFactory.class);
    private final String name;
    private final boolean daemon;
    private final AtomicInteger id = new AtomicInteger(0);
    private final Logger logger;
    private final Optional<Integer> brokerId;

    public KafkaCruiseControlThreadFactory(String name, boolean daemon, Logger logger) {
        this(name, daemon, logger, Optional.empty());
    }

    public KafkaCruiseControlThreadFactory(String name, boolean daemon, Logger logger, Optional<Integer> brokerId) {
        this.name = "SBK_" + name;
        this.daemon = daemon;
        this.logger = logger == null ? LOG : logger;
        this.brokerId = brokerId;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(() -> {
            this.brokerId.ifPresent(brokerId -> MDC.put((String)"brokerId", (String)brokerId.toString()));
            r.run();
        }, this.name + "-" + this.id.getAndIncrement());
        t.setDaemon(this.daemon);
        t.setUncaughtExceptionHandler((t1, e) -> this.logger.error("Uncaught exception in " + t1.getName() + ": ", e));
        return t;
    }
}

