/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.common;

import com.linkedin.kafka.cruisecontrol.common.ResourceVisitor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum Resource {
    CPU("cpu", 0, true, true, 0.001, "%"),
    NW_IN("networkInbound", 1, true, false, 10.0, "KiB/s"),
    NW_OUT("networkOutbound", 2, true, false, 10.0, "KiB/s"),
    DISK("disk", 3, false, true, 100.0, "MiB"),
    PRODUCE_IN("produceInbound", 4, false, true, 10.0, "KiB/s");

    private static final double EPSILON_PERCENT = 8.0E-4;
    private final String resource;
    private final int id;
    private final boolean isHostResource;
    private final boolean isBrokerResource;
    private final double epsilon;
    private String unit;
    private static final List<Resource> CACHED_VALUES;

    public static List<Resource> cachedValues() {
        return CACHED_VALUES;
    }

    private Resource(String resource, int id, boolean isHostResource, boolean isBrokerResource, double epsilon, String unit) {
        this.resource = resource;
        this.id = id;
        this.isHostResource = isHostResource;
        this.isBrokerResource = isBrokerResource;
        this.epsilon = epsilon;
        this.unit = unit;
    }

    public String resource() {
        return this.resource;
    }

    public int id() {
        return this.id;
    }

    public String unit() {
        return this.unit;
    }

    public boolean isHostResource() {
        return this.isHostResource;
    }

    public boolean isBrokerResource() {
        return this.isBrokerResource;
    }

    public double epsilon(double value1, double value2) {
        return Math.max(this.epsilon, 8.0E-4 * (value1 + value2));
    }

    public <T> T visit(ResourceVisitor<T> visitor) {
        switch (this) {
            case CPU: {
                return visitor.visitCpuResource();
            }
            case NW_IN: {
                return visitor.visitNetworkInResource();
            }
            case NW_OUT: {
                return visitor.visitNetworkOutResource();
            }
            case DISK: {
                return visitor.visitDiskResource();
            }
            case PRODUCE_IN: {
                return visitor.visitProduceInResource();
            }
        }
        throw new IllegalStateException("Enum type " + (Object)((Object)this) + " not recognized.");
    }

    public String toString() {
        return this.resource;
    }

    static {
        CACHED_VALUES = Collections.unmodifiableList(Arrays.asList(Resource.values()));
    }
}

