/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.config;

import com.linkedin.cruisecontrol.common.CruiseControlConfigurable;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.CpuUsageDistributionGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.DiskCapacityGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.DiskUsageDistributionGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.IncrementalCPUResourceDistributionGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.IntraBrokerDiskCapacityGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.IntraBrokerDiskUsageDistributionGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.LeaderBytesInDistributionGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.LeaderReplicaDistributionGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.MovementExclusionGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.NetworkInboundCapacityGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.NetworkInboundUsageDistributionGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.NetworkOutboundCapacityGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.NetworkOutboundUsageDistributionGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.ProducerInboundCapacityGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.RackAwareGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.ReplicaCapacityGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.ReplicaDistributionGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.SystemTopicEvenDistributionGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.TopicReplicaDistributionGoal;
import com.linkedin.kafka.cruisecontrol.config.BrokerCapacityResolver;
import com.linkedin.kafka.cruisecontrol.config.SbcGoalsConfig;
import com.linkedin.kafka.cruisecontrol.config.UpdatableSbcGoalsConfig;
import com.linkedin.kafka.cruisecontrol.detector.notifier.SelfHealingNotifier;
import com.linkedin.kafka.cruisecontrol.executor.ExecutorNoopNotifier;
import com.linkedin.kafka.cruisecontrol.executor.strategy.BaseReplicaMovementStrategy;
import com.linkedin.kafka.cruisecontrol.executor.strategy.PostponeUrpReplicaMovementStrategy;
import com.linkedin.kafka.cruisecontrol.executor.strategy.PrioritizeLargeReplicaMovementStrategy;
import com.linkedin.kafka.cruisecontrol.executor.strategy.PrioritizeSmallReplicaMovementStrategy;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.DefaultMetricSamplerPartitionAssignor;
import io.confluent.cruisecontrol.analyzer.goals.MaxReplicaMovementParallelismGoal;
import io.confluent.cruisecontrol.analyzer.goals.ReplicaPlacementGoal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.internals.BalancerConfigs;
import org.apache.kafka.common.config.internals.ConfluentConfigs;

public class KafkaCruiseControlConfig
extends AbstractConfig {
    private static final ConfigDef CONFIG;
    public static final String BOOTSTRAP_SERVERS_CONFIG = "bootstrap.servers";
    public static final String CLIENT_ID_CONFIG = "client.id";
    public static final String SEND_BUFFER_CONFIG = "send.buffer.bytes";
    public static final String RECEIVE_BUFFER_CONFIG = "receive.buffer.bytes";
    public static final String CONNECTIONS_MAX_IDLE_MS_CONFIG = "connections.max.idle.ms";
    public static final String RECONNECT_BACKOFF_MS_CONFIG = "reconnect.backoff.ms";
    public static final String REQUEST_TIMEOUT_MS_CONFIG = "request.timeout.ms";
    private static final String REQUEST_TIMEOUT_MS_DOC = "The configuration controls the maximum amount of time the client will wait for the response of a request. If the response is not received before the timeout elapses the client will resend the request if necessary or fail the request if retries are exhausted.";
    public static final String LEADER_ACTION_TIMEOUT_MS_CONFIG = "executor.leader.action.timeout.ms";
    private static final String LEADER_ACTION_TIMEOUT_MS_DOC = "The maximum time that the Executor will wait for a leader movement to finish. A leader movement will be marked as failed if it takes longer than this time to finish.";
    private static final Long DEFAULT_LEADER_ACTION_TIMEOUT_MS;
    public static final String METADATA_TTL_CONFIG = "metadata.ttl";
    private static final String METADATA_TTL_DOC = "The amount of time the MetadataClient will cache cluster metadata before refreshing";
    public static final Long DEFAULT_METADATA_TTL;
    public static final String METADATA_CLIENT_TIMEOUT_MS_CONFIG = "metadata.client.timeout.ms";
    private static final String METADATA_CLIENT_TIMEOUT_MS_DOC = "The timeout, in milliseconds, after which the metadata client should give up trying to fetch the latest metadata";
    public static final Integer DEFAULT_METADATA_CLIENT_TIMEOUT_MS;
    public static final String DEFAULT_API_TIMEOUT_MS_CONFIG = "default.api.timeout.ms";
    private static final String DEFAULT_API_TIMEOUT_MS_DOC = "Specifies the timeout (in milliseconds) for client APIs. This configuration is used as the default timeout for all client operations that do not specify a <code>timeout</code> parameter.";
    public static final int DEFAULT_API_TIMEOUT_MS_DEFAULT = 60000;
    public static final String PARTITION_METRICS_WINDOW_MS_CONFIG = "partition.metrics.window.ms";
    private static final String PARTITION_METRICS_WINDOW_MS_DOC = "The size of the window in milliseconds to aggregate the Kafka partition metrics.";
    public static final Long DEFAULT_PARTITION_METRICS_WINDOW_MS;
    public static final String NUM_PARTITION_METRICS_WINDOWS_CONFIG = "num.partition.metrics.windows";
    private static final String NUM_PARTITION_METRICS_WINDOWS_DOC = "The total number of windows to keep for partition metric samples";
    public static final Integer DEFAULT_NUM_PARTITION_METRICS_WINDOWS;
    public static final String MIN_SAMPLES_PER_PARTITION_METRICS_WINDOW_CONFIG = "min.samples.per.partition.metrics.window";
    private static final String MIN_SAMPLES_PER_PARTITION_METRICS_WINDOW_DOC = "The minimum number of PartitionMetricSamples needed to make a partition metrics window valid without extrapolation.";
    public static final Integer DEFAULT_MIN_SAMPLES_PER_PARTITION_METRICS_WINDOW;
    public static final String MAX_ALLOWED_EXTRAPOLATIONS_PER_PARTITION_CONFIG = "max.allowed.extrapolations.per.partition";
    private static final String MAX_ALLOWED_EXTRAPOLATIONS_PER_PARTITION_DOC = "The maximum allowed number of extrapolations for each partition. A partition will be considered as invalid if the total number extrapolations in all the windows goes above this number.";
    public static final String PARTITION_METRIC_SAMPLE_AGGREGATOR_COMPLETENESS_CACHE_SIZE_CONFIG = "partition.metric.sample.aggregator.completeness.cache.size";
    private static final String PARTITION_METRIC_SAMPLE_AGGREGATOR_COMPLETENESS_CACHE_SIZE_DOC = "The metric sample aggregator caches the completeness metadata for fast query. The completeness describes the confidence level of the data in the metric sample aggregator. It is primarily measured by the validity of the metricssamples in different windows. This configuration configures The number of completeness cache slots to maintain.";
    public static final String BROKER_METRICS_WINDOW_MS_CONFIG = "broker.metrics.window.ms";
    private static final String BROKER_METRICS_WINDOW_MS_DOC = "The size of the window in milliseconds to aggregate the Kafka broker metrics.";
    public static final Long DEFAULT_BROKER_METRICS_WINDOW_MS;
    public static final String NUM_BROKER_METRICS_WINDOWS_CONFIG = "num.broker.metrics.windows";
    private static final String NUM_BROKER_METRICS_WINDOWS_DOC = "The total number of windows to keep for broker metric samples";
    public static final Integer DEFAULT_NUM_BROKER_METRICS_WINDOWS;
    public static final String MIN_SAMPLES_PER_BROKER_METRICS_WINDOW_CONFIG = "min.samples.per.broker.metrics.window";
    private static final String MIN_SAMPLES_PER_BROKER_METRICS_WINDOW_DOC = "The minimum number of BrokerMetricSamples needed to make a broker metrics window valid without extrapolation.";
    public static final Integer DEFAULT_MIN_SAMPLES_PER_BROKER_METRICS_WINDOW;
    public static final String MAX_ALLOWED_EXTRAPOLATIONS_PER_BROKER_CONFIG = "max.allowed.extrapolations.per.broker";
    private static final String MAX_ALLOWED_EXTRAPOLATIONS_PER_BROKER_DOC = "The maximum allowed number of extrapolations for each broker. A broker will be considered as invalid if the total number extrapolations in all the windows goes above this number.";
    public static final String BROKER_METRIC_SAMPLE_AGGREGATOR_COMPLETENESS_CACHE_SIZE_CONFIG = "broker.metric.sample.aggregator.completeness.cache.size";
    private static final String BROKER_METRIC_SAMPLE_AGGREGATOR_COMPLETENESS_CACHE_SIZE_DOC = "The metric sample aggregator caches the completeness metadata for fast query. The completeness describes the confidence level of the data in the metric sample aggregator. It is primarily measured by the validity of the metricssamples in different windows. This configuration configures The number of completeness cache slots to maintain.";
    @Deprecated
    public static final String NUM_METRIC_FETCHERS_CONFIG = "num.metric.fetchers";
    private static final String NUM_METRIC_FETCHERS_DOC = "The number of metric fetchers to fetch from the Kafka cluster.";
    public static final String NUM_CACHED_RECENT_ANOMALY_STATES_CONFIG = "num.cached.recent.anomaly.states";
    public static final String NUM_CACHED_RECENT_ANOMALY_STATES_DOC = "The number of recent anomaly states cached for different anomaly types presented via the anomaly substate response of the state endpoint.";
    public static final String METRIC_SAMPLER_CLASS_CONFIG = "metric.sampler.class";
    private static final String METRIC_SAMPLER_CLASS_DOC = "The class name of the metric sampler";
    private static final String METRIC_SAMPLER_CLASS_DEFAULT = "io.confluent.cruisecontrol.metricsreporter.ConfluentTelemetryReporterSampler";
    public static final String METRIC_SAMPLER_PARTITION_ASSIGNOR_CLASS_CONFIG = "metric.sampler.partition.assignor.class";
    private static final String METRIC_SAMPLER_PARTITION_ASSIGNOR_CLASS_DOC = "The class used to assign the partitions to the metric samplers.";
    public static final String METRIC_SAMPLING_INTERVAL_MS_CONFIG = "metric.sampling.interval.ms";
    private static final String METRIC_SAMPLING_INTERVAL_MS_DOC = "The interval of metric sampling.";
    public static final Long DEFAULT_METRIC_SAMPLING_INTERVAL_MS;
    public static final String BROKER_CAPACITY_CONFIG_RESOLVER_CLASS_CONFIG = "broker.capacity.config.resolver.class";
    private static final String BROKER_CAPACITY_CONFIG_RESOLVER_CLASS_DOC = "The broker capacity configuration resolver class name. The broker capacity configuration resolver is responsible for getting the broker capacity. The default implementation is a file based solution.";
    public static final String NETWORK_IN_CAPACITY_BYTES_CONFIG = "network.in.max.bytes.per.second";
    public static final String PRODUCER_IN_CAPACITY_BYTES_CONFIG = "producer.in.max.bytes.per.second";
    private static final String NETWORK_IN_CAPACITY_BYTES_DOC = "This config specifies the upper capacity limit for network incoming bytes per second per broker. The Confluent DataBalancer will attempt to keep incoming data throughput below this limit.";
    public static final String NETWORK_OUT_CAPACITY_BYTES_CONFIG = "network.out.max.bytes.per.second";
    private static final String NETWORK_OUT_CAPACITY_BYTES_DOC = "This config specifies the upper capacity limit for network outgoing bytes per second per broker. The Confluent DataBalancer will attempt to keep outgoing data throughput below this limit.";
    public static final String MIN_VALID_PARTITION_RATIO_CONFIG = "min.valid.partition.ratio";
    private static final String MIN_VALID_PARTITION_RATIO_DOC = "The minimum percentage of the total partitions required to be monitored in order to generate a valid load model. Because the topic and partitions in a Kafka cluster are dynamically changing. The load monitor will exclude some of the topics that does not have sufficient metric samples. This configuration defines the minimum required percentage of the partitions that must be included in the load model.";
    public static final Double DEFAULT_MIN_VALID_PARTITION_RATIO;
    public static final String LEADER_NETWORK_INBOUND_WEIGHT_FOR_CPU_UTIL_CONFIG = "leader.network.inbound.weight.for.cpu.util";
    private static final String LEADER_NETWORK_INBOUND_WEIGHT_FOR_CPU_UTIL_DOC = "Kafka Cruise Control uses the following model to derive replica level CPU utilization: REPLICA_CPU_UTIL = a * LEADER_BYTES_IN_RATE + b * LEADER_BYTES_OUT_RATE + c * FOLLOWER_BYTES_IN_RATE.This configuration will be used as the weight for LEADER_BYTES_IN_RATE.";
    public static final String LEADER_NETWORK_OUTBOUND_WEIGHT_FOR_CPU_UTIL_CONFIG = "leader.network.outbound.weight.for.cpu.util";
    private static final String LEADER_NETWORK_OUTBOUND_WEIGHT_FOR_CPU_UTIL_DOC = "Kafka Cruise Control uses the following model to derive replica level CPU utilization: REPLICA_CPU_UTIL = a * LEADER_BYTES_IN_RATE + b * LEADER_BYTES_OUT_RATE + c * FOLLOWER_BYTES_IN_RATE.This configuration will be used as the weight for LEADER_BYTES_OUT_RATE.";
    public static final String FOLLOWER_NETWORK_INBOUND_WEIGHT_FOR_CPU_UTIL_CONFIG = "follower.network.inbound.weight.for.cpu.util";
    private static final String FOLLOWER_NETWORK_INBOUND_WEIGHT_FOR_CPU_UTIL_DOC = "Kafka Cruise Control uses the following model to derive replica level CPU utilization: REPLICA_CPU_UTIL = a * LEADER_BYTES_IN_RATE + b * LEADER_BYTES_OUT_RATE + c * FOLLOWER_BYTES_IN_RATE.This configuration will be used as the weight for FOLLOWER_BYTES_IN_RATE.";
    public static final String HOT_PARTITION_CAPACITY_UTILIZATION_THRESHOLD_CONFIG = "hot.partition.capacity.utilization.threshold";
    public static final Double HOT_PARTITION_CAPACITY_UTILIZATION_THRESHOLD_DEFAULT;
    private static final String HOT_PARTITION_CAPACITY_UTILIZATION_THRESHOLD_DOC = "The maximum allowed percentage threshold of resource utilization that a partition can take from a single broker, before said partition is categorized as hot. A hot partition is simply a partition with heavy resource usage and is solely marked as such for observability purposes - it is not handled in any special way. For example, 0.2 means that if a partition takes more than 20% of a broker's resource capacity, it is considered hot.";
    public static final String CPU_BALANCE_THRESHOLD_CONFIG = "cpu.balance.threshold";
    private static final String CPU_BALANCE_THRESHOLD_DOC = "The maximum allowed extent of unbalance for CPU utilization. For example, 1.10 means the highest CPU usage of a broker should not be above 1.10x of average CPU utilization of all the brokers.";
    public static final Double DEFAULT_CPU_BALANCE_THRESHOLD;
    public static final String DISK_BALANCE_THRESHOLD_CONFIG = "disk.balance.threshold";
    private static final String DISK_BALANCE_THRESHOLD_DOC = "The maximum allowed extent of unbalance for disk utilization. For example, 1.10 means the highest disk usage of a broker should not be above 1.10x of average disk utilization of all the brokers.";
    public static final Double DEFAULT_DISK_BALANCE_THRESHOLD;
    public static final String NETWORK_INBOUND_BALANCE_THRESHOLD_CONFIG = "network.inbound.balance.threshold";
    private static final String NETWORK_INBOUND_BALANCE_THRESHOLD_DOC = "The maximum allowed extent of unbalance for network inbound usage. For example, 1.10 means the highest network inbound usage of a broker should not be above 1.10x of average network inbound usage of all the brokers.";
    public static final Double DEFAULT_NETWORK_INBOUND_BALANCE_THRESHOLD;
    public static final String NETWORK_OUTBOUND_BALANCE_THRESHOLD_CONFIG = "network.outbound.balance.threshold";
    private static final String NETWORK_OUTBOUND_BALANCE_THRESHOLD_DOC = "The maximum allowed extent of unbalance for network outbound usage. For example, 1.10 means the highest network outbound usage of a broker should not be above 1.10x of average network outbound usage of all the brokers.";
    public static final Double DEFAULT_NETWORK_OUTBOUND_BALANCE_THRESHOLD;
    public static final String REPLICA_COUNT_BALANCE_THRESHOLD_CONFIG = "replica.count.balance.threshold";
    private static final String REPLICA_COUNT_BALANCE_THRESHOLD_DOC = "The maximum allowed extent of unbalance for replica distribution. For example, 1.10 means the highest replica count of a broker should not be above 1.10x of average replica count of all brokers.";
    public static final String LEADER_REPLICA_COUNT_BALANCE_THRESHOLD_CONFIG = "leader.replica.count.balance.threshold";
    private static final String LEADER_REPLICA_COUNT_BALANCE_THRESHOLD_DOC = "The maximum allowed extent of unbalance for leader replica distribution. For example, 1.10 means the highest leader replica count of a broker should not be above 1.10x of average leader replica count of all alive brokers.";
    public static final String TOPIC_REPLICA_COUNT_BALANCE_THRESHOLD_CONFIG = "topic.replica.count.balance.threshold";
    private static final String TOPIC_REPLICA_COUNT_BALANCE_THRESHOLD_DOC = "The maximum allowed extent of unbalance for replica distribution from each topic. For example, 1.80 means the highest topic replica count of a broker should not be above 1.80x of average replica count of all brokers for the same topic.";
    public static final String GOAL_VIOLATION_DISTRIBUTION_THRESHOLD_MULTIPLIER_CONFIG = "goal.violation.distribution.threshold.multiplier";
    private static final String GOAL_VIOLATION_DISTRIBUTION_THRESHOLD_MULTIPLIER_DOC = "The multiplier applied to the threshold of distribution goals used for detecting and fixing anomalies. For example, 2.50 means the threshold for each distribution goal (i.e. Replica Distribution, Leader Replica Distribution, Resource Distribution, and Topic Replica Distribution Goals) will be 2.50x of the value used in manual goal optimization requests (e.g. rebalance).";
    public static final Double DEFAULT_GOAL_VIOLATION_DISTRIBUTION_THRESHOLD_MULTIPLIER;
    public static final String CPU_CAPACITY_THRESHOLD_CONFIG = "cpu.capacity.threshold";
    private static final String CPU_CAPACITY_THRESHOLD_DOC = "The maximum percentage of the total broker.cpu.capacity that is allowed to be used on a broker. The analyzer will enforce a hard goal that the cpu utilization of a broker cannot be higher than (broker.cpu.capacity * cpu.capacity.threshold).";
    public static final Double DEFAULT_CPU_CAPACITY_THRESHOLD;
    public static final String DISK_CAPACITY_THRESHOLD_CONFIG = "disk.max.load";
    private static final String DISK_CAPACITY_THRESHOLD_DOC = "The maximum percentage of the total broker.disk.capacity that is allowed to be used on a broker. The analyzer will enforce a hard goal that the disk usage of a broker cannot be higher than (broker.disk.capacity * disk.capacity.threshold).";
    public static final Double DEFAULT_DISK_CAPACITY_THRESHOLD;
    public static final String DISK_CAPACITY_MIN_FREE_SPACE_CONFIG = "disk.min.free.space.gb";
    private static final String DISK_CAPACITY_MIN_FREE_SPACE_DOC = "The minimum amount of disk space, in gigabytes, that needs to remain unused on a broker. The analyzer will enforce a hard goal that the disk usage of a broker cannot be higher than (broker.disk.capacity - disk.min.free.space.gb).";
    public static final Integer DEFAULT_DISK_CAPACITY_MIN_FREE_SPACE;
    public static final String NETWORK_INBOUND_CAPACITY_THRESHOLD_CONFIG = "network.inbound.capacity.threshold";
    private static final String NETWORK_INBOUND_CAPACITY_THRESHOLD_DOC = "The maximum percentage of the total confluent.balancer.network.in.max.bytes.per.second that is allowed to be used on a broker. The analyzer will enforce a hard goal that the network usage of a broker cannot be higher than (confluent.balancer.network.in.max.bytes.per.second * network.inbound.capacity.threshold).";
    public static final Double DEFAULT_NETWORK_INBOUND_CAPACITY_THRESHOLD;
    public static final String PRODUCER_INBOUND_CAPACITY_THRESHOLD_CONFIG = "producer.inbound.capacity.threshold";
    private static final String PRODUCER_INBOUND_CAPACITY_THRESHOLD_DOC = "The maximum percentage of the total confluent.balancer.producer.in.max.bytes.per.second that is allowed to be used on a broker. The analyzer will enforce a hard goal that the producer inbound traffic of a broker cannot be higher than (confluent.balancer.producer.in.max.bytes.per.second * producer.inbound.capacity.threshold).";
    public static final Double DEFAULT_PRODUCER_INBOUND_CAPACITY_THRESHOLD;
    public static final String NETWORK_OUTBOUND_CAPACITY_THRESHOLD_CONFIG = "network.outbound.capacity.threshold";
    private static final String NETWORK_OUTBOUND_CAPACITY_THRESHOLD_DOC = "The maximum percentage of the total confluent.balancer.network.out.max.bytes.per.second that is allowed to be used on a broker. The analyzer will enforce a hard goal that the network usage of a broker cannot be higher than (confluent.balancer.network.out.max.bytes.per.second * network.outbound.capacity.threshold).";
    public static final Double DEFAULT_NETWORK_OUTBOUND_CAPACITY_THRESHOLD;
    public static final String CPU_LOW_UTILIZATION_THRESHOLD_CONFIG = "cpu.low.utilization.threshold";
    private static final String CPU_LOW_UTILIZATION_THRESHOLD_DOC = "The threshold for Kafka Cruise Control to define the utilization of CPU is low enough that rebalance is not worthwhile. The cluster will only be in a low utilization state when all the brokers are below the low utilization threshold. The threshold is in percentage.";
    public static final Double DEFAULT_CPU_LOW_UTILIZATION_THRESHOLD;
    public static final String DISK_LOW_UTILIZATION_THRESHOLD_CONFIG = "disk.low.utilization.threshold";
    private static final String DISK_LOW_UTILIZATION_THRESHOLD_DOC = "The threshold for Kafka Cruise Control to define the utilization of DISK is low enough that rebalance is not worthwhile. The cluster will only be in a low utilization state when all the brokers are below the low utilization threshold. The threshold is in percentage.";
    public static final Double DEFAULT_DISK_LOW_UTILIZATION_THRESHOLD;
    public static final String NETWORK_INBOUND_LOW_UTILIZATION_THRESHOLD_CONFIG = "network.inbound.low.utilization.threshold";
    private static final String NETWORK_INBOUND_LOW_UTILIZATION_THRESHOLD_DOC = "The threshold for Kafka Cruise Control to define the utilization of network inbound rate is low enough that rebalance is not worthwhile. The cluster will only be in a low utilization state when all the brokers are below the low utilization threshold. The threshold is in percentage.";
    public static final Double DEFAULT_NETWORK_INBOUND_LOW_UTILIZATION_THRESHOLD;
    public static final String NETWORK_OUTBOUND_LOW_UTILIZATION_THRESHOLD_CONFIG = "network.outbound.low.utilization.threshold";
    private static final String NETWORK_OUTBOUND_LOW_UTILIZATION_THRESHOLD_DOC = "The threshold for Kafka Cruise Control to define the utilization of network outbound rate is low enough that rebalance is not worthwhile. The cluster will only be in a low utilization state when all the brokers are below the low utilization threshold. The threshold is in percentage.";
    public static final Double DEFAULT_NETWORK_OUTBOUND_LOW_UTILIZATION_THRESHOLD;
    public static final String MAX_REPLICAS_PER_BROKER_CONFIG = "max.replicas";
    private static final String MAX_REPLICAS_PER_BROKER_DOC = "The maximum number of replicas allowed to reside on a broker. The analyzer will enforce a hard goal that the number of replica on a broker cannot be higher than this config.";
    public static final String ZOOKEEPER_CONNECT_CONFIG = "zookeeper.connect";
    private static final String ZOOKEEPER_CONNECT_DOC = "The zookeeper path used by the Kafka cluster.";
    public static final String ZOOKEEPER_SECURITY_ENABLED_CONFIG = "zookeeper.security.enabled";
    private static final String ZOOKEEPER_SECURITY_ENABLED_DOC = "Specify if zookeeper is secured, true or false";
    public static final String NUM_CONCURRENT_PARTITION_MOVEMENTS_PER_BROKER_CONFIG = "num.concurrent.partition.movements.per.broker";
    private static final String NUM_CONCURRENT_PARTITION_MOVEMENTS_PER_BROKER_DOC = "The maximum number of partitions the executor will move to or out of a broker at the same time. e.g. setting the value to 10 means that the executor will at most allow 10 partitions moves with relation to a broker at any given point, regardless if they are out of the broker or into it. This is useful to avoid overwhelming the cluster by inter-broker partition movements.";
    public static final String NUM_CONCURRENT_INTRA_BROKER_PARTITION_MOVEMENTS_CONFIG = "num.concurrent.intra.broker.partition.movements";
    private static final String NUM_CONCURRENT_INTRA_BROKER_PARTITION_MOVEMENTS_DOC = "The maximum number of partitions the executor will move across disks within a broker at the same time. e.g. setting the value to 10 means that the executor will at most allow 10 partitions to move across disks within a broker at any given point. This is to avoid overwhelming the cluster by intra-broker partition movements.";
    public static final String NUM_CONCURRENT_LEADER_MOVEMENTS_CONFIG = "num.concurrent.leader.movements";
    private static final String NUM_CONCURRENT_LEADER_MOVEMENTS_DOC = "The maximum number of leader movements the executor will take as one batch. This is mainly because the ZNode has a 1 MB size upper limit. And it will also reduce the controller burden.";
    public static final String REPLICATION_THROTTLE_CONFIG = "throttle.bytes.per.second";
    public static final Long DISABLED_THROTTLE;
    public static final long AUTO_THROTTLE;
    private static final String REPLICATION_THROTTLE_DOC = "The replication throttle applied to replicas being moved, in bytes per second. A value of null or -1 means no throttle isapplied. A value of -2 means the throttle is automatically calculated based on the cluster metrics.";
    private static final Long DEFAULT_THROTTLE_VALUE;
    public static final String REPLICA_MOVEMENT_STRATEGIES_CONFIG = "replica.movement.strategies";
    private static final String REPLICA_MOVEMENT_STRATEGIES_DOC = "A list of supported strategies used to determine execution order for generated partition movement tasks.";
    public static final String DEFAULT_REPLICA_MOVEMENT_STRATEGIES_CONFIG = "default.replica.movement.strategies";
    private static final String DEFAULT_REPLICA_MOVEMENT_STRATEGIES_DOC = "The list of replica movement strategies that will be used by default if no replica movement strategy list is provided.";
    public static final String EXECUTION_PROGRESS_CHECK_INTERVAL_MS_CONFIG = "execution.progress.check.interval.ms";
    private static final String EXECUTION_PROGRESS_CHECK_INTERVAL_MS_DOC = "The interval in milliseconds that the executor will check on the execution progress.";
    private static final long DEFAULT_EXECUTION_PROGRESS_CHECK_INTERVAL_MS = 7000L;
    public static final String SHUTDOWN_TIMEOUT_MS_CONFIG = "cdbe.shutdown.wait.ms";
    private static final String SHUTDOWN_TIMEOUT_MS_DOC = "Maximum amount of time for CDBE to wait for its ExecutorService to shutdown.";
    private static final int DEFAULT_SHUTDOWN_TIMEOUT_MS = 15000;
    public static final String CC_STARTUP_RETRY_DURATION_HOURS_CONFIG = "startup.retry.max.hours";
    private static final String CC_STARTUP_RETRY_DURATION_HOURS_DOC = "Maximum hours to keep on retrying to start CruiseControl before giving up.";
    private static final int DEFAULT_CC_STARTUP_RETRY_DURATION_HOURS = 2;
    public static final String CC_STARTUP_RETRY_DELAY_MINUTES_CONFIG = "startup.retry.delay.minutes";
    private static final String CC_STARTUP_RETRY_DELAY_MINUTES_DOC = "Minutes to wait between two tries to start CruiseControl";
    private static final int DEFAULT_CC_STARTUP_RETRY_DELAY_MINUTES = 5;
    private static final List<String> SBC_HARD_GOALS;
    public static final String GOALS_CONFIG = "goals";
    private static final String GOALS_DOC = "A list of case insensitive goals in the order of priority. The high priority goals will be executed first.";
    private static final List<String> SBC_V1_SOFT_GOALS;
    public static final List<String> DEFAULT_GOALS_LIST;
    public static final String INTRA_BROKER_GOALS_CONFIG = "intra.broker.goals";
    private static final String INTRA_BROKER_GOALS_DOC = "A list of case insensitive intra-broker goals in the order of priority. The high priority goals will be executed first. The intra-broker goals are only relevant if intra-broker operation is supported(i.e. in  Cruise Control versions above 2.*), otherwise this list should be empty.";
    public static final String ANOMALY_NOTIFIER_CLASS_CONFIG = "anomaly.notifier.class";
    private static final String ANOMALY_NOTIFIER_CLASS_DOC = "The notifier class to trigger an alert when an anomaly is violated. The anomaly could be either a goal violation, broker failure.";
    private static final String DEFAULT_ANOMALY_NOTIFIER_CLASS;
    public static final String EXECUTOR_NOTIFIER_CLASS_CONFIG = "executor.notifier.class";
    private static final String EXECUTOR_NOTIFIER_CLASS_DOC = "The executor notifier class to trigger an alert when an execution finishes or is stopped (by a user or by Cruise Control).";
    private static final String DEFAULT_EXECUTOR_NOTIFIER_CLASS;
    public static final String ANOMALY_DETECTION_INTERVAL_MS_CONFIG = "anomaly.detection.interval.ms";
    private static final String ANOMALY_DETECTION_INTERVAL_MS_DOC = "The interval in millisecond that the detectors will run to detect the anomalies.";
    public static final Integer DEFAULT_ANOMALY_DETECTION_INTERVAL_MS;
    public static final String ANOMALY_DETECTION_ALLOW_CAPACITY_ESTIMATION_CONFIG = "anomaly.detection.allow.capacity.estimation";
    private static final String ANOMALY_DETECTION_ALLOW_CAPACITY_ESTIMATION_DOC = "The flag to indicate whether anomaly detection threads allow capacity estimation in the generated cluster model they use.";
    public static final String SAMPLING_ALLOW_CPU_CAPACITY_ESTIMATION_CONFIG = "sampling.allow.cpu.capacity.estimation";
    private static final String SAMPLING_ALLOW_CPU_CAPACITY_ESTIMATION_DOC = "The flag to indicate whether sampling process allows CPU capacity estimation of brokers used for CPU utilization estimation.";
    public static final String ANOMALY_DETECTION_GOALS_CONFIG = "anomaly.detection.goals";
    private static final String ANOMALY_DETECTION_GOALS_DOC = "The goals that anomaly detector should detect if they areviolated.";
    public static final List<String> DEFAULT_ANOMALY_DETECTION_GOALS_LIST;
    public static final String BROKER_FAILURE_EXCLUDE_RECENTLY_REMOVED_BROKERS_CONFIG = "broker.failure.exclude.recently.removed.brokers";
    private static final String BROKER_FAILURE_EXCLUDE_RECENTLY_REMOVED_BROKERS_DOC = "True if recently removed brokers are excluded from optimizations during broker failure self healing, false otherwise.";
    public static final String GOAL_VIOLATION_EXCLUDE_RECENTLY_REMOVED_BROKERS_CONFIG = "goal.violation.exclude.recently.removed.brokers";
    private static final String GOAL_VIOLATION_EXCLUDE_RECENTLY_REMOVED_BROKERS_DOC = "True if recently removed brokers are excluded from optimizations during goal violation self healing, false otherwise.";
    public static final String GOAL_VIOLATION_DELAY_ON_NEW_BROKER_MS_CONFIG = "goal.violation.delay.on.new.brokers.ms";
    public static final String GOAL_VIOLATION_DELAY_ON_NEW_BROKER_MS_DOC = "Amount of time (in ms) to delay self-healing when new brokers join the cluster. Allows the cluster to stabilize.";
    public static final Long GOAL_VIOLATION_DELAY_ON_NEW_BROKERS_MS_DEFAULT;
    public static final String TOPICS_EXCLUDED_FROM_PARTITION_MOVEMENT_CONFIG = "topics.excluded.from.partition.movement";
    private static final String TOPICS_EXCLUDED_FROM_PARTITION_MOVEMENT_DOC = "The topics that should be excluded from the partition movement. It is a regex. Notice that this regex will be ignored when decommission a broker is invoked.";
    public static final String PARTITION_METRIC_SAMPLE_STORE_TOPIC_CONFIG = "partition.metric.sample.store.topic";
    public static final String DEFAULT_PARTITION_SAMPLE_STORE_TOPIC = "_confluent_balancer_partition_samples";
    public static final String PARTITION_METRIC_SAMPLE_STORE_TOPIC_DOC = "Topic where partition metric samples are stored.";
    public static final String BROKER_METRIC_SAMPLE_STORE_TOPIC_CONFIG = "broker.metric.sample.store.topic";
    public static final String DEFAULT_BROKER_SAMPLE_STORE_TOPIC = "_confluent_balancer_broker_samples";
    public static final String BROKER_METRIC_SAMPLE_STORE_TOPIC_DOC = "Topic where broker metric samples are stored.";
    public static final String REMOVAL_HISTORY_RETENTION_TIME_MS_CONFIG = "removal.history.retention.time.ms";
    private static final String REMOVAL_HISTORY_RETENTION_TIME_MS_DOC = "The maximum time in milliseconds to retain the removal history of brokers.";
    public static final String GOAL_BALANCEDNESS_PRIORITY_WEIGHT_CONFIG = "goal.balancedness.priority.weight";
    private static final String GOAL_BALANCEDNESS_PRIORITY_WEIGHT_DOC = "The impact of having one level higher goal priority on the relative balancedness score. For example, 1.1 means that a goal with higher priority will have the 1.1x balancedness weight of the lower priority goal (assuming the same goal.balancedness.strictness.weight values for both goals).";
    public static final String GOAL_BALANCEDNESS_STRICTNESS_WEIGHT_CONFIG = "goal.balancedness.strictness.weight";
    private static final String GOAL_BALANCEDNESS_STRICTNESS_WEIGHT_DOC = "The impact of strictness (i.e. hard or soft goal) on the relative balancedness score. For example, 1.5 means that a hard goal will have the 1.5x balancedness weight of a soft goal (assuming goal.balancedness.priority.weight is 1).";
    public static final String SELF_HEALING_BROKER_FAILURE_ENABLED_CONFIG = "self.healing.broker.failure.enabled";
    public static final String SELF_HEALING_BROKER_FAILURE_ENABLED_DOC = "Enable self healing for broker failure detector.";
    public static final String SELF_HEALING_GOAL_VIOLATION_ENABLED_CONFIG = "self.healing.goal.violation.enabled";
    public static final String SELF_HEALING_GOAL_VIOLATION_ENABLED_DOC = "Enable self healing for goal violation detector.";
    public static final String BROKER_FAILURE_ALERT_THRESHOLD_MS_CONFIG = "broker.failure.alert.threshold.ms";
    public static final String BROKER_FAILURE_ALERT_THRESHOLD_MS_DOC = "Grace period in milliseconds for a failed broker to rejoin the cluster before firing an alert";
    public static final Long DEFAULT_BROKER_FAILURE_ALERT_THRESHOLD_MS;
    public static final String BROKER_FAILURE_SELF_HEALING_THRESHOLD_MS_CONFIG = "broker.failure.self.healing.threshold.ms";
    public static final String BROKER_FAILURE_SELF_HEALING_THRESHOLD_MS_DOC = "Grace period in milliseconds for a failed broker to rejoin the cluster before triggering a self-healing action. Must not be less than 'broker.failure.alert.threshold.ms'";
    public static final Long DEFAULT_BROKER_FAILURE_SELF_HEALING_THRESHOLD_MS;
    public static final String LOGDIR_RESPONSE_TIMEOUT_MS_CONFIG = "logdir.response.timeout.ms";
    private static final String LOGDIR_RESPONSE_TIMEOUT_MS_DOC = "Timeout in ms for broker logdir to respond";
    private static final Integer LOGDIR_REPSONSE_TIMEOUT_MS_DEFAULT;
    public static final String DESCRIBE_TOPICS_RESPONSE_TIMEOUT_MS_CONFIG = "describe.topics.response.timeout.ms";
    private static final String DESCRIBE_TOPICS_RESPONSE_TIMEOUT_MS_DOC = "Timeout in ms for the broker to respond to a describe topics request";
    public static final Integer DEFAULT_DESCRIBE_TOPICS_RESPONSE_TIMEOUT_MS;
    public static final String DESCRIBE_CLUSTER_RESPONSE_TIMEOUT_MS_CONFIG = "describe.cluster.response.timeout.ms";
    private static final String DESCRIBE_CLUSTER_RESPONSE_TIMEOUT_MS_DOC = "Timeout in ms for the broker to respond to a describe cluster request";
    public static final Integer DEFAULT_DESCRIBE_CLUSTER_RESPONSE_TIMEOUT_MS;
    public static final String DESCRIBE_CONFIGS_RESPONSE_TIMEOUT_MS_CONFIG = "describe.configs.response.timeout.ms";
    private static final String DESCRIBE_CONFIGS_RESPONSE_TIMEOUT_MS_DOC = "Timeout in ms for the broker to respond to a describe configs request";
    public static final Integer DEFAULT_DESCRIBE_CONFIGS_RESPONSE_TIMEOUT_MS;
    public static final String DESCRIBE_CONFIGS_BATCH_SIZE_CONFIG = "describe.configs.batch.size";
    private static final String DESCRIBE_CONFIGS_BATCH_SIZE_DOC = "Maximum size of entities to fetch in one call of describe configs. -1 to ignore this setting and fetch all entities in one ";
    public static final Integer DEFAULT_DESCRIBE_CONFIGS_BATCH_SIZE;
    public static final String BROKER_REMOVAL_SHUTDOWN_MS_CONFIG = "broker.removal.shutdown.timeout.ms";
    private static final String BROKER_REMOVAL_SHUTDOWN_MS_DOC = "Timeout in ms for for all brokers with shutdown requests to shut down and leave the cluster.";
    public static final Long DEFAULT_BROKER_REMOVAL_SHUTDOWN_MS;
    public static final String BROKER_REPLICA_EXCLUSION_TIMEOUT_MS_CONFIG = "broker.replica.exclusion.timeout.ms";
    public static final String BROKER_REPLICA_EXCLUSION_TIMEOUT_MS_DOC = "Timeout in ms for the controller to respond to a broker exclusion request";
    public static final Integer DEFAULT_BROKER_REPLICA_EXCLUSION_TIMEOUT_MS;
    public static final String DESCRIBE_BROKER_REPLICA_EXCLUSION_TIMEOUT_MS_CONFIG = "describe.broker.exclusion.timeout.ms";
    public static final String DESCRIBE_BROKER_REPLICA_EXCLUSION_TIMEOUT_MS_DOC = "Timeout in ms for the controller to respond to a describe broker exclusions request";
    public static final Integer DEFAULT_DESCRIBE_BROKER_REPLICA_EXCLUSION_TIMEOUT_MS;
    public static final String OVERRIDE_STATIC_THROTTLES_CONFIG = "static.throttle.rate.override.enabled";
    private static final String OVERRIDE_STATIC_THROTTLES_DOC = "Whether Cruise Control will override statically-set throttles on the broker when executing proposals";
    public static final String MAX_VOLUME_THROUGHPUT_MB_CONFIG = "max.volume.throughput.mb";
    private static final String MAX_VOLUME_THROUGHPUT_MB_DOC = "The maximum throughput of the storage volume. This should be the minimum of the maximum disk throughput on the volume and the maximum network throughput to the volume";
    public static final String WRITE_THROUGHPUT_MULTIPLIER_CONFIG = "write.throughput.multiplier";
    private static final String WRITE_THROUGHPUT_MULTIPLIER_DOC = "The factor that write throughput is multiplied by when computing network usage. GCP counts communication with the storage volumes and replication of the written data against the overall network usage";
    public static final Double DEFAULT_WRITE_THROUGHPUT_MULTIPLIER;
    public static final String READ_THROUGHPUT_MULTIPLIER_CONFIG = "read.throughput.multiplier";
    private static final String READ_THROUGHPUT_MULTIPLIER_DOC = "The factor that read throughput is multiplied by when computing network usage. GCP counts communication with the storage volumes against the overall network usage";
    public static final Double DEFAULT_READ_THROUGHPUT_MULTIPLIER;
    public static final String CALCULATED_THROTTLE_RATIO_CONFIG = "calculated.throttle.ratio";
    private static final String CALCULATED_THROTTLE_RATIO_DOC = "When the throttling rate is calculated, this is the amount of available network throughput (max throughput - currently used throughput) that is given to reassignment traffic";
    public static final String DISK_READ_RATIO_CONFIG = "disk.read.ratio";
    private static final String DISK_READ_RATIO_DOC = "When calculating a replication throttle, this is the ratio of reads that are assumed to read from the actual disk, rather than the page cache";
    public static final String PLAN_COMPUTATION_RETRY_TIMEOUT_MS_CONFIG = "plan.computation.retry.timeout.ms";
    public static final String PLAN_COMPUTATION_RETRY_INTERVAL_MS_DOC = "The time, in milliseconds, after which plan computation will give up on retrying failures due to insufficient metrics. Note that this only applies to the plan computation used for broker removal and broker addition operations.";
    public static final Long PLAN_COMPUTATION_RETRY_TIMEOUT_MS_DEFAULT;
    public static final String INVALID_REPLICA_ASSIGNMENT_RETRY_TIMEOUT_MS_CONFIG = "invalid.replica.assignment.retry.timeout.ms";
    public static final String INVALID_REPLICA_ASSIGNMENT_RETRY_TIMEOUT_MS_DOC = "The time, in milliseconds, after which proposal execution will retry the failed proposal due to an invalid replica assignment on the same proposal. ";
    public static final Long INVALID_REPLICA_ASSIGNMENT_RETRY_TIMEOUT_MS_DEFAULT;
    public static final String EXECUTOR_REFRESH_TIME_MS_CONFIG = "executor.reservation.refresh.time.ms";
    public static final String EXECUTOR_REFRESH_TIME_MS_DOC = "The time, in milliseconds, after which a newly-acquired executor reservation which aborted an executor run should wait before being returned. Useful for edge cases where metadata in the underlying Kafka cluster isn't updated quickly enough.";
    public static final Long EXECUTOR_REFRESH_TIME_MS_DEFAULT;
    public static final String REQUEST_CONTRIBUTION_WEIGHT_CONFIG = "request.cpu.contribution.weight";
    public static final double DEFAULT_REQUEST_CONTRIBUTION_WEIGHT = 0.8;
    private static final String REQUEST_CONTRIBUTION_WEIGHT_DOC = "Fraction of CPU that is caused by number of requests on the broker. This includes produce, consume and replication fetch requests.";
    public static final String BYTES_CONTRIBUTION_WEIGHT_CONFIG = "bytes.cpu.contribution.weight";
    public static final double DEFAULT_BYTES_CONTRIBUTION_WEIGHT = 0.2;
    private static final String BYTES_CONTRIBUTION_WEIGHT_DOC = "Fraction of CPU that is caused by bytes in/out on the broker. Includes produce bytes-in and consume bytes-out (FFL and FFF) as well as replication bytes.";
    public static final String CAPACITY_BALANCING_DELTA_PERCENTAGE_CONFIG = "max.capacity.balancing.delta.percentage";
    public static final Double CAPACITY_BALANCING_DELTA_PERCENTAGE_DEFAULT;
    public static final String CAPACITY_BALANCING_DELTA_PERCENTAGE_DOC = "The extra percentage of total capacity that SBC will attempt to balance below the allowed capacity once it gets triggered to fix a broker hitting its maximum allowed capacity for a given resource.";
    public static final String INCREMENTAL_BALANCING_ENABLED_CONFIG = "incremental.balancing.enabled";
    public static final String INCREMENTAL_BALANCING_ENABLED_DOC = "A boolean value controlling whether to use incremental balancing strategy or not.";
    public static final Boolean INCREMENTAL_BALANCING_ENABLED_DEFAULT;
    public static final String INCREMENTAL_BALANCING_GOALS_CONFIG = "incremental.balancing.goals";
    public static final String INCREMENTAL_BALANCING_GOALS_DOC = "A list of case insensitive goals in the order of priority. The high priority goals will be executed first. This list of goals will be used for anomaly detection and balancing if incremental.balancing.enabled is set to true.";
    private static final List<String> SBC_V2_SOFT_GOALS;
    public static final List<String> INCREMENTAL_BALANCING_DEFAULT_GOALS_LIST;
    public static final String INCREMENTAL_BALANCING_STEP_RATIO_CONFIG = "incremental.balancing.step.ratio";
    public static final String INCREMENTAL_BALANCING_STEP_RATIO_DOC = "A value in the interval [0, 1] representing the step size of each incremental balancing round. For example, if an overloaded broker has 70% CPU usage and the mean CPU usage across the cluster is 50%, setting incremental.balancing.step.ratio to 0.2 will generate incremental balancing proposals that moves enough replicas off from the overloaded broker so that its CPU usage drops by 20% of the delta: (70% - 50%) * 0.2 = 4%.";
    public static final Double INCREMENTAL_BALANCING_STEP_RATIO_DEFAULT;
    public static final String INCREMENTAL_BALANCING_LOWER_BOUND_CONFIG = "incremental.balancing.lower.bound";
    public static final String INCREMENTAL_BALANCING_LOWER_BOUND_DOC = "A value in the interval [0, 1] representing the lower bound of replica movements from each incremental balancing round to prevent the long tail effect of incremental balancing. Take CPU usage for example, setting incremental.balancing.lower.bound to 0.02 will cause each incremental balancing round generates enough movements so that the change in CPU usage is at least 0.02 * 100% (Capacity of CPU usage) = 2% of the capacity. Combining with incremental.balancing.step.ratio, these two configurations facilitate the success criteria of an incremental balancing round.";
    public static final Double INCREMENTAL_BALANCING_LOWER_BOUND_DEFAULT;
    public static final String RESOURCE_UTILIZATION_DETECTOR_ENABLED_CONFIG = "resource.utilization.detector.enabled";
    private static final boolean DEFAULT_RESOURCE_UTILIZATION_DETECTOR_ENABLED = false;
    private static final String RESOURCE_UTILIZATION_DETECTOR_ENABLED_DOC = "Specify if resource optimization detector is enabled";
    public static final String RESOURCE_UTILIZATION_DETECTOR_INTERVAL_MS_CONFIG = "resource.utilization.detector.interval.ms";
    public static final int DEFAULT_RESOURCE_UTILIZATION_DETECTOR_INTERVAL_MS = 60000;
    private static final String RESOURCE_UTILIZATION_DETECTOR_INTERVAL_MS_DOC = "The interval in milliseconds that the resource optimization detector will run.";
    public static final String CPU_UTILIZATION_DETECTOR_DURATION_MS_CONFIG = "cpu.utilization.detector.duration.ms";
    private static final int DEFAULT_CPU_UTILIZATION_DETECTOR_DURATION_MS = 600000;
    private static final String CPU_UTILIZATION_DETECTOR_DURATION_MS_DOC = "The duration in milliseconds for which resource utilization values will be accumulated before the decision to raise an alert is made.";
    public static final String CPU_UTILIZATION_DETECTOR_OVERUTILIZATION_THRESHOLD_CONFIG = "cpu.utilization.detector.overutilization.threshold";
    private static final double DEFAULT_CPU_UTILIZATION_DETECTOR_OVERUTILIZATION_THRESHOLD = 80.0;
    private static final String CPU_UTILIZATION_DETECTOR_OVERUTILIZATION_THRESHOLD_DOC = "CPU usage percentage representing overutilization.";
    public static final String CPU_UTILIZATION_DETECTOR_UNDERUTILIZATION_THRESHOLD_CONFIG = "cpu.utilization.detector.underutilization.threshold";
    private static final double DEFAULT_CPU_UTILIZATION_DETECTOR_UNDERUTILIZATION_THRESHOLD = 50.0;
    private static final String CPU_UTILIZATION_DETECTOR_UNDERUTILIZATION_THRESHOLD_DOC = "CPU usage percentage representing underutilization.";
    public static final String DISK_UTILIZATION_DETECTOR_DURATION_MS_CONFIG = "disk.utilization.detector.duration.ms";
    private static final int DEFAULT_DISK_UTILIZATION_DETECTOR_DURATION_MS = 600000;
    private static final String DISK_UTILIZATION_DETECTOR_DURATION_MS_DOC = "The duration in milliseconds for which disk utilization values will be accumulated before the decision to raise an alert is made.";
    public static final String DISK_UTILIZATION_DETECTOR_OVERUTILIZATION_THRESHOLD_CONFIG = "disk.utilization.detector.overutilization.threshold";
    private static final double DEFAULT_DISK_UTILIZATION_DETECTOR_OVERUTILIZATION_THRESHOLD = 80.0;
    private static final String DISK_UTILIZATION_DETECTOR_OVERUTILIZATION_THRESHOLD_DOC = "Disk usage percentage representing overutilization.";
    public static final String DISK_UTILIZATION_DETECTOR_UNDERUTILIZATION_THRESHOLD_CONFIG = "disk.utilization.detector.underutilization.threshold";
    private static final double DEFAULT_DISK_UTILIZATION_DETECTOR_UNDERUTILIZATION_THRESHOLD = 35.0;
    private static final String DISK_UTILIZATION_DETECTOR_UNDERUTILIZATION_THRESHOLD_DOC = "Disk usage percentage representing underutilization.";
    public static final String DISK_UTILIZATION_DETECTOR_RESERVED_CAPACITY_CONFIG = "disk.utilization.detector.reserved.capacity";
    private static final double DEFAULT_DISK_UTILIZATION_DETECTOR_RESERVED_CAPACITY = 150000.0;
    private static final String DISK_UTILIZATION_DETECTOR_RESERVED_CAPACITY_DOC = "Minimum disk space beyond which we don't shrink the cluster even if it is underutilized.";
    public static final String TOPIC_PARTITION_MOVEMENT_EXPIRATION_MS_CONFIG = "topic.partition.movement.expiration.ms";
    public static final long DEFAULT_TOPIC_PARTITION_MOVEMENT_EXPIRATION_MS = 3600000L;
    public static final String TOPIC_PARTITION_MOVEMENT_EXPIRATION_MS_DOC = "The duration in milliseconds for which a topic partition movement will be kept for observability and oscillation prevention. Effectively, SBC maintains a rolling window of topic partition movements whose length is defined by this configuration.";
    public static final String TOPIC_PARTITION_MAXIMUM_MOVEMENTS_CONFIG = "topic.partition.maximum.movements";
    public static final int DEFAULT_TOPIC_PARTITION_MAXIMUM_MOVEMENTS = 5;
    public static final String TOPIC_PARTITION_MAXIMUM_MOVEMENTS_DOC = "Maximum number of repeated movements allowed for one TopicPartition in the rolling window whose length is defined by topic.partition.movement.expiration.ms";
    public static final String TOPIC_PARTITION_SUSPENSION_MS_CONFIG = "topic.partition.suspension.ms";
    public static final long DEFAULT_TOPIC_PARTITION_SUSPENSION_MS = 10800000L;
    public static final String TOPIC_PARTITION_SUSPENSION_MS_DOC = "The duration in milliseconds for which a topic partition will be suspended for goal optimization if number of repeated movements within the rolling window defined by topic.partition.movement.expiration.ms exceeds the maximum allowed number defined by topic.partition.maximum.movements.";
    private UpdatableSbcGoalsConfig updatableSbcGoalsConfig;

    public Map<String, Object> mergedConfigValues() {
        Map conf = this.originals();
        this.values().forEach((k, v) -> {
            if (v != null) {
                conf.put(k, v);
            }
        });
        return conf;
    }

    public <T> T getConfiguredInstance(String key, Class<T> t) {
        Object o = super.getConfiguredInstance(key, t);
        if (o instanceof CruiseControlConfigurable) {
            ((CruiseControlConfigurable)o).configure(this.mergedConfigValues());
        }
        return (T)o;
    }

    public <T> List<T> getConfiguredInstances(String key, Class<T> t) {
        List objects = super.getConfiguredInstances(key, t);
        for (Object o : objects) {
            if (!(o instanceof CruiseControlConfigurable)) continue;
            ((CruiseControlConfigurable)o).configure(this.mergedConfigValues());
        }
        return objects;
    }

    public <T> List<T> getConfiguredInstances(String key, Class<T> t, Map<String, Object> configOverrides) {
        List objects = super.getConfiguredInstances(key, t, configOverrides);
        Map<String, Object> configPairs = this.mergedConfigValues();
        configPairs.putAll(configOverrides);
        for (Object o : objects) {
            if (!(o instanceof CruiseControlConfigurable)) continue;
            ((CruiseControlConfigurable)o).configure(configPairs);
        }
        return objects;
    }

    public <T> T getConfiguredInstance(String key, Class<T> t, Map<String, Object> configOverrides) {
        Object instance;
        Class c = this.getClass(key);
        try {
            instance = c.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not instantiate class " + c.getName(), e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Could not instantiate class " + c.getName() + " Does it have a public no-argument constructor?", e);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Attempt to get configured instance of null configuration " + t.getName(), e);
        }
        if (!t.isInstance(instance)) {
            throw new IllegalArgumentException(c.getName() + " is not an instance of " + t.getName());
        }
        T o = t.cast(instance);
        if (o instanceof CruiseControlConfigurable) {
            Map<String, Object> configPairs = this.mergedConfigValues();
            configPairs.putAll(configOverrides);
            ((CruiseControlConfigurable)o).configure(configPairs);
        }
        return o;
    }

    private void sanityCheckGoalNames() {
        List goalNames = this.getList(GOALS_CONFIG);
        if (goalNames.isEmpty()) {
            throw new ConfigException("Attempt to configure goals configuration with an empty list of goals.");
        }
        List intraBrokerGoalNames = this.getList(INTRA_BROKER_GOALS_CONFIG);
        if (intraBrokerGoalNames.isEmpty()) {
            throw new ConfigException("Attempt to configure intra-broker goals configuration with an empty list of goals.");
        }
        TreeSet<String> caseInsensitiveGoalNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (String goalName : goalNames) {
            if (caseInsensitiveGoalNames.add(goalName.replaceAll(".*\\.", ""))) continue;
            throw new ConfigException("Attempt to configure goals with case sensitive names.");
        }
        for (String goalName : intraBrokerGoalNames) {
            if (caseInsensitiveGoalNames.add(goalName.replaceAll(".*\\.", ""))) continue;
            throw new ConfigException("Attempt to configure intra-broker goals with case sensitive names.");
        }
        List anomalyDetectionGoalNames = this.getList(ANOMALY_DETECTION_GOALS_CONFIG);
        if (anomalyDetectionGoalNames.stream().anyMatch(g -> !goalNames.contains(g))) {
            throw new ConfigException("Attempt to configure anomaly detection goals as a superset of self healing goals {}.", (Object)anomalyDetectionGoalNames.toString());
        }
        boolean incrementalBalancingEnabled = this.getBoolean(INCREMENTAL_BALANCING_ENABLED_CONFIG);
        List incrementalBalancingGoalNames = this.getList(INCREMENTAL_BALANCING_GOALS_CONFIG);
        if (incrementalBalancingEnabled && incrementalBalancingGoalNames.isEmpty()) {
            throw new ConfigException("Attempt to enable incremental balancing with an empty list of incremental balancing goals.");
        }
    }

    private void sanityCheckSamplingPeriod(Map<?, ?> originals) {
        long samplingIntervalMs = this.getLong(METRIC_SAMPLING_INTERVAL_MS_CONFIG);
        int metadataTimeoutMs = this.getInt(METADATA_CLIENT_TIMEOUT_MS_CONFIG);
        if ((long)metadataTimeoutMs > samplingIntervalMs) {
            throw new ConfigException("Attempt to set metadata refresh timeout [" + metadataTimeoutMs + "] to be longer than sampling period [" + samplingIntervalMs + "].");
        }
        long partitionSampleWindowMs = this.getLong(PARTITION_METRICS_WINDOW_MS_CONFIG);
        short partitionSamplingFrequency = (short)(partitionSampleWindowMs / samplingIntervalMs);
        if (partitionSamplingFrequency > 127) {
            throw new ConfigException(String.format("Configured sampling frequency (%d) exceeds the maximum allowed value (%d). Decrease the value of %s or increase the value of %s to ensure that their ratio is under this limit.", partitionSamplingFrequency, (byte)127, PARTITION_METRICS_WINDOW_MS_CONFIG, METRIC_SAMPLING_INTERVAL_MS_CONFIG));
        }
        long brokerSampleWindowMs = this.getLong(BROKER_METRICS_WINDOW_MS_CONFIG);
        short brokerSamplingFrequency = (short)(brokerSampleWindowMs / samplingIntervalMs);
        if (brokerSamplingFrequency > 127) {
            throw new ConfigException(String.format("Configured sampling frequency (%d) exceeds the maximum allowed value (%d). Decrease the value of %s or increase the value of %s to ensure that their ratio is under this limit.", brokerSamplingFrequency, (byte)127, BROKER_METRICS_WINDOW_MS_CONFIG, METRIC_SAMPLING_INTERVAL_MS_CONFIG));
        }
        if (partitionSampleWindowMs % samplingIntervalMs != 0L) {
            throw new ConfigException(String.format("Configured window size (%d) is not a multiple of configured sample size (%d).", partitionSampleWindowMs, samplingIntervalMs));
        }
        if (brokerSampleWindowMs % samplingIntervalMs != 0L) {
            throw new ConfigException(String.format("Configured window size (%d) is not a multiple of configured sample size (%d).", brokerSampleWindowMs, samplingIntervalMs));
        }
    }

    public KafkaCruiseControlConfig(Map<?, ?> originals) {
        super(CONFIG, originals);
        this.sanityCheckGoalNames();
        this.sanityCheckSamplingPeriod(originals);
    }

    public KafkaCruiseControlConfig(Map<?, ?> originals, boolean doLog) {
        super(CONFIG, originals, doLog);
        this.sanityCheckGoalNames();
        this.sanityCheckSamplingPeriod(originals);
    }

    public KafkaCruiseControlConfig clone(String newConfigKey, Object newConfigValue) {
        return this.clone(Collections.singletonMap(newConfigKey, newConfigValue));
    }

    public KafkaCruiseControlConfig clone(Map<String, Object> newConfigKeyByValues) {
        Map originalInput = this.originals();
        for (Map.Entry<String, Object> stringObjectEntry : newConfigKeyByValues.entrySet()) {
            originalInput.put(stringObjectEntry.getKey(), stringObjectEntry.getValue());
        }
        return new KafkaCruiseControlConfig(originalInput);
    }

    public UpdatableSbcGoalsConfig updatableSbcGoalsConfig() {
        if (this.updatableSbcGoalsConfig == null) {
            List rebalancingGoals = this.getList(GOALS_CONFIG);
            List triggeringGoals = this.getList(ANOMALY_DETECTION_GOALS_CONFIG);
            boolean incrementalBalancingEnabled = this.getBoolean(INCREMENTAL_BALANCING_ENABLED_CONFIG);
            List incrementalBalancingGoals = this.getList(INCREMENTAL_BALANCING_GOALS_CONFIG);
            SbcGoalsConfig goalsConfig = SbcGoalsConfig.builder().rebalancingGoals(rebalancingGoals).triggeringGoals(triggeringGoals).incrementalBalancingEnabled(incrementalBalancingEnabled).incrementalBalancingGoals(incrementalBalancingGoals).build(this);
            this.updatableSbcGoalsConfig = new UpdatableSbcGoalsConfig(goalsConfig);
        }
        return this.updatableSbcGoalsConfig;
    }

    public static String internalGoalsConfigName(String externalName) {
        switch (externalName) {
            case "confluent.balancer.rebalancing.goals": 
            case "rebalancing.goals": {
                return GOALS_CONFIG;
            }
            case "confluent.balancer.triggering.goals": 
            case "triggering.goals": {
                return ANOMALY_DETECTION_GOALS_CONFIG;
            }
        }
        throw new IllegalArgumentException(String.format("The provided config name %s was not recognized.", externalName));
    }

    public static Integer shutdownTimeoutMs(Map<String, Object> config) {
        return (Integer)config.getOrDefault(SHUTDOWN_TIMEOUT_MS_CONFIG, 15000);
    }

    static {
        DEFAULT_LEADER_ACTION_TIMEOUT_MS = 180000L;
        DEFAULT_METADATA_TTL = 10000L;
        DEFAULT_METADATA_CLIENT_TIMEOUT_MS = 180000;
        DEFAULT_PARTITION_METRICS_WINDOW_MS = 360000L;
        DEFAULT_NUM_PARTITION_METRICS_WINDOWS = 6;
        DEFAULT_MIN_SAMPLES_PER_PARTITION_METRICS_WINDOW = 1;
        DEFAULT_BROKER_METRICS_WINDOW_MS = 360000L;
        DEFAULT_NUM_BROKER_METRICS_WINDOWS = 20;
        DEFAULT_MIN_SAMPLES_PER_BROKER_METRICS_WINDOW = 1;
        DEFAULT_METRIC_SAMPLING_INTERVAL_MS = 180000L;
        DEFAULT_MIN_VALID_PARTITION_RATIO = 0.95;
        HOT_PARTITION_CAPACITY_UTILIZATION_THRESHOLD_DEFAULT = 0.2;
        DEFAULT_CPU_BALANCE_THRESHOLD = 1.1;
        DEFAULT_DISK_BALANCE_THRESHOLD = 1.1;
        DEFAULT_NETWORK_INBOUND_BALANCE_THRESHOLD = 1.1;
        DEFAULT_NETWORK_OUTBOUND_BALANCE_THRESHOLD = 1.1;
        DEFAULT_GOAL_VIOLATION_DISTRIBUTION_THRESHOLD_MULTIPLIER = 1.1;
        DEFAULT_CPU_CAPACITY_THRESHOLD = 1.0;
        DEFAULT_DISK_CAPACITY_THRESHOLD = ConfluentConfigs.BALANCER_DISK_CAPACITY_THRESHOLD_DEFAULT;
        DEFAULT_DISK_CAPACITY_MIN_FREE_SPACE = ConfluentConfigs.BALANCER_DISK_MIN_FREE_SPACE_DEFAULT;
        DEFAULT_NETWORK_INBOUND_CAPACITY_THRESHOLD = 0.8;
        DEFAULT_PRODUCER_INBOUND_CAPACITY_THRESHOLD = 0.9;
        DEFAULT_NETWORK_OUTBOUND_CAPACITY_THRESHOLD = 0.8;
        DEFAULT_CPU_LOW_UTILIZATION_THRESHOLD = 0.2;
        DEFAULT_DISK_LOW_UTILIZATION_THRESHOLD = 0.2;
        DEFAULT_NETWORK_INBOUND_LOW_UTILIZATION_THRESHOLD = 0.2;
        DEFAULT_NETWORK_OUTBOUND_LOW_UTILIZATION_THRESHOLD = 0.2;
        DISABLED_THROTTLE = ConfluentConfigs.BALANCER_THROTTLE_NO_THROTTLE;
        AUTO_THROTTLE = ConfluentConfigs.BALANCER_THROTTLE_AUTO_THROTTLE;
        DEFAULT_THROTTLE_VALUE = ConfluentConfigs.BALANCER_THROTTLE_DEFAULT;
        SBC_HARD_GOALS = Arrays.asList(MovementExclusionGoal.class.getName(), ReplicaPlacementGoal.class.getName(), RackAwareGoal.class.getName(), MaxReplicaMovementParallelismGoal.class.getName(), ReplicaCapacityGoal.class.getName(), DiskCapacityGoal.class.getName(), NetworkInboundCapacityGoal.class.getName(), NetworkOutboundCapacityGoal.class.getName(), ProducerInboundCapacityGoal.class.getName());
        SBC_V1_SOFT_GOALS = Arrays.asList(SystemTopicEvenDistributionGoal.class.getName(), ReplicaDistributionGoal.class.getName(), DiskUsageDistributionGoal.class.getName(), LeaderReplicaDistributionGoal.class.getName(), NetworkInboundUsageDistributionGoal.class.getName(), NetworkOutboundUsageDistributionGoal.class.getName(), CpuUsageDistributionGoal.class.getName(), TopicReplicaDistributionGoal.class.getName(), LeaderBytesInDistributionGoal.class.getName());
        DEFAULT_GOALS_LIST = Stream.concat(SBC_HARD_GOALS.stream(), SBC_V1_SOFT_GOALS.stream()).collect(Collectors.toList());
        DEFAULT_ANOMALY_NOTIFIER_CLASS = SelfHealingNotifier.class.getName();
        DEFAULT_EXECUTOR_NOTIFIER_CLASS = ExecutorNoopNotifier.class.getName();
        DEFAULT_ANOMALY_DETECTION_INTERVAL_MS = 60000;
        DEFAULT_ANOMALY_DETECTION_GOALS_LIST = Arrays.asList(ReplicaPlacementGoal.class.getName(), RackAwareGoal.class.getName(), MaxReplicaMovementParallelismGoal.class.getName(), ReplicaCapacityGoal.class.getName(), DiskCapacityGoal.class.getName(), NetworkInboundCapacityGoal.class.getName(), NetworkOutboundCapacityGoal.class.getName(), ProducerInboundCapacityGoal.class.getName(), ReplicaDistributionGoal.class.getName(), DiskUsageDistributionGoal.class.getName());
        GOAL_VIOLATION_DELAY_ON_NEW_BROKERS_MS_DEFAULT = 1800000L;
        DEFAULT_BROKER_FAILURE_ALERT_THRESHOLD_MS = 0L;
        DEFAULT_BROKER_FAILURE_SELF_HEALING_THRESHOLD_MS = 1800000L;
        LOGDIR_REPSONSE_TIMEOUT_MS_DEFAULT = 30000;
        DEFAULT_DESCRIBE_TOPICS_RESPONSE_TIMEOUT_MS = 30000;
        DEFAULT_DESCRIBE_CLUSTER_RESPONSE_TIMEOUT_MS = 30000;
        DEFAULT_DESCRIBE_CONFIGS_RESPONSE_TIMEOUT_MS = 30000;
        DEFAULT_DESCRIBE_CONFIGS_BATCH_SIZE = 1000;
        DEFAULT_BROKER_REMOVAL_SHUTDOWN_MS = 600000L;
        DEFAULT_BROKER_REPLICA_EXCLUSION_TIMEOUT_MS = 120000;
        DEFAULT_DESCRIBE_BROKER_REPLICA_EXCLUSION_TIMEOUT_MS = 60000;
        DEFAULT_WRITE_THROUGHPUT_MULTIPLIER = 1.0;
        DEFAULT_READ_THROUGHPUT_MULTIPLIER = 1.0;
        PLAN_COMPUTATION_RETRY_TIMEOUT_MS_DEFAULT = TimeUnit.HOURS.toMillis(1L);
        INVALID_REPLICA_ASSIGNMENT_RETRY_TIMEOUT_MS_DEFAULT = TimeUnit.MINUTES.toMillis(5L);
        EXECUTOR_REFRESH_TIME_MS_DEFAULT = TimeUnit.MINUTES.toMillis(1L);
        CAPACITY_BALANCING_DELTA_PERCENTAGE_DEFAULT = BalancerConfigs.BALANCER_CAPACITY_BALANCING_DELTA_PERCENTAGE_CONFIG_DEFAULT;
        INCREMENTAL_BALANCING_ENABLED_DEFAULT = BalancerConfigs.BALANCER_INCREMENTAL_BALANCING_ENABLED_DEFAULT;
        SBC_V2_SOFT_GOALS = Collections.singletonList(IncrementalCPUResourceDistributionGoal.class.getName());
        INCREMENTAL_BALANCING_DEFAULT_GOALS_LIST = Stream.concat(SBC_HARD_GOALS.stream(), SBC_V2_SOFT_GOALS.stream()).collect(Collectors.toList());
        INCREMENTAL_BALANCING_STEP_RATIO_DEFAULT = BalancerConfigs.BALANCER_INCREMENTAL_BALANCING_STEP_RATIO_DEFAULT;
        INCREMENTAL_BALANCING_LOWER_BOUND_DEFAULT = BalancerConfigs.BALANCER_INCREMENTAL_BALANCING_LOWER_BOUND_DEFAULT;
        CONFIG = new ConfigDef().define(BOOTSTRAP_SERVERS_CONFIG, ConfigDef.Type.LIST, ConfigDef.Importance.HIGH, "A list of host/port pairs to use for establishing the initial connection to the Kafka cluster. The client will make use of all servers irrespective of which servers are specified here for bootstrapping&mdash;this list only impacts the initial hosts used to discover the full set of servers. This list should be in the form <code>host1:port1,host2:port2,...</code>. Since these servers are just used for the initial connection to discover the full cluster membership (which may change dynamically), this list need not contain the full set of servers (you may want more than one, though, in case a server is down).").define(CLIENT_ID_CONFIG, ConfigDef.Type.STRING, (Object)"kafka-cruise-control", ConfigDef.Importance.MEDIUM, "An id string to pass to the server when making requests. The purpose of this is to be able to track the source of requests beyond just ip/port by allowing a logical application name to be included in server-side request logging.").define(SEND_BUFFER_CONFIG, ConfigDef.Type.INT, (Object)131072, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "The size of the TCP send buffer (SO_SNDBUF) to use when sending data. If the value is -1, the OS default will be used.").define(RECEIVE_BUFFER_CONFIG, ConfigDef.Type.INT, (Object)32768, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "The size of the TCP receive buffer (SO_RCVBUF) to use when reading data. If the value is -1, the OS default will be used.").define(RECONNECT_BACKOFF_MS_CONFIG, ConfigDef.Type.LONG, (Object)50L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0L), ConfigDef.Importance.LOW, "The base amount of time to wait before attempting to reconnect to a given host. This avoids repeatedly connecting to a host in a tight loop. This backoff applies to all connection attempts by the client to a broker.").define(CONNECTIONS_MAX_IDLE_MS_CONFIG, ConfigDef.Type.LONG, (Object)540000, ConfigDef.Importance.MEDIUM, "Close idle connections after the number of milliseconds specified by this config.").define(REQUEST_TIMEOUT_MS_CONFIG, ConfigDef.Type.INT, (Object)30000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, REQUEST_TIMEOUT_MS_DOC).define(DEFAULT_API_TIMEOUT_MS_CONFIG, ConfigDef.Type.INT, (Object)60000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, DEFAULT_API_TIMEOUT_MS_DOC).define(METADATA_TTL_CONFIG, ConfigDef.Type.LONG, (Object)DEFAULT_METADATA_TTL, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.HIGH, METADATA_TTL_DOC).define(METADATA_CLIENT_TIMEOUT_MS_CONFIG, ConfigDef.Type.INT, (Object)DEFAULT_METADATA_CLIENT_TIMEOUT_MS, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.HIGH, METADATA_CLIENT_TIMEOUT_MS_DOC).define(LEADER_ACTION_TIMEOUT_MS_CONFIG, ConfigDef.Type.LONG, (Object)DEFAULT_LEADER_ACTION_TIMEOUT_MS, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, LEADER_ACTION_TIMEOUT_MS_DOC).define(PARTITION_METRICS_WINDOW_MS_CONFIG, ConfigDef.Type.LONG, (Object)DEFAULT_PARTITION_METRICS_WINDOW_MS, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, PARTITION_METRICS_WINDOW_MS_DOC).define(NUM_PARTITION_METRICS_WINDOWS_CONFIG, ConfigDef.Type.INT, (Object)DEFAULT_NUM_PARTITION_METRICS_WINDOWS, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, NUM_PARTITION_METRICS_WINDOWS_DOC).define(MIN_SAMPLES_PER_PARTITION_METRICS_WINDOW_CONFIG, ConfigDef.Type.INT, (Object)DEFAULT_MIN_SAMPLES_PER_PARTITION_METRICS_WINDOW, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, MIN_SAMPLES_PER_PARTITION_METRICS_WINDOW_DOC).define(MAX_ALLOWED_EXTRAPOLATIONS_PER_PARTITION_CONFIG, ConfigDef.Type.INT, (Object)5, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, MAX_ALLOWED_EXTRAPOLATIONS_PER_PARTITION_DOC).define(PARTITION_METRIC_SAMPLE_AGGREGATOR_COMPLETENESS_CACHE_SIZE_CONFIG, ConfigDef.Type.INT, (Object)5, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, "The metric sample aggregator caches the completeness metadata for fast query. The completeness describes the confidence level of the data in the metric sample aggregator. It is primarily measured by the validity of the metricssamples in different windows. This configuration configures The number of completeness cache slots to maintain.").define(BROKER_METRICS_WINDOW_MS_CONFIG, ConfigDef.Type.LONG, (Object)DEFAULT_BROKER_METRICS_WINDOW_MS, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, BROKER_METRICS_WINDOW_MS_DOC).define(REMOVAL_HISTORY_RETENTION_TIME_MS_CONFIG, ConfigDef.Type.LONG, (Object)TimeUnit.HOURS.toMillis(24L), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, REMOVAL_HISTORY_RETENTION_TIME_MS_DOC).define(NUM_BROKER_METRICS_WINDOWS_CONFIG, ConfigDef.Type.INT, (Object)DEFAULT_NUM_BROKER_METRICS_WINDOWS, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, NUM_BROKER_METRICS_WINDOWS_DOC).define(MIN_SAMPLES_PER_BROKER_METRICS_WINDOW_CONFIG, ConfigDef.Type.INT, (Object)DEFAULT_MIN_SAMPLES_PER_BROKER_METRICS_WINDOW, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, MIN_SAMPLES_PER_BROKER_METRICS_WINDOW_DOC).define(MAX_ALLOWED_EXTRAPOLATIONS_PER_BROKER_CONFIG, ConfigDef.Type.INT, (Object)5, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, MAX_ALLOWED_EXTRAPOLATIONS_PER_BROKER_DOC).define(BROKER_METRIC_SAMPLE_AGGREGATOR_COMPLETENESS_CACHE_SIZE_CONFIG, ConfigDef.Type.INT, (Object)5, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, "The metric sample aggregator caches the completeness metadata for fast query. The completeness describes the confidence level of the data in the metric sample aggregator. It is primarily measured by the validity of the metricssamples in different windows. This configuration configures The number of completeness cache slots to maintain.").define("security.protocol", ConfigDef.Type.STRING, (Object)"PLAINTEXT", ConfigDef.Importance.MEDIUM, CommonClientConfigs.SECURITY_PROTOCOL_DOC).define(NUM_METRIC_FETCHERS_CONFIG, ConfigDef.Type.INT, (Object)1, ConfigDef.Importance.HIGH, NUM_METRIC_FETCHERS_DOC).define(NUM_CACHED_RECENT_ANOMALY_STATES_CONFIG, ConfigDef.Type.INT, (Object)10, (ConfigDef.Validator)ConfigDef.Range.between((Number)1, (Number)100), ConfigDef.Importance.LOW, NUM_CACHED_RECENT_ANOMALY_STATES_DOC).define(METRIC_SAMPLER_CLASS_CONFIG, ConfigDef.Type.CLASS, (Object)METRIC_SAMPLER_CLASS_DEFAULT, ConfigDef.Importance.HIGH, METRIC_SAMPLER_CLASS_DOC).define(METRIC_SAMPLER_PARTITION_ASSIGNOR_CLASS_CONFIG, ConfigDef.Type.CLASS, (Object)DefaultMetricSamplerPartitionAssignor.class.getName(), ConfigDef.Importance.LOW, METRIC_SAMPLER_PARTITION_ASSIGNOR_CLASS_DOC).define(METRIC_SAMPLING_INTERVAL_MS_CONFIG, ConfigDef.Type.LONG, (Object)DEFAULT_METRIC_SAMPLING_INTERVAL_MS, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.HIGH, METRIC_SAMPLING_INTERVAL_MS_DOC).define(BROKER_CAPACITY_CONFIG_RESOLVER_CLASS_CONFIG, ConfigDef.Type.CLASS, (Object)BrokerCapacityResolver.class.getName(), ConfigDef.Importance.MEDIUM, BROKER_CAPACITY_CONFIG_RESOLVER_CLASS_DOC).define(NETWORK_IN_CAPACITY_BYTES_CONFIG, ConfigDef.Type.LONG, (Object)ConfluentConfigs.BALANCER_NETWORK_IN_CAPACITY_DEFAULT, ConfigDef.Importance.HIGH, NETWORK_IN_CAPACITY_BYTES_DOC).define(PRODUCER_IN_CAPACITY_BYTES_CONFIG, ConfigDef.Type.LONG, (Object)BalancerConfigs.BALANCER_PRODUCER_IN_CAPACITY_DEFAULT, ConfigDef.Importance.HIGH, "This config specifies the upper capacity limit for producer incoming bytes per second per broker. The Confluent DataBalancer will attempt to keep incoming data throughput below this limit.").define(NETWORK_OUT_CAPACITY_BYTES_CONFIG, ConfigDef.Type.LONG, (Object)ConfluentConfigs.BALANCER_NETWORK_OUT_CAPACITY_DEFAULT, ConfigDef.Importance.HIGH, NETWORK_OUT_CAPACITY_BYTES_DOC).define(GOAL_BALANCEDNESS_PRIORITY_WEIGHT_CONFIG, ConfigDef.Type.DOUBLE, (Object)1.1, (ConfigDef.Validator)ConfigDef.Range.between((Number)1, (Number)2), ConfigDef.Importance.LOW, GOAL_BALANCEDNESS_PRIORITY_WEIGHT_DOC).define(GOAL_BALANCEDNESS_STRICTNESS_WEIGHT_CONFIG, ConfigDef.Type.DOUBLE, (Object)1.5, (ConfigDef.Validator)ConfigDef.Range.between((Number)1, (Number)2), ConfigDef.Importance.LOW, GOAL_BALANCEDNESS_STRICTNESS_WEIGHT_DOC).define(MIN_VALID_PARTITION_RATIO_CONFIG, ConfigDef.Type.DOUBLE, (Object)DEFAULT_MIN_VALID_PARTITION_RATIO, (ConfigDef.Validator)ConfigDef.Range.between((Number)0, (Number)1), ConfigDef.Importance.HIGH, MIN_VALID_PARTITION_RATIO_DOC).define(LEADER_NETWORK_INBOUND_WEIGHT_FOR_CPU_UTIL_CONFIG, ConfigDef.Type.DOUBLE, (Object)0.7, (ConfigDef.Validator)ConfigDef.Range.between((Number)0, (Number)1), ConfigDef.Importance.MEDIUM, LEADER_NETWORK_INBOUND_WEIGHT_FOR_CPU_UTIL_DOC).define(LEADER_NETWORK_OUTBOUND_WEIGHT_FOR_CPU_UTIL_CONFIG, ConfigDef.Type.DOUBLE, (Object)0.15, (ConfigDef.Validator)ConfigDef.Range.between((Number)0, (Number)1), ConfigDef.Importance.MEDIUM, LEADER_NETWORK_OUTBOUND_WEIGHT_FOR_CPU_UTIL_DOC).define(FOLLOWER_NETWORK_INBOUND_WEIGHT_FOR_CPU_UTIL_CONFIG, ConfigDef.Type.DOUBLE, (Object)0.15, (ConfigDef.Validator)ConfigDef.Range.between((Number)0, (Number)1), ConfigDef.Importance.MEDIUM, FOLLOWER_NETWORK_INBOUND_WEIGHT_FOR_CPU_UTIL_DOC).define(HOT_PARTITION_CAPACITY_UTILIZATION_THRESHOLD_CONFIG, ConfigDef.Type.DOUBLE, (Object)HOT_PARTITION_CAPACITY_UTILIZATION_THRESHOLD_DEFAULT, (ConfigDef.Validator)ConfigDef.Range.between((Number)0, (Number)1), ConfigDef.Importance.LOW, HOT_PARTITION_CAPACITY_UTILIZATION_THRESHOLD_DOC).define(CPU_BALANCE_THRESHOLD_CONFIG, ConfigDef.Type.DOUBLE, (Object)DEFAULT_CPU_BALANCE_THRESHOLD, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, CPU_BALANCE_THRESHOLD_DOC).define(DISK_BALANCE_THRESHOLD_CONFIG, ConfigDef.Type.DOUBLE, (Object)DEFAULT_DISK_BALANCE_THRESHOLD, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, DISK_BALANCE_THRESHOLD_DOC).define(NETWORK_INBOUND_BALANCE_THRESHOLD_CONFIG, ConfigDef.Type.DOUBLE, (Object)DEFAULT_NETWORK_INBOUND_BALANCE_THRESHOLD, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, NETWORK_INBOUND_BALANCE_THRESHOLD_DOC).define(NETWORK_OUTBOUND_BALANCE_THRESHOLD_CONFIG, ConfigDef.Type.DOUBLE, (Object)DEFAULT_NETWORK_OUTBOUND_BALANCE_THRESHOLD, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, NETWORK_OUTBOUND_BALANCE_THRESHOLD_DOC).define(REPLICA_COUNT_BALANCE_THRESHOLD_CONFIG, ConfigDef.Type.DOUBLE, (Object)1.1, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, REPLICA_COUNT_BALANCE_THRESHOLD_DOC).define(LEADER_REPLICA_COUNT_BALANCE_THRESHOLD_CONFIG, ConfigDef.Type.DOUBLE, (Object)1.1, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, LEADER_REPLICA_COUNT_BALANCE_THRESHOLD_DOC).define(TOPIC_REPLICA_COUNT_BALANCE_THRESHOLD_CONFIG, ConfigDef.Type.DOUBLE, (Object)3.0, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, TOPIC_REPLICA_COUNT_BALANCE_THRESHOLD_DOC).define(DISK_CAPACITY_MIN_FREE_SPACE_CONFIG, ConfigDef.Type.INT, (Object)DEFAULT_DISK_CAPACITY_MIN_FREE_SPACE, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.HIGH, DISK_CAPACITY_MIN_FREE_SPACE_DOC).define(GOAL_VIOLATION_DISTRIBUTION_THRESHOLD_MULTIPLIER_CONFIG, ConfigDef.Type.DOUBLE, (Object)DEFAULT_GOAL_VIOLATION_DISTRIBUTION_THRESHOLD_MULTIPLIER, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, GOAL_VIOLATION_DISTRIBUTION_THRESHOLD_MULTIPLIER_DOC).define(CPU_CAPACITY_THRESHOLD_CONFIG, ConfigDef.Type.DOUBLE, (Object)DEFAULT_CPU_CAPACITY_THRESHOLD, (ConfigDef.Validator)ConfigDef.Range.between((Number)0, (Number)1), ConfigDef.Importance.HIGH, CPU_CAPACITY_THRESHOLD_DOC).define(DISK_CAPACITY_THRESHOLD_CONFIG, ConfigDef.Type.DOUBLE, (Object)DEFAULT_DISK_CAPACITY_THRESHOLD, (ConfigDef.Validator)ConfigDef.Range.between((Number)0, (Number)1), ConfigDef.Importance.HIGH, DISK_CAPACITY_THRESHOLD_DOC).define(NETWORK_INBOUND_CAPACITY_THRESHOLD_CONFIG, ConfigDef.Type.DOUBLE, (Object)DEFAULT_NETWORK_INBOUND_CAPACITY_THRESHOLD, (ConfigDef.Validator)ConfigDef.Range.between((Number)0, (Number)1), ConfigDef.Importance.HIGH, NETWORK_INBOUND_CAPACITY_THRESHOLD_DOC).define(PRODUCER_INBOUND_CAPACITY_THRESHOLD_CONFIG, ConfigDef.Type.DOUBLE, (Object)DEFAULT_PRODUCER_INBOUND_CAPACITY_THRESHOLD, (ConfigDef.Validator)ConfigDef.Range.between((Number)0, (Number)1), ConfigDef.Importance.HIGH, PRODUCER_INBOUND_CAPACITY_THRESHOLD_DOC).define(NETWORK_OUTBOUND_CAPACITY_THRESHOLD_CONFIG, ConfigDef.Type.DOUBLE, (Object)DEFAULT_NETWORK_OUTBOUND_CAPACITY_THRESHOLD, (ConfigDef.Validator)ConfigDef.Range.between((Number)0, (Number)1), ConfigDef.Importance.HIGH, NETWORK_OUTBOUND_CAPACITY_THRESHOLD_DOC).define(CPU_LOW_UTILIZATION_THRESHOLD_CONFIG, ConfigDef.Type.DOUBLE, (Object)DEFAULT_CPU_LOW_UTILIZATION_THRESHOLD, (ConfigDef.Validator)ConfigDef.Range.between((Number)0, (Number)1), ConfigDef.Importance.MEDIUM, CPU_LOW_UTILIZATION_THRESHOLD_DOC).define(DISK_LOW_UTILIZATION_THRESHOLD_CONFIG, ConfigDef.Type.DOUBLE, (Object)DEFAULT_DISK_LOW_UTILIZATION_THRESHOLD, (ConfigDef.Validator)ConfigDef.Range.between((Number)0, (Number)1), ConfigDef.Importance.MEDIUM, DISK_LOW_UTILIZATION_THRESHOLD_DOC).define(NETWORK_INBOUND_LOW_UTILIZATION_THRESHOLD_CONFIG, ConfigDef.Type.DOUBLE, (Object)DEFAULT_NETWORK_INBOUND_LOW_UTILIZATION_THRESHOLD, (ConfigDef.Validator)ConfigDef.Range.between((Number)0, (Number)1), ConfigDef.Importance.MEDIUM, NETWORK_INBOUND_LOW_UTILIZATION_THRESHOLD_DOC).define(NETWORK_OUTBOUND_LOW_UTILIZATION_THRESHOLD_CONFIG, ConfigDef.Type.DOUBLE, (Object)DEFAULT_NETWORK_OUTBOUND_LOW_UTILIZATION_THRESHOLD, (ConfigDef.Validator)ConfigDef.Range.between((Number)0, (Number)1), ConfigDef.Importance.MEDIUM, NETWORK_OUTBOUND_LOW_UTILIZATION_THRESHOLD_DOC).define(MAX_REPLICAS_PER_BROKER_CONFIG, ConfigDef.Type.LONG, (Object)ConfluentConfigs.BALANCER_REPLICA_CAPACITY_DEFAULT, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, MAX_REPLICAS_PER_BROKER_DOC).define(ZOOKEEPER_CONNECT_CONFIG, ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, ZOOKEEPER_CONNECT_DOC).define(ZOOKEEPER_SECURITY_ENABLED_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.HIGH, ZOOKEEPER_SECURITY_ENABLED_DOC).define(NUM_CONCURRENT_PARTITION_MOVEMENTS_PER_BROKER_CONFIG, ConfigDef.Type.INT, (Object)5, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, NUM_CONCURRENT_PARTITION_MOVEMENTS_PER_BROKER_DOC).define(NUM_CONCURRENT_INTRA_BROKER_PARTITION_MOVEMENTS_CONFIG, ConfigDef.Type.INT, (Object)2, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, NUM_CONCURRENT_INTRA_BROKER_PARTITION_MOVEMENTS_DOC).define(NUM_CONCURRENT_LEADER_MOVEMENTS_CONFIG, ConfigDef.Type.INT, (Object)1000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, NUM_CONCURRENT_LEADER_MOVEMENTS_DOC).define(REPLICATION_THROTTLE_CONFIG, ConfigDef.Type.LONG, (Object)DEFAULT_THROTTLE_VALUE, ConfigDef.Importance.MEDIUM, REPLICATION_THROTTLE_DOC).define(REPLICA_MOVEMENT_STRATEGIES_CONFIG, ConfigDef.Type.LIST, (Object)String.join((CharSequence)",", PostponeUrpReplicaMovementStrategy.class.getName(), PrioritizeLargeReplicaMovementStrategy.class.getName(), PrioritizeSmallReplicaMovementStrategy.class.getName(), BaseReplicaMovementStrategy.class.getName()), ConfigDef.Importance.MEDIUM, REPLICA_MOVEMENT_STRATEGIES_DOC).define(DEFAULT_REPLICA_MOVEMENT_STRATEGIES_CONFIG, ConfigDef.Type.LIST, (Object)BaseReplicaMovementStrategy.class.getName(), ConfigDef.Importance.MEDIUM, DEFAULT_REPLICA_MOVEMENT_STRATEGIES_DOC).define(EXECUTION_PROGRESS_CHECK_INTERVAL_MS_CONFIG, ConfigDef.Type.LONG, (Object)7000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, EXECUTION_PROGRESS_CHECK_INTERVAL_MS_DOC).define(GOALS_CONFIG, ConfigDef.Type.LIST, (Object)String.join((CharSequence)",", DEFAULT_GOALS_LIST), ConfigDef.Importance.HIGH, GOALS_DOC).define(INTRA_BROKER_GOALS_CONFIG, ConfigDef.Type.LIST, (Object)String.join((CharSequence)",", IntraBrokerDiskCapacityGoal.class.getName(), IntraBrokerDiskUsageDistributionGoal.class.getName()), ConfigDef.Importance.HIGH, INTRA_BROKER_GOALS_DOC).define(ANOMALY_NOTIFIER_CLASS_CONFIG, ConfigDef.Type.CLASS, (Object)DEFAULT_ANOMALY_NOTIFIER_CLASS, ConfigDef.Importance.LOW, ANOMALY_NOTIFIER_CLASS_DOC).define(EXECUTOR_NOTIFIER_CLASS_CONFIG, ConfigDef.Type.CLASS, (Object)DEFAULT_EXECUTOR_NOTIFIER_CLASS, ConfigDef.Importance.LOW, EXECUTOR_NOTIFIER_CLASS_DOC).define(ANOMALY_DETECTION_INTERVAL_MS_CONFIG, ConfigDef.Type.LONG, (Object)DEFAULT_ANOMALY_DETECTION_INTERVAL_MS, ConfigDef.Importance.LOW, ANOMALY_DETECTION_INTERVAL_MS_DOC).define(ANOMALY_DETECTION_ALLOW_CAPACITY_ESTIMATION_CONFIG, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, ANOMALY_DETECTION_ALLOW_CAPACITY_ESTIMATION_DOC).define(SAMPLING_ALLOW_CPU_CAPACITY_ESTIMATION_CONFIG, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, SAMPLING_ALLOW_CPU_CAPACITY_ESTIMATION_DOC).define(ANOMALY_DETECTION_GOALS_CONFIG, ConfigDef.Type.LIST, (Object)String.join((CharSequence)",", DEFAULT_ANOMALY_DETECTION_GOALS_LIST), ConfigDef.Importance.MEDIUM, ANOMALY_DETECTION_GOALS_DOC).define(BROKER_FAILURE_EXCLUDE_RECENTLY_REMOVED_BROKERS_CONFIG, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.MEDIUM, BROKER_FAILURE_EXCLUDE_RECENTLY_REMOVED_BROKERS_DOC).define(GOAL_VIOLATION_EXCLUDE_RECENTLY_REMOVED_BROKERS_CONFIG, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.MEDIUM, GOAL_VIOLATION_EXCLUDE_RECENTLY_REMOVED_BROKERS_DOC).define(GOAL_VIOLATION_DELAY_ON_NEW_BROKER_MS_CONFIG, ConfigDef.Type.LONG, (Object)GOAL_VIOLATION_DELAY_ON_NEW_BROKERS_MS_DEFAULT, ConfigDef.Importance.MEDIUM, GOAL_VIOLATION_DELAY_ON_NEW_BROKER_MS_DOC).define(TOPICS_EXCLUDED_FROM_PARTITION_MOVEMENT_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, TOPICS_EXCLUDED_FROM_PARTITION_MOVEMENT_DOC).define(PARTITION_METRIC_SAMPLE_STORE_TOPIC_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_PARTITION_SAMPLE_STORE_TOPIC, ConfigDef.Importance.MEDIUM, PARTITION_METRIC_SAMPLE_STORE_TOPIC_DOC).define(BROKER_METRIC_SAMPLE_STORE_TOPIC_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_BROKER_SAMPLE_STORE_TOPIC, ConfigDef.Importance.MEDIUM, BROKER_METRIC_SAMPLE_STORE_TOPIC_DOC).define(LOGDIR_RESPONSE_TIMEOUT_MS_CONFIG, ConfigDef.Type.INT, (Object)LOGDIR_REPSONSE_TIMEOUT_MS_DEFAULT, ConfigDef.Importance.LOW, LOGDIR_RESPONSE_TIMEOUT_MS_DOC).define(DESCRIBE_TOPICS_RESPONSE_TIMEOUT_MS_CONFIG, ConfigDef.Type.INT, (Object)DEFAULT_DESCRIBE_TOPICS_RESPONSE_TIMEOUT_MS, ConfigDef.Importance.LOW, DESCRIBE_TOPICS_RESPONSE_TIMEOUT_MS_DOC).define(DESCRIBE_CLUSTER_RESPONSE_TIMEOUT_MS_CONFIG, ConfigDef.Type.INT, (Object)DEFAULT_DESCRIBE_CLUSTER_RESPONSE_TIMEOUT_MS, ConfigDef.Importance.LOW, DESCRIBE_CLUSTER_RESPONSE_TIMEOUT_MS_DOC).define(DESCRIBE_CONFIGS_RESPONSE_TIMEOUT_MS_CONFIG, ConfigDef.Type.INT, (Object)DEFAULT_DESCRIBE_CONFIGS_RESPONSE_TIMEOUT_MS, ConfigDef.Importance.LOW, DESCRIBE_CONFIGS_RESPONSE_TIMEOUT_MS_DOC).define(DESCRIBE_CONFIGS_BATCH_SIZE_CONFIG, ConfigDef.Type.INT, (Object)DEFAULT_DESCRIBE_CONFIGS_BATCH_SIZE, ConfigDef.Importance.LOW, DESCRIBE_CONFIGS_BATCH_SIZE_DOC).define(BROKER_REMOVAL_SHUTDOWN_MS_CONFIG, ConfigDef.Type.LONG, (Object)DEFAULT_BROKER_REMOVAL_SHUTDOWN_MS, ConfigDef.Importance.LOW, BROKER_REMOVAL_SHUTDOWN_MS_DOC).define(BROKER_REPLICA_EXCLUSION_TIMEOUT_MS_CONFIG, ConfigDef.Type.INT, (Object)DEFAULT_BROKER_REPLICA_EXCLUSION_TIMEOUT_MS, ConfigDef.Importance.LOW, BROKER_REPLICA_EXCLUSION_TIMEOUT_MS_DOC).define(DESCRIBE_BROKER_REPLICA_EXCLUSION_TIMEOUT_MS_CONFIG, ConfigDef.Type.INT, (Object)DEFAULT_DESCRIBE_BROKER_REPLICA_EXCLUSION_TIMEOUT_MS, ConfigDef.Importance.LOW, DESCRIBE_BROKER_REPLICA_EXCLUSION_TIMEOUT_MS_DOC).define(MAX_VOLUME_THROUGHPUT_MB_CONFIG, ConfigDef.Type.INT, (Object)0, ConfigDef.Importance.MEDIUM, MAX_VOLUME_THROUGHPUT_MB_DOC).define(WRITE_THROUGHPUT_MULTIPLIER_CONFIG, ConfigDef.Type.DOUBLE, (Object)DEFAULT_WRITE_THROUGHPUT_MULTIPLIER, ConfigDef.Importance.MEDIUM, WRITE_THROUGHPUT_MULTIPLIER_DOC).define(READ_THROUGHPUT_MULTIPLIER_CONFIG, ConfigDef.Type.DOUBLE, (Object)DEFAULT_READ_THROUGHPUT_MULTIPLIER, ConfigDef.Importance.MEDIUM, READ_THROUGHPUT_MULTIPLIER_DOC).define(CALCULATED_THROTTLE_RATIO_CONFIG, ConfigDef.Type.DOUBLE, (Object)0.8, ConfigDef.Importance.MEDIUM, CALCULATED_THROTTLE_RATIO_DOC).define(DISK_READ_RATIO_CONFIG, ConfigDef.Type.DOUBLE, (Object)0.2, ConfigDef.Importance.MEDIUM, DISK_READ_RATIO_DOC).define(OVERRIDE_STATIC_THROTTLES_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.HIGH, OVERRIDE_STATIC_THROTTLES_DOC).define(SELF_HEALING_BROKER_FAILURE_ENABLED_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.HIGH, SELF_HEALING_BROKER_FAILURE_ENABLED_DOC).define(SELF_HEALING_GOAL_VIOLATION_ENABLED_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.HIGH, SELF_HEALING_GOAL_VIOLATION_ENABLED_DOC).define(BROKER_FAILURE_ALERT_THRESHOLD_MS_CONFIG, ConfigDef.Type.LONG, (Object)DEFAULT_BROKER_FAILURE_ALERT_THRESHOLD_MS, ConfigDef.Importance.LOW, BROKER_FAILURE_ALERT_THRESHOLD_MS_DOC).define(BROKER_FAILURE_SELF_HEALING_THRESHOLD_MS_CONFIG, ConfigDef.Type.LONG, (Object)DEFAULT_BROKER_FAILURE_SELF_HEALING_THRESHOLD_MS, ConfigDef.Importance.HIGH, BROKER_FAILURE_SELF_HEALING_THRESHOLD_MS_DOC).define(PLAN_COMPUTATION_RETRY_TIMEOUT_MS_CONFIG, ConfigDef.Type.LONG, (Object)PLAN_COMPUTATION_RETRY_TIMEOUT_MS_DEFAULT, ConfigDef.Importance.LOW, PLAN_COMPUTATION_RETRY_INTERVAL_MS_DOC).define(INVALID_REPLICA_ASSIGNMENT_RETRY_TIMEOUT_MS_CONFIG, ConfigDef.Type.LONG, (Object)INVALID_REPLICA_ASSIGNMENT_RETRY_TIMEOUT_MS_DEFAULT, ConfigDef.Importance.LOW, INVALID_REPLICA_ASSIGNMENT_RETRY_TIMEOUT_MS_DOC).define(EXECUTOR_REFRESH_TIME_MS_CONFIG, ConfigDef.Type.LONG, (Object)EXECUTOR_REFRESH_TIME_MS_DEFAULT, ConfigDef.Importance.LOW, EXECUTOR_REFRESH_TIME_MS_DOC).define(SHUTDOWN_TIMEOUT_MS_CONFIG, ConfigDef.Type.INT, (Object)15000, ConfigDef.Importance.LOW, SHUTDOWN_TIMEOUT_MS_DOC).define(CC_STARTUP_RETRY_DURATION_HOURS_CONFIG, ConfigDef.Type.INT, (Object)2, ConfigDef.Importance.LOW, CC_STARTUP_RETRY_DURATION_HOURS_DOC).define(CC_STARTUP_RETRY_DELAY_MINUTES_CONFIG, ConfigDef.Type.INT, (Object)5, ConfigDef.Importance.LOW, CC_STARTUP_RETRY_DELAY_MINUTES_DOC).define(INCREMENTAL_BALANCING_ENABLED_CONFIG, ConfigDef.Type.BOOLEAN, (Object)INCREMENTAL_BALANCING_ENABLED_DEFAULT, ConfigDef.Importance.HIGH, INCREMENTAL_BALANCING_ENABLED_DOC).define(CAPACITY_BALANCING_DELTA_PERCENTAGE_CONFIG, ConfigDef.Type.DOUBLE, (Object)CAPACITY_BALANCING_DELTA_PERCENTAGE_DEFAULT, ConfigDef.Importance.MEDIUM, CAPACITY_BALANCING_DELTA_PERCENTAGE_DOC).define(INCREMENTAL_BALANCING_GOALS_CONFIG, ConfigDef.Type.LIST, INCREMENTAL_BALANCING_DEFAULT_GOALS_LIST, ConfigDef.Importance.HIGH, INCREMENTAL_BALANCING_GOALS_DOC).define(INCREMENTAL_BALANCING_STEP_RATIO_CONFIG, ConfigDef.Type.DOUBLE, (Object)INCREMENTAL_BALANCING_STEP_RATIO_DEFAULT, ConfigDef.Importance.HIGH, INCREMENTAL_BALANCING_STEP_RATIO_DOC).define(INCREMENTAL_BALANCING_LOWER_BOUND_CONFIG, ConfigDef.Type.DOUBLE, (Object)INCREMENTAL_BALANCING_LOWER_BOUND_DEFAULT, ConfigDef.Importance.HIGH, INCREMENTAL_BALANCING_LOWER_BOUND_DOC).define("incremental.balancing.cpu.top.proposal.tracking.num.proposals", ConfigDef.Type.INT, (Object)BalancerConfigs.BALANCER_INCREMENTAL_CPU_BALANCING_TOP_PROPOSAL_TRACKING_NUM_PROPOSALS_DEFAULT, ConfigDef.Importance.LOW, "An integer denoting the number of proposals to track per broker with relation to the top proposal tracking functionality.").define("incremental.balancing.cpu.top.proposal.tracking.enabled", ConfigDef.Type.BOOLEAN, (Object)BalancerConfigs.BALANCER_INCREMENTAL_CPU_BALANCING_TOP_PROPOSAL_TRACKING_ENABLED_DEFAULT, ConfigDef.Importance.LOW, "A boolean denoting whether top proposal tracking is enabled for the incremental CPU balancing strategy. Top proposal tracking is a functionality which keeps track of the largest 'incremental.balancing.cpu.top.proposal.tracking.num.proposals' proposals per broker, ranked by the amount of CPU they're expected to move, that have been generated by the incremental CPU balancing strategy and logs them after each optimization. It is useful for observability purposes in order to understand what proposals the balancing algorithm is generating.").define(RESOURCE_UTILIZATION_DETECTOR_ENABLED_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, RESOURCE_UTILIZATION_DETECTOR_ENABLED_DOC).define(RESOURCE_UTILIZATION_DETECTOR_INTERVAL_MS_CONFIG, ConfigDef.Type.INT, (Object)60000, ConfigDef.Importance.LOW, RESOURCE_UTILIZATION_DETECTOR_INTERVAL_MS_DOC).define(CPU_UTILIZATION_DETECTOR_DURATION_MS_CONFIG, ConfigDef.Type.INT, (Object)600000, ConfigDef.Importance.LOW, CPU_UTILIZATION_DETECTOR_DURATION_MS_DOC).define(CPU_UTILIZATION_DETECTOR_OVERUTILIZATION_THRESHOLD_CONFIG, ConfigDef.Type.DOUBLE, (Object)80.0, ConfigDef.Importance.LOW, CPU_UTILIZATION_DETECTOR_OVERUTILIZATION_THRESHOLD_DOC).define(CPU_UTILIZATION_DETECTOR_UNDERUTILIZATION_THRESHOLD_CONFIG, ConfigDef.Type.DOUBLE, (Object)50.0, ConfigDef.Importance.LOW, CPU_UTILIZATION_DETECTOR_UNDERUTILIZATION_THRESHOLD_DOC).define(DISK_UTILIZATION_DETECTOR_DURATION_MS_CONFIG, ConfigDef.Type.INT, (Object)600000, ConfigDef.Importance.LOW, DISK_UTILIZATION_DETECTOR_DURATION_MS_DOC).define(DISK_UTILIZATION_DETECTOR_OVERUTILIZATION_THRESHOLD_CONFIG, ConfigDef.Type.DOUBLE, (Object)80.0, ConfigDef.Importance.LOW, DISK_UTILIZATION_DETECTOR_OVERUTILIZATION_THRESHOLD_DOC).define(DISK_UTILIZATION_DETECTOR_UNDERUTILIZATION_THRESHOLD_CONFIG, ConfigDef.Type.DOUBLE, (Object)35.0, ConfigDef.Importance.LOW, DISK_UTILIZATION_DETECTOR_UNDERUTILIZATION_THRESHOLD_DOC).define(DISK_UTILIZATION_DETECTOR_RESERVED_CAPACITY_CONFIG, ConfigDef.Type.DOUBLE, (Object)150000.0, ConfigDef.Importance.LOW, DISK_UTILIZATION_DETECTOR_RESERVED_CAPACITY_DOC).define(TOPIC_PARTITION_MOVEMENT_EXPIRATION_MS_CONFIG, ConfigDef.Type.LONG, (Object)3600000L, ConfigDef.Importance.MEDIUM, TOPIC_PARTITION_MOVEMENT_EXPIRATION_MS_DOC).define(TOPIC_PARTITION_MAXIMUM_MOVEMENTS_CONFIG, ConfigDef.Type.INT, (Object)5, ConfigDef.Importance.MEDIUM, TOPIC_PARTITION_MAXIMUM_MOVEMENTS_DOC).define(TOPIC_PARTITION_SUSPENSION_MS_CONFIG, ConfigDef.Type.LONG, (Object)10800000L, ConfigDef.Importance.MEDIUM, TOPIC_PARTITION_SUSPENSION_MS_DOC).define(REQUEST_CONTRIBUTION_WEIGHT_CONFIG, ConfigDef.Type.DOUBLE, (Object)0.8, (ConfigDef.Validator)ConfigDef.Range.between((Number)0.1, (Number)1.0), ConfigDef.Importance.LOW, REQUEST_CONTRIBUTION_WEIGHT_DOC).define(BYTES_CONTRIBUTION_WEIGHT_CONFIG, ConfigDef.Type.DOUBLE, (Object)0.2, (ConfigDef.Validator)ConfigDef.Range.between((Number)0.1, (Number)1.0), ConfigDef.Importance.LOW, BYTES_CONTRIBUTION_WEIGHT_DOC).withClientSslSupport().withClientSaslSupport();
    }
}

