/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.config;

import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.config.GoalsConfig;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.kafka.common.config.internals.BalancerConfigs;
import org.apache.kafka.common.errors.BalancerMisconfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class SbcGoalsConfig {
    public static final String INTERNAL_REBALANCING_GOALS_CONFIG_NAME = "goals";
    public static final String INTERNAL_TRIGGERING_GOALS_CONFIG_NAME = "anomaly.detection.goals";
    private static final Logger LOG = LoggerFactory.getLogger(SbcGoalsConfig.class);
    private final GoalsConfig rebalancingGoalsConfig;
    private final GoalsConfig triggeringGoalsConfig;
    private final boolean incrementalBalancingEnabled;
    private final GoalsConfig incrementalBalancingGoalsConfig;

    public SbcGoalsConfig(List<Goal> rebalancingGoals, List<Goal> triggeringGoals, boolean incrementalBalancingEnabled, List<Goal> incrementalBalancingGoals) {
        this(new GoalsConfig(rebalancingGoals), new GoalsConfig(triggeringGoals), incrementalBalancingEnabled, new GoalsConfig(incrementalBalancingGoals, false));
    }

    public SbcGoalsConfig(GoalsConfig rebalancingGoalsConfig, GoalsConfig triggeringGoalsConfig, boolean incrementalBalancingEnabled, GoalsConfig incrementalBalancingGoalsConfig) {
        this.rebalancingGoalsConfig = rebalancingGoalsConfig;
        this.triggeringGoalsConfig = triggeringGoalsConfig;
        this.incrementalBalancingEnabled = incrementalBalancingEnabled;
        this.incrementalBalancingGoalsConfig = incrementalBalancingGoalsConfig;
    }

    public GoalsConfig rebalancingGoals() {
        return this.rebalancingGoalsConfig;
    }

    public GoalsConfig triggeringGoals() {
        return this.triggeringGoalsConfig;
    }

    public boolean isIncrementalBalancingEnabled() {
        return this.incrementalBalancingEnabled;
    }

    public GoalsConfig incrementalBalancingGoals() {
        return this.incrementalBalancingGoalsConfig;
    }

    public GoalsConfig effectiveRebalancingGoals() {
        return this.isIncrementalBalancingEnabled() ? this.incrementalBalancingGoals() : this.rebalancingGoals();
    }

    public GoalsConfig effectiveTriggeringGoals() {
        return this.isIncrementalBalancingEnabled() ? this.incrementalBalancingGoals() : this.triggeringGoals();
    }

    public String toString() {
        return "SbcGoalsConfig{rebalancingGoals=" + this.rebalancingGoals() + ", triggeringGoals=" + this.triggeringGoals() + ", incrementalBalancingEnabled=" + this.isIncrementalBalancingEnabled() + ", incrementalBalancingGoals=" + this.incrementalBalancingGoals() + "}";
    }

    public static SbcGoalsConfigBuilder builder() {
        return new SbcGoalsConfigBuilder();
    }

    public static class SbcGoalsConfigBuilder {
        private List<String> rebalancingGoals = null;
        private List<String> triggeringGoals = null;
        private boolean incrementalBalancingEnabled = false;
        private List<String> incrementalBalancingGoals = null;

        private SbcGoalsConfigBuilder() {
        }

        public SbcGoalsConfigBuilder rebalancingGoals(List<String> rebalancingGoals) {
            this.rebalancingGoals = Objects.requireNonNull(rebalancingGoals);
            return this;
        }

        public SbcGoalsConfigBuilder triggeringGoals(List<String> triggeringGoals) {
            this.triggeringGoals = Objects.requireNonNull(triggeringGoals);
            return this;
        }

        public SbcGoalsConfigBuilder incrementalBalancingEnabled(boolean incrementalBalancingEnabled) {
            this.incrementalBalancingEnabled = incrementalBalancingEnabled;
            return this;
        }

        public SbcGoalsConfigBuilder incrementalBalancingGoals(List<String> incrementalBalancingGoals) {
            this.incrementalBalancingGoals = Objects.requireNonNull(incrementalBalancingGoals);
            return this;
        }

        public String toString() {
            return "{rebalancingGoals=" + this.rebalancingGoals + ", triggeringGoals=" + this.triggeringGoals + ", incrementalBalancingEnabled=" + this.incrementalBalancingEnabled + ", incrementalBalancingGoals=" + this.incrementalBalancingGoals + "}";
        }

        private void checkForMixedHardAndSoftGoals(List<Goal> goals) {
            if (goals.size() < 2) {
                return;
            }
            boolean startingGoalIsHard = goals.get(0).isHardGoal();
            if (!startingGoalIsHard) {
                throw new IllegalArgumentException(String.format("Multi-goal lists cannot start with a Soft goal. Provided goals: %s", goals));
            }
            boolean softGoalFound = false;
            for (int i = 1; i < goals.size(); ++i) {
                if (!goals.get(i).isHardGoal()) {
                    softGoalFound = true;
                    continue;
                }
                if (!softGoalFound) continue;
                throw new IllegalArgumentException(String.format("The provided goals config contains mixed sequence of HardGoal, SoftGoal, HardGoal. The only allowed sequence is Hard goals followed by Soft goals. Provided goals: %s", goals));
            }
        }

        public SbcGoalsConfig build(KafkaCruiseControlConfig config) throws BalancerMisconfigurationException {
            if (this.rebalancingGoals == null || this.triggeringGoals == null) {
                throw new IllegalArgumentException(String.format("The provided config contains one or more null entries: rebalancingGoals - %s, triggeringGoals - %s", this.rebalancingGoals, this.triggeringGoals));
            }
            if (!config.getList(SbcGoalsConfig.INTERNAL_REBALANCING_GOALS_CONFIG_NAME).equals(this.rebalancingGoals)) {
                throw new IllegalArgumentException(String.format("The provided config did not have the rebalancing goals configured to be the same as this builder's goals. Provided config rebalancing goals: %s, builder's rebalancing goals: %s", config.getList(SbcGoalsConfig.INTERNAL_REBALANCING_GOALS_CONFIG_NAME), this.rebalancingGoals));
            }
            if (!config.getList(SbcGoalsConfig.INTERNAL_TRIGGERING_GOALS_CONFIG_NAME).equals(this.triggeringGoals)) {
                throw new IllegalArgumentException(String.format("The provided config did not have the triggering goals configured to be the same as this builder's goals. Provided config triggering goals: %s, builder's triggering goals: %s", config.getList(SbcGoalsConfig.INTERNAL_TRIGGERING_GOALS_CONFIG_NAME), this.triggeringGoals));
            }
            BalancerConfigs.validateGoalsConfig(this.rebalancingGoals, this.triggeringGoals);
            try {
                List<Goal> rebalancingGoals = config.getConfiguredInstances(SbcGoalsConfig.INTERNAL_REBALANCING_GOALS_CONFIG_NAME, Goal.class);
                List<Goal> triggeringGoals = config.getConfiguredInstances(SbcGoalsConfig.INTERNAL_TRIGGERING_GOALS_CONFIG_NAME, Goal.class);
                boolean incrementalBalancingEnabled = config.getBoolean("incremental.balancing.enabled");
                List<Goal> incrementalBalancingGoals = config.getConfiguredInstances("incremental.balancing.goals", Goal.class);
                this.checkForMixedHardAndSoftGoals(incrementalBalancingGoals);
                return new SbcGoalsConfig(rebalancingGoals, triggeringGoals, incrementalBalancingEnabled, incrementalBalancingGoals);
            }
            catch (Exception e) {
                String errMsg = String.format("Caught an exception while building a SBC goals config with goals (rebalancing goals -> %s, triggering goals -> %s, incrementalBalancingEnabled -> %s, incrementalBalancingGoals -> %s)", this.rebalancingGoals, this.triggeringGoals, this.incrementalBalancingEnabled, this.incrementalBalancingGoals);
                LOG.error(errMsg, (Throwable)e);
                throw new BalancerMisconfigurationException(errMsg, (Throwable)e);
            }
        }
    }
}

