/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.cruisecontrol.detector.Anomaly;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.detector.BrokerFailures;
import com.linkedin.kafka.cruisecontrol.detector.GoalViolations;
import com.linkedin.kafka.cruisecontrol.detector.notifier.AnomalyType;
import com.linkedin.kafka.cruisecontrol.executor.ExecutorState;
import com.linkedin.kafka.cruisecontrol.monitor.LoadMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnomalyDetectorUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AnomalyDetectorUtils.class);
    public static final int MAX_METADATA_WAIT_MS = 60000;
    public static final Anomaly SHUTDOWN_ANOMALY = new BrokerFailures(null, null, true, true, null);

    private AnomalyDetectorUtils() {
    }

    static AnomalyType getAnomalyType(Anomaly anomaly) {
        if (anomaly instanceof GoalViolations) {
            return AnomalyType.GOAL_VIOLATION;
        }
        if (anomaly instanceof BrokerFailures) {
            return AnomalyType.BROKER_FAILURE;
        }
        throw new IllegalStateException("Unrecognized type for anomaly " + anomaly);
    }

    static boolean shouldSkipAnomalyDetection(LoadMonitor loadMonitor, KafkaCruiseControl kafkaCruiseControl) {
        ExecutorState.State executionState = kafkaCruiseControl.executionState();
        if (executionState != ExecutorState.State.NO_TASK_IN_PROGRESS) {
            LOG.info("Skipping anomaly detection because the executor is in {} state.", (Object)executionState);
            return true;
        }
        if (kafkaCruiseControl.executorIsReserved()) {
            LOG.info("Skipping anomaly detection because the executor is reserved.");
            return true;
        }
        return false;
    }
}

