/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.config.ResourceUtilizationCommonConfig;
import com.linkedin.kafka.cruisecontrol.detector.ResourceUtilizationDetector;
import com.linkedin.kafka.cruisecontrol.detector.ResourceUtilizationWindow;
import com.linkedin.kafka.cruisecontrol.detector.notifier.ResourceUtilizationAlertType;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import io.confluent.databalancer.metrics.DataBalancerMetricsRegistry;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpuUtilizationDetector
implements ResourceUtilizationDetector {
    private static final Logger LOG = LoggerFactory.getLogger(CpuUtilizationDetector.class);
    private final Time time;
    private final ResourceUtilizationWindow window;
    private final ResourceUtilizationCommonConfig config;
    private volatile int cpuOptimizationMetric;

    public CpuUtilizationDetector(KafkaCruiseControlConfig kccConfig, Time time, DataBalancerMetricsRegistry metricsRegistry) {
        this(time, kccConfig.getInt("cpu.utilization.detector.duration.ms"), kccConfig.getDouble("cpu.utilization.detector.underutilization.threshold"), kccConfig.getDouble("cpu.utilization.detector.overutilization.threshold"));
        metricsRegistry.newGauge(CpuUtilizationDetector.class, "cpu-optimization-score", this::getCpuOptimizationMetric);
    }

    CpuUtilizationDetector(Time time, int durationMs, double underutilizationThreshold, double overutilizationThreshold) {
        this.time = time;
        this.config = new ResourceUtilizationCommonConfig(durationMs, overutilizationThreshold, underutilizationThreshold);
        this.window = new ResourceUtilizationWindow();
        this.cpuOptimizationMetric = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detectResourceUtilization(ClusterModel clusterModel) {
        try {
            long now = this.time.milliseconds();
            int durationMs = this.config.getDurationMs();
            double overutilizationThreshold = this.config.getOverutilizationThreshold();
            double underutilizationThreshold = this.config.getUnderutilizationThreshold();
            LOG.info("Running CPU utilization detector.");
            double rawUtilizationValue = clusterModel.load().expectedUtilizationFor(Resource.CPU);
            double capacity = clusterModel.capacity().totalCapacityFor(Resource.CPU);
            double utilizationValue = rawUtilizationValue / capacity;
            if (!Double.isNaN(utilizationValue)) {
                this.window.addValue(now, utilizationValue);
                double avgUtilizationValue = this.window.avg();
                long windowLength = this.window.length(now);
                this.cpuOptimizationMetric = windowLength >= (long)durationMs && avgUtilizationValue > overutilizationThreshold ? ResourceUtilizationAlertType.OVERUTILIZATION.getMetricValue() : (windowLength >= (long)durationMs && avgUtilizationValue < underutilizationThreshold ? ResourceUtilizationAlertType.UNDERUTILIZATION.getMetricValue() : ResourceUtilizationAlertType.NONE.getMetricValue());
            } else {
                LOG.debug("Ignoring unexpected CPU utilization value {}, raw utilization is {}", (Object)utilizationValue, (Object)rawUtilizationValue);
            }
            this.window.deleteExpiredValues(now, durationMs);
        }
        catch (Exception e) {
            LOG.error("CPU Utilization Detector encountered an unexpected exception, resetting state", (Throwable)e);
            this.resetDetectorState();
        }
        finally {
            LOG.info("CPU utilization detection finished.");
        }
    }

    @Override
    public void resetDetectorState() {
        this.cpuOptimizationMetric = ResourceUtilizationAlertType.NONE.getMetricValue();
        this.window.clear();
    }

    public int getCpuOptimizationMetric() {
        return this.cpuOptimizationMetric;
    }

    double getTotalUtilizationValue() {
        return this.window.sum();
    }

    boolean isUtilizationValuesEmpty() {
        return this.window.isEmpty();
    }

    double getAvgUtilizationValue() {
        return this.window.avg();
    }

    long getWindowLength() {
        return this.window.length(this.time.milliseconds());
    }
}

