/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.config.DiskUtilizationDetectorConfig;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.detector.ResourceUtilizationDetector;
import com.linkedin.kafka.cruisecontrol.detector.ResourceUtilizationWindow;
import com.linkedin.kafka.cruisecontrol.detector.notifier.ResourceUtilizationAlertType;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import io.confluent.databalancer.metrics.DataBalancerMetricsRegistry;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskUtilizationDetector
implements ResourceUtilizationDetector {
    private static final Logger LOG = LoggerFactory.getLogger(DiskUtilizationDetector.class);
    private static final double CAPACITY_EPSILON = 2000.0;
    private final Time time;
    private final ResourceUtilizationWindow window;
    private final DiskUtilizationDetectorConfig config;
    private volatile int diskOptimizationMetric;

    public DiskUtilizationDetector(KafkaCruiseControlConfig kccConfig, Time time, DataBalancerMetricsRegistry metricsRegistry) {
        this(time, kccConfig.getInt("disk.utilization.detector.duration.ms"), kccConfig.getDouble("disk.utilization.detector.underutilization.threshold"), kccConfig.getDouble("disk.utilization.detector.overutilization.threshold"), kccConfig.getDouble("disk.utilization.detector.reserved.capacity"));
        metricsRegistry.newGauge(DiskUtilizationDetector.class, "disk-optimization-score", this::getDiskOptimizationMetric);
    }

    DiskUtilizationDetector(Time time, int durationMs, double underutilizationThreshold, double overutilizationThreshold, double reservedCapacity) {
        this.time = time;
        this.window = new ResourceUtilizationWindow();
        this.config = new DiskUtilizationDetectorConfig(durationMs, overutilizationThreshold, underutilizationThreshold, reservedCapacity);
        this.diskOptimizationMetric = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detectResourceUtilization(ClusterModel clusterModel) {
        try {
            long now = this.time.milliseconds();
            int durationMs = this.config.getDurationMs();
            double overutilizationThreshold = this.config.getOverutilizationThreshold();
            double underutilizationThreshold = this.config.getUnderutilizationThreshold();
            double reservedCapacity = this.config.getReservedCapacity();
            LOG.info("Running disk utilization detector.");
            double rawUtilizationValue = clusterModel.load().expectedUtilizationFor(Resource.DISK);
            double capacity = clusterModel.capacity().totalCapacityFor(Resource.DISK);
            double utilizationValue = rawUtilizationValue * 100.0 / capacity;
            if (!Double.isNaN(utilizationValue)) {
                this.window.addValue(now, utilizationValue);
                double avgUtilizationValue = this.window.avg();
                long windowLength = this.window.length(now);
                this.diskOptimizationMetric = windowLength >= (long)durationMs && avgUtilizationValue > overutilizationThreshold ? ResourceUtilizationAlertType.OVERUTILIZATION.getMetricValue() : (windowLength >= (long)durationMs && avgUtilizationValue < underutilizationThreshold && capacity - reservedCapacity > 2000.0 ? ResourceUtilizationAlertType.UNDERUTILIZATION.getMetricValue() : ResourceUtilizationAlertType.NONE.getMetricValue());
            } else {
                LOG.debug("Ignoring unexpected disk utilization value {}, raw utilization is {}", (Object)utilizationValue, (Object)rawUtilizationValue);
            }
            this.window.deleteExpiredValues(now, durationMs);
        }
        catch (Exception e) {
            LOG.error("Disk Utilization Detector encountered an unexpected exception, resetting state", (Throwable)e);
            this.resetDetectorState();
        }
        finally {
            LOG.info("Disk utilization detection finished.");
        }
    }

    @Override
    public void resetDetectorState() {
        this.diskOptimizationMetric = ResourceUtilizationAlertType.NONE.getMetricValue();
        this.window.clear();
    }

    public int getDiskOptimizationMetric() {
        return this.diskOptimizationMetric;
    }

    double getTotalUtilizationValue() {
        return this.window.sum();
    }

    boolean isUtilizationValuesEmpty() {
        return this.window.isEmpty();
    }

    double getAvgUtilizationValue() {
        return this.window.avg();
    }

    long getWindowLength() {
        return this.window.length(this.time.milliseconds());
    }
}

