/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.RebalanceResult;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationResult;
import com.linkedin.kafka.cruisecontrol.async.progress.OperationProgress;
import com.linkedin.kafka.cruisecontrol.config.GoalsConfig;
import com.linkedin.kafka.cruisecontrol.detector.KafkaAnomaly;
import com.linkedin.kafka.cruisecontrol.detector.notifier.AnomalyType;
import com.linkedin.kafka.cruisecontrol.exception.KafkaCruiseControlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoalViolations
extends KafkaAnomaly {
    private static final String ID_PREFIX = AnomalyType.GOAL_VIOLATION.toString();
    private static final Logger LOG = LoggerFactory.getLogger(GoalViolations.class);
    private final KafkaCruiseControl kafkaCruiseControl;
    private final Map<Boolean, List<GoalResult>> violatedGoalsByFixability;
    private final boolean allowCapacityEstimation;
    private final boolean excludeRecentlyRemovedBrokers;
    private final String anomalyId;
    private final GoalsConfig goalConfig;

    public GoalViolations(KafkaCruiseControl kafkaCruiseControl, boolean allowCapacityEstimation, boolean excludeRecentlyRemovedBrokers, GoalsConfig goalConfig) {
        this.kafkaCruiseControl = kafkaCruiseControl;
        this.allowCapacityEstimation = allowCapacityEstimation;
        this.violatedGoalsByFixability = new HashMap<Boolean, List<GoalResult>>();
        this.excludeRecentlyRemovedBrokers = excludeRecentlyRemovedBrokers;
        this.anomalyId = String.format("%s-%s", ID_PREFIX, UUID.randomUUID().toString().substring(ID_PREFIX.length() + 1));
        this.optimizationResult = null;
        this.goalConfig = goalConfig;
    }

    @Override
    public GoalsConfig goalsConfig() {
        return this.goalConfig;
    }

    void addViolation(String goalName, boolean fixable, Exception e) {
        this.violatedGoalsByFixability.computeIfAbsent(fixable, k -> new ArrayList()).add(new GoalResult(goalName, e));
    }

    void addViolation(String goalName, boolean fixable) {
        this.addViolation(goalName, fixable, null);
    }

    public Map<Boolean, List<GoalResult>> violatedGoalsByFixability() {
        return this.violatedGoalsByFixability;
    }

    @Override
    public String anomalyId() {
        return this.anomalyId;
    }

    @Override
    public boolean fix() throws KafkaCruiseControlException {
        if (this.violatedGoalsByFixability.get(false) == null) {
            try {
                List<String> triggeringGoals = this.violatedGoalsByFixability.get(true).stream().map(r -> r.name).collect(Collectors.toList());
                RebalanceResult rebalanceResult = this.kafkaCruiseControl.rebalanceForEvenClusterLoad(this.goalConfig, false, null, new OperationProgress(), this.allowCapacityEstimation, this.anomalyId, this.excludeRecentlyRemovedBrokers, false, triggeringGoals, false);
                if (!rebalanceResult.wasExecuted()) {
                    LOG.warn("Goal violation {} could not be safely fixed: no triggering goals {} could be successfully fixed", (Object)this.anomalyId, triggeringGoals);
                    return false;
                }
                this.optimizationResult = new OptimizationResult(rebalanceResult.optimizerResult());
                this.optimizationResult.discardIrrelevantAndCacheText();
                return true;
            }
            catch (IllegalStateException e) {
                LOG.warn("Got exception when trying to fix the cluster for violated goals {}: {}", this.violatedGoalsByFixability.get(true), (Object)e.getMessage());
            }
        } else {
            LOG.info("Skip fixing goal violations due to unfixable goal violations {} detected.", this.violatedGoalsByFixability.get(false));
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{Unfixable goal violations: {");
        StringJoiner joiner = new StringJoiner(",");
        this.violatedGoalsByFixability.getOrDefault(false, Collections.emptyList()).stream().map(GoalResult::toString).forEach(joiner::add);
        sb.append(joiner.toString());
        sb.append("}, Fixable goal violations: {");
        joiner = new StringJoiner(",");
        this.violatedGoalsByFixability.getOrDefault(true, Collections.emptyList()).stream().map(GoalResult::toString).forEach(joiner::add);
        sb.append(joiner.toString());
        sb.append(String.format("}, Exclude brokers recently (removed: %s)}", this.excludeRecentlyRemovedBrokers));
        return sb.toString();
    }

    public static class GoalResult {
        public final String name;
        public final Exception exception;

        public GoalResult(String name, Exception exception) {
            this.name = name;
            this.exception = exception;
        }

        public String toString() {
            return "GoalResult{goalName='" + this.name + "'" + (this.exception == null ? "" : ", exception=" + this.exception) + "}";
        }
    }
}

