/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.kafka.cruisecontrol.async.progress.OperationProgress;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.detector.CpuUtilizationDetector;
import com.linkedin.kafka.cruisecontrol.detector.DiskUtilizationDetector;
import com.linkedin.kafka.cruisecontrol.detector.ResourceUtilizationDetector;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.monitor.LoadMonitor;
import com.linkedin.kafka.cruisecontrol.monitor.ModelCompletenessRequirements;
import com.linkedin.kafka.cruisecontrol.monitor.ModelGeneration;
import io.confluent.databalancer.metrics.DataBalancerMetricsRegistry;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtilizationHandler
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceUtilizationHandler.class);
    private final LoadMonitor loadMonitor;
    private final Time time;
    private ClusterModel clusterModel;
    private ModelGeneration lastCheckModelGeneration;
    private final List<ResourceUtilizationDetector> detectors;
    private final ModelCompletenessRequirements modelCompletenessRequirements;

    public ResourceUtilizationHandler(KafkaCruiseControlConfig kccConfig, LoadMonitor loadMonitor, Time time, DataBalancerMetricsRegistry metricsRegistry) {
        this.loadMonitor = loadMonitor;
        this.time = time;
        this.lastCheckModelGeneration = null;
        double minMonitoredPartitionPercentage = kccConfig.getDouble("min.valid.partition.ratio");
        this.modelCompletenessRequirements = new ModelCompletenessRequirements(1, minMonitoredPartitionPercentage, true);
        this.detectors = Arrays.asList(new CpuUtilizationDetector(kccConfig, time, metricsRegistry), new DiskUtilizationDetector(kccConfig, time, metricsRegistry));
    }

    @Override
    public void run() {
        try {
            long now = this.time.milliseconds();
            LOG.info("Running resource utilization detector.");
            if (!this.loadMonitor.clusterModelGeneration().equals(this.lastCheckModelGeneration)) {
                this.clusterModel = this.loadMonitor.createClusterModel(now, this.modelCompletenessRequirements, new OperationProgress());
                this.lastCheckModelGeneration = this.clusterModel.generation();
            }
            this.detectors.forEach(detector -> detector.detectResourceUtilization(this.clusterModel));
        }
        catch (Exception e) {
            LOG.error("Resetting all resource detectors because of an unexpected exception", (Throwable)e);
            this.detectors.forEach(detector -> detector.resetDetectorState());
        }
        finally {
            LOG.info("Resource utilization detection finished.");
        }
    }
}

