/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import java.util.Deque;
import java.util.LinkedList;
import org.apache.commons.math3.util.Pair;

public class ResourceUtilizationWindow {
    private final Deque<Pair<Long, Double>> values = new LinkedList<Pair<Long, Double>>();
    private double totalValue = 0.0;

    public void addValue(long timestamp, double value) {
        this.values.addLast((Pair<Long, Double>)new Pair((Object)timestamp, (Object)value));
        this.totalValue += value;
    }

    public void deleteExpiredValues(long now, int durationMs) {
        while (this.length(now) > (long)durationMs) {
            double deleteValue = (Double)this.values.removeFirst().getValue();
            this.totalValue -= deleteValue;
        }
    }

    public void clear() {
        this.values.clear();
        this.totalValue = 0.0;
    }

    public double avg() {
        if (this.values.isEmpty()) {
            return 0.0;
        }
        return this.totalValue / (double)this.values.size();
    }

    public long length(long now) {
        if (this.values.isEmpty()) {
            return 0L;
        }
        return now - (Long)this.values.peekFirst().getKey();
    }

    public double sum() {
        return this.totalValue;
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }
}

