/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.executor;

import com.linkedin.kafka.cruisecontrol.model.ReplicaPlacementInfo;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;

public class ExecutionProposal {
    private static final String TOPIC_PARTITION = "topicPartition";
    private static final String OLD_LEADER = "oldLeader";
    private static final String OLD_REPLICAS = "oldReplicas";
    private static final String NEW_REPLICAS = "newReplicas";
    private final TopicPartition tp;
    private final long partitionSize;
    private final ReplicaPlacementInfo oldLeader;
    private final List<ReplicaPlacementInfo> oldReplicas;
    private final List<ReplicaPlacementInfo> newReplicas;
    private final List<ReplicaPlacementInfo> oldObservers;
    private final List<ReplicaPlacementInfo> newObservers;
    private final Set<ReplicaPlacementInfo> replicasToAdd;
    private final Set<ReplicaPlacementInfo> replicasToRemove;
    private final Map<Integer, ReplicaPlacementInfo> replicasToMoveBetweenDisksByBroker;

    public ExecutionProposal(TopicPartition tp, long partitionSize, ReplicaPlacementInfo oldLeader, List<ReplicaPlacementInfo> oldReplicas, List<ReplicaPlacementInfo> newReplicas, List<ReplicaPlacementInfo> oldObservers, List<ReplicaPlacementInfo> newObservers) {
        this.tp = tp;
        this.partitionSize = partitionSize;
        this.oldLeader = oldLeader;
        this.oldReplicas = oldReplicas == null ? Collections.emptyList() : oldReplicas;
        this.newReplicas = newReplicas;
        this.oldObservers = oldObservers;
        this.newObservers = newObservers;
        this.validate();
        Set newBrokerList = this.newReplicas.stream().mapToInt(ReplicaPlacementInfo::brokerId).boxed().collect(Collectors.toSet());
        Set oldBrokerList = this.oldReplicas.stream().mapToInt(ReplicaPlacementInfo::brokerId).boxed().collect(Collectors.toSet());
        this.replicasToAdd = this.newReplicas.stream().filter(r -> !oldBrokerList.contains(r.brokerId())).collect(Collectors.toSet());
        this.replicasToRemove = this.oldReplicas.stream().filter(r -> !newBrokerList.contains(r.brokerId())).collect(Collectors.toSet());
        this.replicasToMoveBetweenDisksByBroker = new HashMap<Integer, ReplicaPlacementInfo>();
        newReplicas.stream().filter(r -> !this.replicasToAdd.contains(r) && !this.oldReplicas.contains(r)).forEach(r -> this.replicasToMoveBetweenDisksByBroker.put(r.brokerId(), (ReplicaPlacementInfo)r));
        if (!this.replicasToAdd.isEmpty() && !this.replicasToMoveBetweenDisksByBroker.isEmpty()) {
            throw new IllegalArgumentException("Change from " + this.oldReplicas + " to " + this.newReplicas + " will generate both intra-broker and inter-broker replica movements.");
        }
    }

    private boolean brokerOrderMatched(Node[] currentOrderedReplicas, List<ReplicaPlacementInfo> replicas) {
        if (replicas.size() != currentOrderedReplicas.length) {
            return false;
        }
        for (int i = 0; i < replicas.size(); ++i) {
            if (currentOrderedReplicas[i].id() == replicas.get(i).brokerId().intValue()) continue;
            return false;
        }
        return true;
    }

    public boolean isInterBrokerMovementCompleted(Node[] currentOrderedReplicas, Node[] currentOrderedObservers) {
        return this.brokerOrderMatched(currentOrderedReplicas, this.newReplicas) && this.brokerOrderMatched(currentOrderedObservers, this.newObservers);
    }

    public boolean isInterBrokerMovementAborted(Node[] currentOrderedReplicas, Node[] currentOrderedObservers) {
        return this.isInterBrokerMovementCompleted(currentOrderedReplicas, currentOrderedObservers) || this.brokerOrderMatched(currentOrderedReplicas, this.oldReplicas) && this.brokerOrderMatched(currentOrderedObservers, this.oldObservers);
    }

    public String topic() {
        return this.tp.topic();
    }

    public int partitionId() {
        return this.tp.partition();
    }

    public TopicPartition topicPartition() {
        return this.tp;
    }

    public ReplicaPlacementInfo oldLeader() {
        return this.oldLeader;
    }

    public ReplicaPlacementInfo newLeader() {
        return this.newReplicas.get(0);
    }

    public List<ReplicaPlacementInfo> oldReplicas() {
        return this.oldReplicas;
    }

    public List<ReplicaPlacementInfo> newReplicas() {
        return this.newReplicas;
    }

    public List<ReplicaPlacementInfo> oldObservers() {
        return this.oldObservers;
    }

    public List<ReplicaPlacementInfo> newObservers() {
        return this.newObservers;
    }

    public Set<ReplicaPlacementInfo> replicasToAdd() {
        return this.replicasToAdd;
    }

    public Set<ReplicaPlacementInfo> replicasToRemove() {
        return this.replicasToRemove;
    }

    public Map<Integer, ReplicaPlacementInfo> replicasToMoveBetweenDisksByBroker() {
        return this.replicasToMoveBetweenDisksByBroker;
    }

    public boolean hasReplicaAction() {
        return !new HashSet<ReplicaPlacementInfo>(this.oldReplicas).equals(new HashSet<ReplicaPlacementInfo>(this.newReplicas));
    }

    public boolean hasLeaderAction() {
        return this.oldLeader != this.newReplicas.get(0);
    }

    public long interBrokerDataToMoveInMB() {
        return (long)this.replicasToAdd.size() * this.partitionSize;
    }

    public long singleDestinationBrokerDataToReceiveInMB() {
        return this.partitionSize;
    }

    public long intraBrokerDataToMoveInMB() {
        return this.partitionSize;
    }

    public long dataToMoveInMB() {
        return (long)(this.replicasToAdd.size() + this.replicasToMoveBetweenDisksByBroker.size()) * this.partitionSize;
    }

    public int replicaMovementParallelism() {
        return this.replicasToAdd.size();
    }

    private void validate() {
        if (this.oldLeader.brokerId() >= 0 && !this.oldReplicas.contains(this.oldLeader)) {
            throw new IllegalArgumentException(String.format("The old leader %s does not exist in the old replica list %s", this.oldLeader, this.oldReplicas));
        }
        if (this.newReplicas == null || this.newReplicas.isEmpty()) {
            throw new IllegalArgumentException("The new replica list " + this.newReplicas + " cannot be empty.");
        }
        HashSet<ReplicaPlacementInfo> replicaSet = new HashSet<ReplicaPlacementInfo>(this.newReplicas);
        if (replicaSet.size() != this.newReplicas.size()) {
            throw new IllegalArgumentException("The new replicas list " + this.newReplicas + " has duplicate replica.");
        }
        int numSyncReplicas = this.newReplicas.size() - this.newObservers.size();
        List<ReplicaPlacementInfo> replicaSuffix = this.newReplicas.subList(numSyncReplicas, this.newReplicas.size());
        if (!replicaSuffix.equals(this.newObservers)) {
            throw new IllegalArgumentException(String.format("The new observers list %s is not a suffix of the new replicas list %s", this.newObservers, this.newReplicas));
        }
    }

    public Map<String, Object> getJsonStructure() {
        HashMap<String, Object> proposalMap = new HashMap<String, Object>(4);
        proposalMap.put(TOPIC_PARTITION, this.tp);
        proposalMap.put(OLD_LEADER, this.oldLeader.brokerId());
        proposalMap.put(OLD_REPLICAS, this.oldReplicas.stream().mapToInt(ReplicaPlacementInfo::brokerId).boxed().collect(Collectors.toList()));
        proposalMap.put(NEW_REPLICAS, this.newReplicas.stream().mapToInt(ReplicaPlacementInfo::brokerId).boxed().collect(Collectors.toList()));
        return proposalMap;
    }

    public String toString() {
        Integer oldLeaderId = this.oldLeader.brokerId();
        Integer newLeaderId = this.newLeader().brokerId();
        List oldObserverIds = this.oldObservers.stream().mapToInt(ReplicaPlacementInfo::brokerId).boxed().collect(Collectors.toList());
        List newObserverIds = this.newObservers.stream().mapToInt(ReplicaPlacementInfo::brokerId).boxed().collect(Collectors.toList());
        boolean noObservers = oldObserverIds.isEmpty() && newObserverIds.isEmpty();
        String observerProposal = noObservers ? "" : String.format(", observers: %s -> %s", oldObserverIds, newObserverIds);
        return String.format("{%s, Leader: %d -> %d, replicas: %s -> %s%s}", this.tp, oldLeaderId, newLeaderId, this.oldReplicas.stream().mapToInt(ReplicaPlacementInfo::brokerId).boxed().collect(Collectors.toList()), this.newReplicas.stream().mapToInt(ReplicaPlacementInfo::brokerId).boxed().collect(Collectors.toList()), observerProposal);
    }

    public boolean equals(Object other) {
        if (!(other instanceof ExecutionProposal)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        ExecutionProposal otherProposal = (ExecutionProposal)other;
        return this.tp.equals((Object)otherProposal.tp) && this.oldLeader == otherProposal.oldLeader && this.oldReplicas.equals(otherProposal.oldReplicas) && this.newReplicas.equals(otherProposal.newReplicas) && this.oldObservers.equals(otherProposal.oldObservers) && this.newObservers.equals(otherProposal.newObservers);
    }

    public int hashCode() {
        int result = this.tp.hashCode();
        result = 31 * result + this.oldLeader.hashCode();
        for (ReplicaPlacementInfo replica : this.oldReplicas) {
            result = 31 * result + replica.hashCode();
        }
        for (ReplicaPlacementInfo replica : this.newReplicas) {
            result = 31 * result + replica.hashCode();
        }
        for (ReplicaPlacementInfo replica : this.oldObservers) {
            result = 31 * result + replica.hashCode();
        }
        for (ReplicaPlacementInfo replica : this.newObservers) {
            result = 31 * result + replica.hashCode();
        }
        return result;
    }
}

