/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.executor;

import com.linkedin.kafka.cruisecontrol.executor.Executor;
import java.time.Duration;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorReservationHandle
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutorReservationHandle.class);
    private final Executor executor;
    private final Time time;

    public ExecutorReservationHandle(Executor executor, Time time) {
        this.executor = executor;
        this.time = time;
        boolean locked = executor.reservation().attemptReservation();
        if (!locked) {
            throw new IllegalStateException("Cannot reserve the Executor because it is already reserved by another thread!");
        }
    }

    @Override
    public void close() {
        this.executor.reservation().cancelReservation();
    }

    public void stopExecution(String reason) {
        this.executor.triggerStopExecution(reason);
    }

    private boolean abortExecution(Duration timeout, boolean shouldInvalidateMetrics, String reason) throws TimeoutException {
        boolean hasExecution = this.executor.hasOngoingExecution();
        this.executor.triggerStopExecution(shouldInvalidateMetrics, reason);
        long startMs = this.time.milliseconds();
        long timeoutMs = startMs + timeout.toMillis();
        if (hasExecution) {
            LOG.info("Aborted executions, waiting for them to stop for {}", (Object)timeout);
        }
        while (this.executor.hasOngoingExecution()) {
            if (timeoutMs <= this.time.milliseconds()) {
                throw new TimeoutException(String.format("Timed out awaiting for execution to finish after %s", timeout));
            }
            this.time.sleep(100L);
        }
        return hasExecution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutorReservationHandle reserveAndAbortOngoingExecutions(Executor executor, Time time, Duration executionAbortTimeout, Duration executionRefreshTime, boolean shouldInvalidateMetrics, String reason) throws TimeoutException {
        ExecutorReservationHandle reservation = null;
        boolean reservedSuccessfully = false;
        try {
            reservation = new ExecutorReservationHandle(executor, time);
            boolean aborted = reservation.abortExecution(executionAbortTimeout, shouldInvalidateMetrics, reason);
            if (aborted) {
                LOG.info("Aborted an execution, sleeping for {} before returning the reservation", (Object)executionRefreshTime);
                time.sleep(executionRefreshTime.toMillis());
            }
            reservedSuccessfully = true;
            ExecutorReservationHandle executorReservationHandle = reservation;
            return executorReservationHandle;
        }
        finally {
            if (!reservedSuccessfully && reservation != null) {
                reservation.close();
            }
        }
    }
}

