/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.executor.strategy;

import com.linkedin.kafka.cruisecontrol.executor.ExecutionProposal;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionTask;
import com.linkedin.kafka.cruisecontrol.executor.strategy.ReplicaMovementStrategy;
import com.linkedin.kafka.cruisecontrol.model.ReplicaPlacementInfo;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.kafka.common.Cluster;

public abstract class AbstractReplicaMovementStrategy
implements ReplicaMovementStrategy {
    @Override
    public ReplicaMovementStrategy chain(final ReplicaMovementStrategy strategy) {
        final AbstractReplicaMovementStrategy current = this;
        return new AbstractReplicaMovementStrategy(){

            @Override
            public Comparator<ExecutionTask> taskComparator(Cluster cluster) {
                Comparator<ExecutionTask> comparator1 = current.taskComparator(cluster);
                Comparator<ExecutionTask> comparator2 = strategy.taskComparator(cluster);
                return (task1, task2) -> {
                    int compareResult1 = comparator1.compare((ExecutionTask)task1, (ExecutionTask)task2);
                    return compareResult1 == 0 ? comparator2.compare((ExecutionTask)task1, (ExecutionTask)task2) : compareResult1;
                };
            }

            @Override
            public String name() {
                return current.name() + "," + strategy.name();
            }
        };
    }

    @Override
    public Map<Integer, SortedSet<ExecutionTask>> applyStrategy(Set<ExecutionTask> replicaMovementTasks, Cluster cluster) {
        HashMap<Integer, SortedSet<ExecutionTask>> tasksByBrokerId = new HashMap<Integer, SortedSet<ExecutionTask>>();
        for (ExecutionTask task : replicaMovementTasks) {
            ExecutionProposal proposal = task.proposal();
            SortedSet sourceBrokerTaskSet = tasksByBrokerId.computeIfAbsent(proposal.oldLeader().brokerId(), k -> new TreeSet<ExecutionTask>(this.taskComparator(cluster)));
            if (!sourceBrokerTaskSet.add(task)) {
                throw new IllegalStateException("Replica movement strategy " + this.getClass().getSimpleName() + " is unable to determine order of all tasks.");
            }
            for (ReplicaPlacementInfo destinationBroker : proposal.replicasToAdd()) {
                SortedSet destinationBrokerTaskSet = tasksByBrokerId.computeIfAbsent(destinationBroker.brokerId(), k -> new TreeSet<ExecutionTask>(this.taskComparator(cluster)));
                if (destinationBrokerTaskSet.add(task)) continue;
                throw new IllegalStateException("Replica movement strategy " + this.getClass().getSimpleName() + " is unable to determine order of all tasks.");
            }
        }
        return tasksByBrokerId;
    }
}

