/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.executor.strategy;

import com.linkedin.kafka.cruisecontrol.executor.ExecutionTask;
import com.linkedin.kafka.cruisecontrol.executor.strategy.BaseReplicaMovementStrategy;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.apache.kafka.common.Cluster;

public interface ReplicaMovementStrategy {
    public Map<Integer, SortedSet<ExecutionTask>> applyStrategy(Set<ExecutionTask> var1, Cluster var2);

    public ReplicaMovementStrategy chain(ReplicaMovementStrategy var1);

    public Comparator<ExecutionTask> taskComparator(Cluster var1);

    public String name();

    public static ReplicaMovementStrategy generateChainedReplicaMovementStrategies(List<String> replicaMovementStrategiesList) {
        ReplicaMovementStrategy replicaMovementStrategy = new BaseReplicaMovementStrategy();
        if (replicaMovementStrategiesList != null) {
            ListIterator<String> listIter = replicaMovementStrategiesList.listIterator(replicaMovementStrategiesList.size());
            while (listIter.hasPrevious()) {
                String replicaMovementStrategyName = listIter.previous();
                try {
                    ReplicaMovementStrategy newStrategy = (ReplicaMovementStrategy)Class.forName(replicaMovementStrategyName).newInstance();
                    replicaMovementStrategy = newStrategy.chain(replicaMovementStrategy);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error occurred while setting up the replica movement strategy: " + replicaMovementStrategyName + ".", e);
                }
            }
        }
        return replicaMovementStrategy;
    }
}

