/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.metricsreporter.metric;

import com.linkedin.kafka.cruisecontrol.metricsreporter.exception.UnknownVersionException;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.CruiseControlMetric;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.RawMetricType;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.kafka.common.TopicPartition;

public class PartitionMetric
extends CruiseControlMetric {
    private static final byte METRIC_VERSION = 0;
    private final String topic;
    private final int partition;

    public PartitionMetric(RawMetricType rawMetricType, long time, int brokerId, String topic, int partition, double value) {
        super(rawMetricType, time, brokerId, value);
        if (rawMetricType.metricScope() != RawMetricType.MetricScope.PARTITION) {
            throw new IllegalArgumentException(String.format("Cannot construct a PartitionMetric for %s whose scope is %s", new Object[]{rawMetricType, rawMetricType.metricScope()}));
        }
        this.topic = topic;
        this.partition = partition;
    }

    @Override
    public CruiseControlMetric.MetricClassId metricClassId() {
        return CruiseControlMetric.MetricClassId.PARTITION_METRIC;
    }

    public String topic() {
        return this.topic;
    }

    public int partition() {
        return this.partition;
    }

    @Override
    public ByteBuffer toBuffer(int headerPos) {
        byte[] topic = this.topic().getBytes(StandardCharsets.UTF_8);
        ByteBuffer buffer = ByteBuffer.allocate(headerPos + 1 + 1 + 8 + 4 + 4 + topic.length + 4 + 8);
        buffer.position(headerPos);
        buffer.put((byte)0);
        buffer.put(this.rawMetricType().id());
        buffer.putLong(this.time());
        buffer.putInt(this.brokerId());
        buffer.putInt(topic.length);
        buffer.put(topic);
        buffer.putInt(this.partition);
        buffer.putDouble(this.value());
        return buffer;
    }

    static PartitionMetric fromBuffer(ByteBuffer buffer) throws UnknownVersionException {
        byte version = buffer.get();
        if (version > 0) {
            throw new UnknownVersionException("Cannot deserialize the topic metrics for version " + version + ". Current version is " + 0);
        }
        RawMetricType rawMetricType = RawMetricType.forId(buffer.get());
        long time = buffer.getLong();
        int brokerId = buffer.getInt();
        int topicLength = buffer.getInt();
        String topic = new String(buffer.array(), buffer.arrayOffset() + buffer.position(), topicLength, StandardCharsets.UTF_8);
        buffer.position(buffer.position() + topicLength);
        int partition = buffer.getInt();
        double value = buffer.getDouble();
        return new PartitionMetric(rawMetricType, time, brokerId, topic, partition, value);
    }

    @Override
    public String toString() {
        return String.format("[%s,%s,time=%d,brokerId=%d,partition=%s,value=%.3f]", new Object[]{CruiseControlMetric.MetricClassId.PARTITION_METRIC, this.rawMetricType(), this.time(), this.brokerId(), new TopicPartition(this.topic(), this.partition()), this.value()});
    }
}

