/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.metricsreporter.metric;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public enum RawMetricType {
    ALL_TOPIC_BYTES_IN(MetricScope.BROKER, 0),
    ALL_TOPIC_BYTES_OUT(MetricScope.BROKER, 1),
    TOPIC_BYTES_IN(MetricScope.TOPIC, 2),
    TOPIC_BYTES_OUT(MetricScope.TOPIC, 3),
    PARTITION_SIZE(MetricScope.PARTITION, 4),
    BROKER_CPU_UTIL(MetricScope.BROKER, 5),
    ALL_TOPIC_REPLICATION_BYTES_IN(MetricScope.BROKER, 6),
    ALL_TOPIC_REPLICATION_BYTES_OUT(MetricScope.BROKER, 7),
    ALL_TOPIC_PRODUCE_REQUEST_RATE(MetricScope.BROKER, 8),
    ALL_TOPIC_FETCH_REQUEST_RATE(MetricScope.BROKER, 9),
    ALL_TOPIC_MESSAGES_IN_PER_SEC(MetricScope.BROKER, 10),
    TOPIC_REPLICATION_BYTES_IN(MetricScope.TOPIC, 11),
    TOPIC_REPLICATION_BYTES_OUT(MetricScope.TOPIC, 12),
    TOPIC_PRODUCE_REQUEST_RATE(MetricScope.TOPIC, 13),
    TOPIC_FETCH_REQUEST_RATE(MetricScope.TOPIC, 14),
    TOPIC_MESSAGES_IN_PER_SEC(MetricScope.TOPIC, 15),
    BROKER_PRODUCE_REQUEST_RATE(MetricScope.BROKER, 16),
    BROKER_CONSUMER_FETCH_REQUEST_RATE(MetricScope.BROKER, 17),
    BROKER_FOLLOWER_FETCH_REQUEST_RATE(MetricScope.BROKER, 18),
    BROKER_REQUEST_QUEUE_SIZE(MetricScope.BROKER, 20),
    BROKER_RESPONSE_QUEUE_SIZE(MetricScope.BROKER, 21),
    BROKER_PRODUCE_REQUEST_QUEUE_TIME_MS_MAX(MetricScope.BROKER, 22),
    BROKER_PRODUCE_REQUEST_QUEUE_TIME_MS_MEAN(MetricScope.BROKER, 23),
    BROKER_CONSUMER_FETCH_REQUEST_QUEUE_TIME_MS_MAX(MetricScope.BROKER, 24),
    BROKER_CONSUMER_FETCH_REQUEST_QUEUE_TIME_MS_MEAN(MetricScope.BROKER, 25),
    BROKER_FOLLOWER_FETCH_REQUEST_QUEUE_TIME_MS_MAX(MetricScope.BROKER, 26),
    BROKER_FOLLOWER_FETCH_REQUEST_QUEUE_TIME_MS_MEAN(MetricScope.BROKER, 27),
    BROKER_PRODUCE_TOTAL_TIME_MS_MAX(MetricScope.BROKER, 28),
    BROKER_PRODUCE_TOTAL_TIME_MS_MEAN(MetricScope.BROKER, 29),
    BROKER_CONSUMER_FETCH_TOTAL_TIME_MS_MAX(MetricScope.BROKER, 30),
    BROKER_CONSUMER_FETCH_TOTAL_TIME_MS_MEAN(MetricScope.BROKER, 31),
    BROKER_FOLLOWER_FETCH_TOTAL_TIME_MS_MAX(MetricScope.BROKER, 32),
    BROKER_FOLLOWER_FETCH_TOTAL_TIME_MS_MEAN(MetricScope.BROKER, 33),
    BROKER_PRODUCE_LOCAL_TIME_MS_MAX(MetricScope.BROKER, 34),
    BROKER_PRODUCE_LOCAL_TIME_MS_MEAN(MetricScope.BROKER, 35),
    BROKER_CONSUMER_FETCH_LOCAL_TIME_MS_MAX(MetricScope.BROKER, 36),
    BROKER_CONSUMER_FETCH_LOCAL_TIME_MS_MEAN(MetricScope.BROKER, 37),
    BROKER_FOLLOWER_FETCH_LOCAL_TIME_MS_MAX(MetricScope.BROKER, 38),
    BROKER_FOLLOWER_FETCH_LOCAL_TIME_MS_MEAN(MetricScope.BROKER, 39),
    BROKER_LOG_FLUSH_RATE(MetricScope.BROKER, 40),
    BROKER_LOG_FLUSH_TIME_MS_MAX(MetricScope.BROKER, 41),
    BROKER_LOG_FLUSH_TIME_MS_MEAN(MetricScope.BROKER, 42),
    BROKER_PRODUCE_REQUEST_QUEUE_TIME_MS_50TH(MetricScope.BROKER, 43),
    BROKER_PRODUCE_REQUEST_QUEUE_TIME_MS_999TH(MetricScope.BROKER, 44),
    BROKER_CONSUMER_FETCH_REQUEST_QUEUE_TIME_MS_50TH(MetricScope.BROKER, 45),
    BROKER_CONSUMER_FETCH_REQUEST_QUEUE_TIME_MS_999TH(MetricScope.BROKER, 46),
    BROKER_FOLLOWER_FETCH_REQUEST_QUEUE_TIME_MS_50TH(MetricScope.BROKER, 47),
    BROKER_FOLLOWER_FETCH_REQUEST_QUEUE_TIME_MS_999TH(MetricScope.BROKER, 48),
    BROKER_PRODUCE_TOTAL_TIME_MS_50TH(MetricScope.BROKER, 49),
    BROKER_PRODUCE_TOTAL_TIME_MS_999TH(MetricScope.BROKER, 50),
    BROKER_CONSUMER_FETCH_TOTAL_TIME_MS_50TH(MetricScope.BROKER, 51),
    BROKER_CONSUMER_FETCH_TOTAL_TIME_MS_999TH(MetricScope.BROKER, 52),
    BROKER_FOLLOWER_FETCH_TOTAL_TIME_MS_50TH(MetricScope.BROKER, 53),
    BROKER_FOLLOWER_FETCH_TOTAL_TIME_MS_999TH(MetricScope.BROKER, 54),
    BROKER_PRODUCE_LOCAL_TIME_MS_50TH(MetricScope.BROKER, 55),
    BROKER_PRODUCE_LOCAL_TIME_MS_999TH(MetricScope.BROKER, 56),
    BROKER_CONSUMER_FETCH_LOCAL_TIME_MS_50TH(MetricScope.BROKER, 57),
    BROKER_CONSUMER_FETCH_LOCAL_TIME_MS_999TH(MetricScope.BROKER, 58),
    BROKER_FOLLOWER_FETCH_LOCAL_TIME_MS_50TH(MetricScope.BROKER, 59),
    BROKER_FOLLOWER_FETCH_LOCAL_TIME_MS_999TH(MetricScope.BROKER, 60),
    BROKER_LOG_FLUSH_TIME_MS_50TH(MetricScope.BROKER, 61),
    BROKER_LOG_FLUSH_TIME_MS_999TH(MetricScope.BROKER, 62),
    BROKER_DISK_CAPACITY(MetricScope.BROKER, 63),
    TOPIC_FOLLOWER_FETCH_REQUEST_RATE(MetricScope.TOPIC, 64),
    ALL_TOPIC_FOLLOWER_FETCH_REQUEST_RATE(MetricScope.BROKER, 65),
    TOPIC_FETCH_FROM_FOLLOWER_BYTES_OUT(MetricScope.TOPIC, 66),
    ALL_TOPIC_FETCH_FROM_FOLLOWER_BYTES_OUT(MetricScope.BROKER, 67),
    TOPIC_FETCH_FROM_FOLLOWER_REQUEST_RATE(MetricScope.TOPIC, 68),
    ALL_TOPIC_FETCH_FROM_FOLLOWER_REQUEST_RATE(MetricScope.BROKER, 69);

    private static final Set<RawMetricType> BROKER_METRIC_TYPES;
    private static final List<RawMetricType> TOPIC_METRIC_TYPES;
    private final byte id;
    private final MetricScope metricScope;

    private RawMetricType(MetricScope scope, byte id) {
        this.id = id;
        this.metricScope = scope;
    }

    public byte id() {
        return this.id;
    }

    public MetricScope metricScope() {
        return this.metricScope;
    }

    public static List<RawMetricType> topicMetricTypes() {
        return TOPIC_METRIC_TYPES;
    }

    public static Set<RawMetricType> brokerMetricTypes() {
        return BROKER_METRIC_TYPES;
    }

    public static RawMetricType forId(byte id) {
        if (id < RawMetricType.values().length) {
            return RawMetricType.values()[id];
        }
        throw new IllegalArgumentException("CruiseControlMetric type " + id + " does not exist.");
    }

    private static Set<RawMetricType> buildBrokerMetricTypes() {
        HashSet<RawMetricType> buildBrokerMetricTypes = new HashSet<RawMetricType>();
        for (RawMetricType type : RawMetricType.values()) {
            if (type.metricScope() != MetricScope.BROKER) continue;
            buildBrokerMetricTypes.add(type);
        }
        return buildBrokerMetricTypes;
    }

    private static List<RawMetricType> buildMetricTypeList(MetricScope metricScope) {
        ArrayList<RawMetricType> brokerMetricTypes = new ArrayList<RawMetricType>();
        for (RawMetricType type : RawMetricType.values()) {
            if (type.metricScope() != metricScope) continue;
            brokerMetricTypes.add(type);
        }
        return brokerMetricTypes;
    }

    static {
        BROKER_METRIC_TYPES = RawMetricType.buildBrokerMetricTypes();
        TOPIC_METRIC_TYPES = RawMetricType.buildMetricTypeList(MetricScope.TOPIC);
    }

    public static enum MetricScope {
        BROKER,
        TOPIC,
        PARTITION;

    }
}

