/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.cruisecontrol.monitor.sampling.aggregator.AggregatedMetricValues;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.config.BrokerCapacityInfo;
import com.linkedin.kafka.cruisecontrol.model.Capacity;
import com.linkedin.kafka.cruisecontrol.model.Cell;
import com.linkedin.kafka.cruisecontrol.model.Disk;
import com.linkedin.kafka.cruisecontrol.model.DiskStats;
import com.linkedin.kafka.cruisecontrol.model.Host;
import com.linkedin.kafka.cruisecontrol.model.Load;
import com.linkedin.kafka.cruisecontrol.model.Rack;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import com.linkedin.kafka.cruisecontrol.model.SortedReplicas;
import com.linkedin.kafka.cruisecontrol.model.Utilization;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.kafka.common.TopicPartition;

public class Broker
implements Serializable,
Comparable<Broker> {
    public static final double DEAD_BROKER_CAPACITY = -1.0;
    private final int id;
    private final Host host;
    private final Capacity capacity;
    private final Set<Replica> replicas;
    private final Set<Replica> leaderReplicas;
    private final Map<String, SortedReplicas> sortedReplicas;
    private final Set<Replica> immigrantReplicas;
    private final Set<Replica> currentOfflineReplicas;
    private final Map<String, Map<Integer, Replica>> topicReplicas;
    private final Load load;
    private final Utilization utilization;
    private final Load leadershipLoadForNwResources;
    private final Utilization leadershipUtilizationForNwResources;
    private final SortedMap<String, Disk> diskByLogdir;
    private final Strategy strategy;
    private final Cell cell;

    public Broker(int id, Host host, Cell cell, BrokerCapacityInfo brokerCapacityInfo, boolean populateReplicaPlacementInfo, Strategy strategy) {
        Map<Resource, Double> brokerCapacity = brokerCapacityInfo.capacity();
        if (brokerCapacity == null) {
            throw new IllegalArgumentException("Attempt to create broker " + id + " on host " + host.name() + " with null capacity.");
        }
        this.host = host;
        this.id = id;
        this.strategy = strategy;
        this.capacity = Capacity.from(this, brokerCapacityInfo);
        if (populateReplicaPlacementInfo) {
            this.diskByLogdir = new TreeMap<String, Disk>();
            brokerCapacityInfo.diskCapacityByLogDir().forEach((logDir, value) -> {
                this.diskByLogdir.put((String)logDir, new Disk((String)logDir, this, (double)value));
                if (!this.isAlive()) {
                    ((Disk)this.diskByLogdir.get(logDir)).setState(Disk.State.DEAD);
                }
            });
        } else {
            this.diskByLogdir = Collections.emptySortedMap();
        }
        this.replicas = new HashSet<Replica>();
        this.leaderReplicas = new HashSet<Replica>();
        this.topicReplicas = new HashMap<String, Map<Integer, Replica>>();
        this.sortedReplicas = new HashMap<String, SortedReplicas>();
        this.immigrantReplicas = new HashSet<Replica>();
        this.currentOfflineReplicas = new HashSet<Replica>();
        this.load = new Load();
        this.utilization = Utilization.from(this.load, this.strategy);
        this.leadershipLoadForNwResources = new Load();
        this.leadershipUtilizationForNwResources = Utilization.from(this.leadershipLoadForNwResources, strategy);
        this.cell = cell;
        cell.addBroker(this);
    }

    public Host host() {
        return this.host;
    }

    public Strategy strategy() {
        return this.strategy;
    }

    public Rack rack() {
        return this.host.rack();
    }

    public Cell cell() {
        return this.cell;
    }

    public int id() {
        return this.id;
    }

    public Capacity capacity() {
        return this.capacity;
    }

    public Capacity capacity(Resource resource) {
        return resource.isHostResource() ? this.host.capacity() : this.capacity;
    }

    public double availableResource(Resource resource, BalancingConstraint balancingConstraint) {
        return balancingConstraint.allowedCapacityForBroker(resource, this.capacity()) - this.load().expectedUtilizationFor(resource);
    }

    public Set<Replica> replicas() {
        return Collections.unmodifiableSet(this.replicas);
    }

    public Set<Replica> leaderReplicas() {
        return Collections.unmodifiableSet(this.leaderReplicas);
    }

    public int numLeaderReplicas() {
        return this.leaderReplicas.size();
    }

    public Set<Replica> immigrantReplicas() {
        return Collections.unmodifiableSet(this.immigrantReplicas);
    }

    public Set<Replica> currentOfflineReplicas() {
        return this.currentOfflineReplicas;
    }

    public Replica replica(TopicPartition tp) {
        Map<Integer, Replica> topicReplicas = this.topicReplicas.get(tp.topic());
        if (topicReplicas == null) {
            return null;
        }
        return topicReplicas.get(tp.partition());
    }

    public Collection<Replica> replicasOfTopicInBroker(String topic) {
        Map<Integer, Replica> topicReplicas = this.topicReplicas.get(topic);
        return topicReplicas == null ? Collections.emptySet() : topicReplicas.values();
    }

    public int numReplicasOfTopicInBroker(String topic) {
        Map<Integer, Replica> topicReplicas = this.topicReplicas.get(topic);
        return topicReplicas == null ? 0 : topicReplicas.size();
    }

    public boolean isAlive() {
        return this.strategy != Strategy.DEAD;
    }

    public boolean isEligibleDestination() {
        return this.strategy.isEligibleDestination();
    }

    public boolean isEligibleSource() {
        return this.strategy.isEligibleSource();
    }

    public boolean isEligible() {
        return this.isEligibleSource() || this.isEligibleDestination();
    }

    public boolean isExcludedForReplicaPlacement() {
        return this.strategy == Strategy.IGNORE;
    }

    public boolean isNew() {
        return this.strategy == Strategy.NEW;
    }

    public boolean hasBadDisks() {
        return this.strategy == Strategy.BAD_DISKS;
    }

    public Load load() {
        return this.load;
    }

    public Load load(Resource resource) {
        return resource.isHostResource() ? this.host.load() : this.load;
    }

    public Utilization utilization() {
        return this.utilization;
    }

    public Load leadershipLoadForNwResources() {
        return this.leadershipLoadForNwResources;
    }

    public Utilization leadershipUtilizationForNwResources() {
        return this.leadershipUtilizationForNwResources;
    }

    public Set<String> topics() {
        return this.topicReplicas.keySet();
    }

    public Map<String, String> attributes() {
        return Collections.singletonMap("rack", this.rack().id());
    }

    public SortedReplicas trackedSortedReplicas(String sortName) {
        SortedReplicas sortedReplicas = this.sortedReplicas.get(sortName);
        if (sortedReplicas == null) {
            throw new IllegalStateException("The sort name " + sortName + "  is not found. Make sure trackSortedReplicas() has been called for the sort name");
        }
        return sortedReplicas;
    }

    public Comparator<Replica> replicaComparator() {
        return (r1, r2) -> {
            int result;
            boolean isR1Offline = this.currentOfflineReplicas.contains(r1);
            boolean isR2Offline = this.currentOfflineReplicas.contains(r2);
            if (isR1Offline && !isR2Offline) {
                return -1;
            }
            if (!isR1Offline && isR2Offline) {
                return 1;
            }
            boolean isR1Immigrant = this.immigrantReplicas.contains(r1);
            boolean isR2Immigrant = this.immigrantReplicas.contains(r2);
            int n = isR1Immigrant && !isR2Immigrant ? -1 : (result = !isR1Immigrant && isR2Immigrant ? 1 : 0);
            if (result == 0) {
                if (r1.topicPartition().partition() > r2.topicPartition().partition()) {
                    return 1;
                }
                if (r1.topicPartition().partition() < r2.topicPartition().partition()) {
                    return -1;
                }
            }
            return result;
        };
    }

    void addReplica(Replica replica) {
        if (this.replicas.contains(replica)) {
            throw new IllegalStateException(String.format("Broker %d already has replica %s", this.id, replica.topicPartition()));
        }
        this.replicas.add(replica);
        if (replica.originalBroker().id() != this.id) {
            this.immigrantReplicas.add(replica);
        } else if (replica.isOriginalOffline()) {
            this.currentOfflineReplicas.add(replica);
        }
        this.topicReplicas.computeIfAbsent(replica.topicPartition().topic(), t -> new HashMap()).put(replica.topicPartition().partition(), replica);
        if (replica.isLeader()) {
            this.leadershipLoadForNwResources.addLoad(replica.load());
            this.leaderReplicas.add(replica);
        }
        this.load.addLoad(replica.load());
        this.sortedReplicas.values().forEach(sr -> sr.add(replica));
        if (replica.disk() != null) {
            ((Disk)this.diskByLogdir.get(replica.disk().logDir())).addReplica(replica);
        }
    }

    Disk addDeadDisk(String logdir) {
        Disk disk = new Disk(logdir, this, -1.0);
        this.diskByLogdir.put(logdir, disk);
        return disk;
    }

    void trackSortedReplicas(String sortName, Function<Replica, Boolean> selectionFunc, Function<Replica, Integer> priorityFunc, Function<Replica, Double> scoreFunc) {
        this.sortedReplicas.putIfAbsent(sortName, new SortedReplicas(this, selectionFunc, priorityFunc, scoreFunc));
    }

    void untrackSortedReplicas(String sortName) {
        this.sortedReplicas.remove(sortName);
    }

    private void updateSortedReplicas(Replica replica) {
        this.sortedReplicas.values().forEach(sr -> {
            sr.remove(replica);
            sr.add(replica);
        });
    }

    void makeFollower(TopicPartition tp, AggregatedMetricValues leadershipLoadDelta) {
        Replica replica = this.replica(tp);
        this.leadershipLoadForNwResources.subtractLoad(replica.load());
        replica.makeFollower(leadershipLoadDelta);
        this.load.subtractLoad(leadershipLoadDelta);
        this.leaderReplicas.remove(replica);
        this.updateSortedReplicas(replica);
    }

    void makeLeader(TopicPartition tp, AggregatedMetricValues leadershipLoadDelta) {
        Replica replica = this.replica(tp);
        replica.makeLeader(leadershipLoadDelta);
        this.leadershipLoadForNwResources.addLoad(replica.load());
        this.load.addLoad(leadershipLoadDelta);
        this.leaderReplicas.add(replica);
        this.updateSortedReplicas(replica);
    }

    Replica removeReplica(TopicPartition tp) {
        Replica removedReplica = this.replica(tp);
        if (removedReplica != null) {
            this.replicas.remove(removedReplica);
            this.load.subtractLoad(removedReplica.load());
            Map<Integer, Replica> topicReplicas = this.topicReplicas.get(tp.topic());
            if (topicReplicas != null) {
                topicReplicas.remove(tp.partition());
            }
            if (removedReplica.isLeader()) {
                this.leadershipLoadForNwResources.subtractLoad(removedReplica.load());
                this.leaderReplicas.remove(removedReplica);
            }
            this.immigrantReplicas.remove(removedReplica);
            this.currentOfflineReplicas.remove(removedReplica);
            this.sortedReplicas.values().forEach(sr -> sr.remove(removedReplica));
        }
        return removedReplica;
    }

    void moveReplicaBetweenDisks(TopicPartition tp, String sourceLogdir, String destinationLogdir) {
        Replica replica = this.replica(tp);
        ((Disk)this.diskByLogdir.get(sourceLogdir)).removeReplica(replica);
        ((Disk)this.diskByLogdir.get(destinationLogdir)).addReplica(replica);
    }

    void setReplicaLoad(TopicPartition tp, AggregatedMetricValues aggregatedMetricValues, List<Long> windows) {
        Replica replica = this.replica(tp);
        replica.setMetricValues(aggregatedMetricValues, windows);
        if (replica.disk() != null) {
            replica.disk().addReplicaLoad(replica);
        }
        if (replica.isLeader()) {
            this.leadershipLoadForNwResources.addMetricValues(aggregatedMetricValues, windows);
        }
        this.load.addMetricValues(aggregatedMetricValues, windows);
    }

    public Disk disk(String logdir) {
        return (Disk)this.diskByLogdir.get(logdir);
    }

    public Collection<Disk> disks() {
        return this.diskByLogdir.values();
    }

    public Map<String, Object> getJsonStructure() {
        ArrayList<Map<String, Object>> replicaList = new ArrayList<Map<String, Object>>();
        for (Replica replica : this.replicas) {
            replicaList.add(replica.getJsonStructureForLoad());
        }
        HashMap<String, Object> brokerMap = new HashMap<String, Object>(3);
        brokerMap.put("brokerid", this.id);
        brokerMap.put("brokerstate", (Object)this.strategy);
        brokerMap.put("replicas", replicaList);
        return brokerMap;
    }

    public Map<String, DiskStats> diskStats() {
        if (this.diskByLogdir.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, DiskStats> diskStatMap = new HashMap<String, DiskStats>(this.diskByLogdir.size());
        this.diskByLogdir.forEach((k, v) -> diskStatMap.put((String)k, v.diskStats()));
        return diskStatMap;
    }

    public void writeTo(OutputStream out) throws IOException {
        String broker = String.format("<Broker id=\"%d\" strategy=\"%s\">%n", new Object[]{this.id, this.strategy});
        out.write(broker.getBytes(StandardCharsets.UTF_8));
        for (Disk disk : this.diskByLogdir.values()) {
            disk.writeTo(out);
        }
        if (this.diskByLogdir.isEmpty()) {
            for (Replica replica : this.replicas) {
                replica.writeTo(out);
            }
        }
        out.write("</Broker>%n".getBytes(StandardCharsets.UTF_8));
    }

    public boolean hasReplicaOfPartition(TopicPartition topicPartition) {
        return this.replica(topicPartition) != null;
    }

    public String toString() {
        return String.format("Broker[id=%d,rack=%s,cell=%s,strategy=%s,replicaCount=%d,leaderCount=%d]", new Object[]{this.id, this.rack().id(), this.cell.id(), this.strategy, this.replicas.size(), this.leaderReplicas.size()});
    }

    @Override
    public int compareTo(Broker o) {
        return Integer.compare(this.id, o.id());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Broker broker = (Broker)o;
        return this.id == broker.id;
    }

    public int hashCode() {
        return this.id;
    }

    public static class ResourceComparator
    implements Comparator<Broker> {
        Resource resource;
        BalancingConstraint balancingConstraint;
        Comparator<Broker> comparator;

        public ResourceComparator(Resource resource, BalancingConstraint balancingConstraint) {
            this.resource = resource;
            this.balancingConstraint = balancingConstraint;
            this.comparator = Comparator.comparingDouble(b -> b.availableResource(resource, balancingConstraint));
            this.comparator = this.comparator.reversed();
        }

        @Override
        public int compare(Broker b1, Broker b2) {
            return this.comparator.compare(b1, b2);
        }
    }

    public static enum Strategy {
        GENESIS(true, false),
        ALIVE,
        DEAD(true, false),
        NEW,
        BAD_DISKS(true, false),
        IGNORE(false, false);

        private final boolean isEligibleSource;
        private final boolean isEligibleDestination;

        private Strategy() {
            this.isEligibleSource = true;
            this.isEligibleDestination = true;
        }

        private Strategy(boolean isEligibleSource, boolean isEligibleDestination) {
            this.isEligibleSource = isEligibleSource;
            this.isEligibleDestination = isEligibleDestination;
        }

        public boolean isEligibleDestination() {
            return this.isEligibleDestination;
        }

        public boolean isEligibleSource() {
            return this.isEligibleSource;
        }
    }
}

