/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.cruisecontrol.monitor.sampling.aggregator.AggregatedMetricValues;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.Capacity;
import com.linkedin.kafka.cruisecontrol.model.Load;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import com.linkedin.kafka.cruisecontrol.model.Utilization;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Cell {
    private final Integer id;
    private final Map<Integer, Broker> brokers;
    private final Capacity capacity;
    private final Load load;
    private final Utilization utilization;

    public Cell(Integer id) {
        this.id = id;
        this.brokers = new HashMap<Integer, Broker>();
        this.capacity = Capacity.create();
        this.load = new Load();
        this.utilization = Utilization.from(this.load);
    }

    public void addBroker(Broker broker) {
        this.brokers.put(broker.id(), broker);
        if (broker.isAlive()) {
            this.capacity.addCapacity(broker.capacity());
        }
    }

    public Capacity capacity() {
        return this.capacity;
    }

    public Load load() {
        return this.load;
    }

    public Utilization utilization() {
        return this.utilization;
    }

    void setReplicaLoad(Broker broker, AggregatedMetricValues aggregatedMetricValues, List<Long> windows) {
        this.load.addMetricValues(aggregatedMetricValues, windows);
        this.utilization.addMetricValues(broker.strategy(), aggregatedMetricValues, windows);
    }

    void makeLeader(Broker.Strategy strategy, AggregatedMetricValues leadershipLoadDelta) {
        this.load.addLoad(leadershipLoadDelta);
        this.utilization.addLoad(strategy, leadershipLoadDelta);
    }

    void addReplica(Replica replica) {
        this.load.addLoad(replica.load());
        this.utilization.addLoad(replica.broker().strategy(), replica.load());
    }

    void removeReplica(Replica replica) {
        this.load.subtractLoad(replica.load());
        this.utilization.subtractLoad(replica.broker().strategy(), replica.load());
    }

    void makeFollower(Broker.Strategy strategy, AggregatedMetricValues leadershipLoadDelta) {
        this.load.subtractLoad(leadershipLoadDelta);
        this.utilization.subtractLoad(strategy, leadershipLoadDelta);
    }

    public Integer id() {
        return this.id;
    }

    public Collection<Broker> brokers() {
        return this.brokers.values();
    }

    public Collection<Broker> aliveBrokers() {
        return this.brokers.values().stream().filter(Broker::isAlive).collect(Collectors.toList());
    }

    public Collection<Broker> eligibleBrokers() {
        return this.brokers.values().stream().filter(Broker::isEligibleDestination).collect(Collectors.toList());
    }

    public Broker broker(int brokerId) {
        return this.brokers.get(brokerId);
    }

    public boolean containsBroker(int brokerId) {
        return this.brokers.containsKey(brokerId);
    }

    public List<Replica> replicas() {
        return this.brokers.values().stream().flatMap(broker -> broker.replicas().stream()).collect(Collectors.toList());
    }

    public long numTopicReplicas(String topic) {
        return this.brokers.values().stream().mapToInt(broker -> broker.numReplicasOfTopicInBroker(topic)).sum();
    }

    public int numReplicas() {
        return this.brokers.values().stream().mapToInt(broker -> broker.replicas().size()).sum();
    }

    public Set<String> topics() {
        return this.brokers.values().stream().flatMap(broker -> broker.topics().stream()).collect(Collectors.toSet());
    }

    public boolean isCellAlive() {
        return this.brokers.values().stream().anyMatch(Broker::isAlive);
    }

    public boolean isCellEligible() {
        return this.brokers.values().stream().anyMatch(Broker::isEligibleDestination);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cell cell = (Cell)o;
        return this.id.equals(cell.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "Cell {id=" + this.id + ", brokers=" + this.brokers.size() + "}";
    }
}

