/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.cruisecontrol.metricdef.MetricDef;
import com.linkedin.cruisecontrol.metricdef.MetricInfo;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.AggregatedMetricValues;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricValues;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.monitor.metricdefinition.KafkaMetricDef;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Load
implements Serializable {
    private List<Long> windows = null;
    private final AggregatedMetricValues metricValues = new AggregatedMetricValues();

    public static Builder builder() {
        return new Builder();
    }

    public AggregatedMetricValues loadByWindows() {
        return this.metricValues;
    }

    public int numWindows() {
        return this.metricValues.length();
    }

    public List<Long> windows() {
        return this.windows;
    }

    public double expectedUtilizationFor(Resource resource) {
        return Load.expectedUtilizationFor(resource, this.metricValues, false);
    }

    boolean isEmpty() {
        return this.metricValues.isEmpty();
    }

    void clearLoadFor(Resource resource) {
        KafkaMetricDef.resourceToMetricIds(resource).forEach(id -> this.metricValues.valuesFor((short)id).clear());
    }

    void initializeMetricValues(AggregatedMetricValues aggregatedMetricValues, List<Long> windows) {
        if (this.isInitialized()) {
            throw new IllegalStateException("Metric values already exists, cannot set it again.");
        }
        this.windows = windows;
        this.metricValues.add(aggregatedMetricValues);
    }

    public boolean isInitialized() {
        return !this.metricValues.isEmpty();
    }

    void addMetricValues(AggregatedMetricValues aggregatedMetricValues, List<Long> windows) {
        if (this.windows == null) {
            this.windows = windows;
        }
        this.metricValues.add(aggregatedMetricValues);
    }

    void addLoad(Load loadToAdd) {
        this.metricValues.add(loadToAdd.loadByWindows());
    }

    void subtractLoad(Load loadToSubtract) {
        this.metricValues.subtract(loadToSubtract.loadByWindows());
    }

    void addLoad(AggregatedMetricValues loadToAdd) {
        if (this.isInitialized()) {
            this.metricValues.add(loadToAdd);
        }
    }

    void subtractLoad(AggregatedMetricValues loadToSubtract) {
        if (this.isInitialized()) {
            this.metricValues.subtract(loadToSubtract);
        }
    }

    void clearLoad() {
        this.metricValues.clear();
    }

    AggregatedMetricValues loadFor(Resource resource, boolean shareValueArray) {
        return this.metricValues.valuesFor(KafkaMetricDef.resourceToMetricIds(resource), shareValueArray);
    }

    public Map<String, Object> getJsonStructure() {
        MetricDef metricDef = KafkaMetricDef.commonMetricDef();
        HashMap<String, Object> loadMap = new HashMap<String, Object>();
        ArrayList metricValueList = new ArrayList();
        for (MetricInfo metricInfo : metricDef.all()) {
            MetricValues metricValues = this.metricValues.valuesFor(metricInfo.id());
            if (metricValues == null) continue;
            HashMap<Long, Double> metricValuesMap = new HashMap<Long, Double>();
            for (int i = 0; i < this.windows.size(); ++i) {
                metricValuesMap.put(this.windows.get(i), metricValues.get(i));
            }
            metricValueList.add(metricValuesMap);
        }
        loadMap.put("MetricValues", metricValueList);
        return loadMap;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write("<Load>".getBytes(StandardCharsets.UTF_8));
        this.metricValues.writeTo(out);
        out.write("</Load>%n".getBytes(StandardCharsets.UTF_8));
    }

    public String toString() {
        return String.format("Load[metricValues=%s,windows=%s]", this.metricValues, this.windows);
    }

    public boolean isEqual(Load other) {
        if (this == other) {
            return true;
        }
        return this.metricValues.isEqual(other.metricValues) && Objects.equals(this.windows, other.windows);
    }

    public static double expectedUtilizationFor(Resource resource, AggregatedMetricValues aggregatedMetricValues, boolean ignoreMissingMetric) {
        if (aggregatedMetricValues.isEmpty()) {
            return 0.0;
        }
        double result = 0.0;
        for (MetricInfo info : KafkaMetricDef.resourceToMetricInfo(resource)) {
            MetricValues valuesForId = aggregatedMetricValues.valuesFor(info.id());
            if (!ignoreMissingMetric && valuesForId == null) {
                throw new IllegalArgumentException(String.format("The aggregated metric values does not contain metric %s for resource %s.", info, resource.name()));
            }
            if (valuesForId == null) continue;
            result += resource == Resource.DISK ? (double)valuesForId.latest() : (double)valuesForId.avg();
        }
        return Math.max(result, 0.0);
    }

    public static class Builder {
        private Load base = null;
        private Load loadToAdd = null;
        private Load loadToSubtract = null;

        public Builder base(Load base) {
            this.base = base;
            return this;
        }

        public Builder addLoad(Load loadToAdd) {
            this.loadToAdd = loadToAdd;
            return this;
        }

        public Builder subtractLoad(Load loadToSubtract) {
            this.loadToSubtract = loadToSubtract;
            return this;
        }

        public Load build() {
            Load load = new Load();
            if (this.base != null) {
                load.initializeMetricValues(this.base.loadByWindows(), this.base.windows());
            }
            if (this.loadToAdd != null) {
                load.addLoad(this.loadToAdd);
            }
            if (this.loadToSubtract != null) {
                load.subtractLoad(this.loadToSubtract);
            }
            return load;
        }
    }
}

