/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.model.Cell;
import java.util.Objects;
import org.apache.kafka.common.PartitionPlacementStrategy;

public class Tenant {
    private final String tenantId;
    private final Cell cell;
    private final PartitionPlacementStrategy placementPolicy;

    public Tenant(String tenantId, Cell cell, PartitionPlacementStrategy placementPolicy) {
        Objects.requireNonNull(KafkaCruiseControlUtils.convertEmptyToNull(tenantId));
        this.tenantId = tenantId;
        this.cell = cell;
        this.placementPolicy = placementPolicy;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public Cell cell() {
        return this.cell;
    }

    public PartitionPlacementStrategy placementPolicy() {
        return this.placementPolicy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tenant tenant = (Tenant)o;
        return this.tenantId.equals(tenant.tenantId);
    }

    public int hashCode() {
        return this.tenantId.hashCode();
    }

    public String toString() {
        return "Tenant {tenantId=" + this.tenantId + ", cell=" + this.cell + ", placementPolicy=" + this.placementPolicy + "}";
    }
}

