/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model.util;

import com.linkedin.kafka.cruisecontrol.analyzer.AnalyzerUtils;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.common.Statistic;
import com.linkedin.kafka.cruisecontrol.model.ClusterModelStats;
import com.linkedin.kafka.cruisecontrol.model.util.ClusterModelStatsComparator;

public class ClusterModelStatsByResourceUtilizationDeviationComparator
implements ClusterModelStatsComparator {
    private final String goalName;
    private final Resource resource;
    private String reasonForLastNegativeResult;

    public ClusterModelStatsByResourceUtilizationDeviationComparator(String goalName, Resource resource) {
        this.goalName = goalName;
        this.resource = resource;
    }

    @Override
    public int compare(ClusterModelStats statsAfterOptimization, ClusterModelStats statsBeforeOptimization) {
        int numBalancedBrokerBeforeOptimization;
        int numBalancedBrokerAfterOptimization = statsAfterOptimization.numBalancedBrokersByResource().get((Object)this.resource);
        if (numBalancedBrokerAfterOptimization <= (numBalancedBrokerBeforeOptimization = statsBeforeOptimization.numBalancedBrokersByResource().get((Object)this.resource).intValue())) {
            double utilizationStdAfterOptimization = statsAfterOptimization.resourceUtilizationStats().get((Object)Statistic.ST_DEV).get((Object)this.resource);
            double utilizationStdBeforeOptimization = statsBeforeOptimization.resourceUtilizationStats().get((Object)Statistic.ST_DEV).get((Object)this.resource);
            int utilizationStdCompareResult = AnalyzerUtils.compare(utilizationStdBeforeOptimization, utilizationStdAfterOptimization, this.resource);
            if (utilizationStdCompareResult < 0) {
                this.reasonForLastNegativeResult = String.format("Violated %s. [Number of Balanced Brokers] for resource %s. post-optimization:%d pre-optimization:%d without improving the standard dev. of utilization. post-optimization:%.2f pre-optimization:%.2f", new Object[]{this.goalName, this.resource, numBalancedBrokerAfterOptimization, numBalancedBrokerBeforeOptimization, utilizationStdAfterOptimization, utilizationStdBeforeOptimization});
            }
            return utilizationStdCompareResult;
        }
        return 1;
    }

    @Override
    public String explainLastComparison() {
        return this.reasonForLastNegativeResult;
    }
}

