/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.sampling;

import com.linkedin.kafka.cruisecontrol.exception.MetricSamplingException;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class MetricFetcher
implements Callable<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(MetricFetcher.class);

    MetricFetcher() {
    }

    @Override
    public Boolean call() {
        boolean hasSamplingError = false;
        try {
            this.fetchMetricsForAssignedPartitions();
        }
        catch (MetricSamplingException mse) {
            LOG.warn("Received sampling error.", (Throwable)mse);
            hasSamplingError = true;
        }
        catch (Throwable t) {
            LOG.error("Received exception.", t);
            hasSamplingError = true;
        }
        return hasSamplingError;
    }

    protected abstract void fetchMetricsForAssignedPartitions() throws MetricSamplingException;
}

