/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.sampling;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.SbkTopicUtils;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import io.confluent.kafka.clients.CloudAdmin;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleStoreTopicCleanUp {
    private static final Logger LOG = LoggerFactory.getLogger(SampleStoreTopicCleanUp.class);

    public static void maybeDeleteSampleStoreTopic(KafkaCruiseControlConfig kafkaCruiseControlConfig, Semaphore semaphore) {
        Map<String, Object> config = kafkaCruiseControlConfig.mergedConfigValues();
        List<String> sampleStoreTopics = Arrays.asList((String)config.get("broker.metric.sample.store.topic"), (String)config.get("partition.metric.sample.store.topic"));
        try (CloudAdmin adminClient = KafkaCruiseControlUtils.createAdmin(KafkaCruiseControlUtils.filterAdminClientConfigs(config));){
            ListTopicsOptions options = new ListTopicsOptions().listInternal(true);
            Set allTopics = (Set)adminClient.listTopics(options).names().get();
            SbkTopicUtils.deleteTopics((ConfluentAdmin)adminClient, allTopics, sampleStoreTopics);
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Error while listing/deleting sample store topics {}", sampleStoreTopics, (Object)e);
        }
    }
}

