/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.sampling.aggregator;

import com.linkedin.cruisecontrol.exception.NotEnoughValidWindowsException;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.AggregationOptions;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricSampleAggregationResult;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricSampleAggregator;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.monitor.metricdefinition.KafkaMetricDef;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.BrokerEntity;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaBrokerMetricSampleAggregator
extends MetricSampleAggregator<BrokerEntity> {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaBrokerMetricSampleAggregator.class);
    private static final double MIN_VALID_BROKER_RATIO = 0.0;
    private static final double MIN_VALID_GROUP_RATIO = 0.0;
    private static final int MIN_VALID_WINDOWS = 1;
    private static final boolean INCLUDE_INVALID_ENTITIES = false;
    private static final long FIRST_METRIC_WINDOW_TIMESTAMP = -1L;
    private final int maxAllowedExtrapoloationsPerBroker;

    public KafkaBrokerMetricSampleAggregator(KafkaCruiseControlConfig config) {
        super(config.getInt("num.broker.metrics.windows"), config.getLong("broker.metrics.window.ms"), config.getInt("min.samples.per.broker.metrics.window").byteValue(), config.getInt("broker.metric.sample.aggregator.completeness.cache.size"), KafkaMetricDef.brokerMetricDef());
        this.maxAllowedExtrapoloationsPerBroker = config.getInt("max.allowed.extrapolations.per.broker");
        this.sampleType = MetricSampleAggregator.SampleType.BROKER;
    }

    public MetricSampleAggregationResult<BrokerEntity> aggregate(Set<BrokerEntity> brokerEntities) {
        AggregationOptions<BrokerEntity> aggregationOptions = new AggregationOptions<BrokerEntity>(0.0, 0.0, 1, this.maxAllowedExtrapoloationsPerBroker, brokerEntities, AggregationOptions.Granularity.ENTITY, false);
        if (super.numAvailableWindows() < 1) {
            LOG.trace("No window is available for any broker.");
            return new MetricSampleAggregationResult<BrokerEntity>(this.generation(), this.completeness(-1L, System.currentTimeMillis(), aggregationOptions));
        }
        try {
            return this.aggregate(-1L, System.currentTimeMillis(), aggregationOptions);
        }
        catch (NotEnoughValidWindowsException e) {
            return new MetricSampleAggregationResult<BrokerEntity>(this.generation(), this.completeness(-1L, System.currentTimeMillis(), aggregationOptions));
        }
    }
}

