/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.sampling.aggregator;

import com.linkedin.cruisecontrol.exception.NotEnoughValidWindowsException;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.AggregationOptions;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricSampleAggregationResult;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricSampleAggregator;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricSampleCompleteness;
import com.linkedin.kafka.cruisecontrol.common.MetadataClient;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.monitor.ModelCompletenessRequirements;
import com.linkedin.kafka.cruisecontrol.monitor.metricdefinition.KafkaMetricDef;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.ReplicaEntity;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;

public class KafkaReplicaMetricSampleAggregator
extends MetricSampleAggregator<ReplicaEntity> {
    private static final double DEFAULT_MIN_VALID_ENTITY_RATIO = 0.0;
    private static final int DEFAULT_MIN_VALID_WINDOWS = 1;
    private static final boolean DEFAULT_INCLUDE_INVALID_ENTITIES = true;
    private static final double DEFAULT_MIN_MONITORED_PARTITIONS_PERCENTAGE = 0.0;
    private final int maxAllowedExtrapolationsPerPartition;

    public KafkaReplicaMetricSampleAggregator(KafkaCruiseControlConfig config) {
        super(config.getInt("num.partition.metrics.windows"), config.getLong("partition.metrics.window.ms"), config.getInt("min.samples.per.partition.metrics.window").byteValue(), config.getInt("partition.metric.sample.aggregator.completeness.cache.size"), KafkaMetricDef.replicaMetricDef());
        this.sampleType = MetricSampleAggregator.SampleType.REPLICA;
        this.maxAllowedExtrapolationsPerPartition = config.getInt("max.allowed.extrapolations.per.partition");
    }

    MetricSampleAggregationResult<ReplicaEntity> aggregate(Cluster cluster, long now) throws NotEnoughValidWindowsException {
        ModelCompletenessRequirements requirements = new ModelCompletenessRequirements(1, 0.0, false);
        return this.aggregate(cluster, now, requirements);
    }

    public MetricSampleAggregationResult<ReplicaEntity> aggregate(Cluster cluster, long now, ModelCompletenessRequirements requirements, Set<Integer> failedBrokers) throws NotEnoughValidWindowsException {
        HashSet<ReplicaEntity> replicaEntities = new HashSet<ReplicaEntity>();
        cluster.nodes().stream().flatMap(node -> cluster.partitionsForNode(node.id()).stream()).filter(partitionInfo -> partitionInfo.leader() != null).forEach(partitionInfo -> {
            int leaderId = partitionInfo.leader().id();
            for (Node replica : partitionInfo.replicas()) {
                ReplicaEntity replicaEntity = new ReplicaEntity((PartitionInfo)partitionInfo, replica.id(), replica.id() == leaderId);
                replicaEntities.add(replicaEntity);
            }
        });
        AggregationOptions<ReplicaEntity> options = this.aggregationOptions(requirements.minMonitoredPartitionsPercentage(), requirements.minRequiredNumWindows(), replicaEntities, requirements.includeAllTopics());
        return this.aggregate(-1L, now, options, failedBrokers);
    }

    public MetricSampleAggregationResult<ReplicaEntity> aggregate(Cluster cluster, long now, ModelCompletenessRequirements requirements) throws NotEnoughValidWindowsException {
        return this.aggregate(cluster, now, requirements, Collections.emptySet());
    }

    public Set<Long> validWindows(MetadataClient.ClusterAndGeneration clusterAndGeneration, double minMonitoredPartitionsPercentage, Set<Integer> failedBrokerIds) {
        Cluster cluster = clusterAndGeneration.cluster();
        Set<ReplicaEntity> allReplicas = cluster.topics().stream().flatMap(topic -> cluster.partitionsForTopic(topic).stream()).flatMap(pi -> Arrays.stream(pi.replicas()).map(replica -> new ReplicaEntity((PartitionInfo)pi, replica.id(), replica.equals((Object)pi.leader())))).collect(Collectors.toSet());
        return this.validWindows(allReplicas, minMonitoredPartitionsPercentage, failedBrokerIds);
    }

    public Set<Long> validWindows(MetadataClient.ClusterAndGeneration clusterAndGeneration, double minMonitoredPartitionsPercentage) {
        return this.validWindows(clusterAndGeneration, minMonitoredPartitionsPercentage, Collections.emptySet());
    }

    public Set<Long> validWindows(Set<ReplicaEntity> allReplicas, double minMonitoredPartitionsPercentage, Set<Integer> failedBrokerIds) {
        MetricSampleCompleteness<ReplicaEntity> completeness = this.sampleCompleteness(minMonitoredPartitionsPercentage, allReplicas, failedBrokerIds);
        return this.windowIndicesToWindows(completeness.validWindowIndices(), this.windowMs);
    }

    public Set<Long> validWindows(Set<ReplicaEntity> allReplicas, double minMonitoredPartitionsPercentage) {
        return this.validWindows(allReplicas, minMonitoredPartitionsPercentage, Collections.emptySet());
    }

    public double monitoredPercentage(Set<ReplicaEntity> allReplicas) {
        MetricSampleCompleteness<ReplicaEntity> completeness = this.sampleCompleteness(0.0, allReplicas);
        return completeness.validEntityRatio();
    }

    public Map<Long, Float> validReplicaRatioByWindows(Set<ReplicaEntity> allReplicas) {
        MetricSampleCompleteness<ReplicaEntity> completeness = this.sampleCompleteness(0.0, allReplicas);
        return this.windowIndicesToWindows(completeness.validEntityRatioWithGroupGranularityByWindowIndex(), this.windowMs);
    }

    private MetricSampleCompleteness<ReplicaEntity> sampleCompleteness(double minMonitoredPartitionsPercentage, Set<ReplicaEntity> replicaEntities, Set<Integer> failedBrokerIds) {
        AggregationOptions<ReplicaEntity> options = this.aggregationOptions(minMonitoredPartitionsPercentage, 1, replicaEntities, true);
        return this.completeness(-1L, Long.MAX_VALUE, options, failedBrokerIds);
    }

    private MetricSampleCompleteness<ReplicaEntity> sampleCompleteness(double minMonitoredPartitionsPercentage, Set<ReplicaEntity> replicaEntities) {
        AggregationOptions<ReplicaEntity> options = this.aggregationOptions(minMonitoredPartitionsPercentage, 1, replicaEntities, true);
        return this.completeness(-1L, Long.MAX_VALUE, options, Collections.emptySet());
    }

    private AggregationOptions<ReplicaEntity> aggregationOptions(double minMonitoredPartitionsPercentage, int minValidWindows, Set<ReplicaEntity> allReplicas, boolean includeInvalidEntities) {
        return new AggregationOptions<ReplicaEntity>(minMonitoredPartitionsPercentage, 0.0, minValidWindows, this.maxAllowedExtrapolationsPerPartition, allReplicas, AggregationOptions.Granularity.ENTITY_GROUP, includeInvalidEntities);
    }
}

