/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.sampling.holder;

import com.linkedin.cruisecontrol.model.Entity;
import java.util.Objects;
import org.apache.kafka.common.PartitionInfo;

public class ReplicaEntity
extends Entity {
    private final PartitionInfo tp;
    private final int brokerId;
    private final boolean isLeader;

    public ReplicaEntity(PartitionInfo tp, int brokerId, boolean isLeader) {
        this.tp = tp;
        this.brokerId = brokerId;
        this.isLeader = isLeader;
    }

    @Override
    public String group() {
        return this.tp.topic();
    }

    public PartitionInfo tp() {
        return this.tp;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public boolean isLeader() {
        return this.isLeader;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tp.topic(), this.tp.partition(), this.brokerId);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ReplicaEntity && this.isPartitionEqual(((ReplicaEntity)other).tp()) && this.brokerId == ((ReplicaEntity)other).brokerId;
    }

    private boolean isPartitionEqual(PartitionInfo partitionInfo) {
        return this.tp.topic().equals(partitionInfo.topic()) && this.tp.partition() == partitionInfo.partition();
    }

    public String toString() {
        return String.format("Broker: %d, %s", this.brokerId, this.tp);
    }
}

