/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.operation;

import com.linkedin.kafka.cruisecontrol.operation.BrokerRemovalCallback;
import com.linkedin.kafka.cruisecontrol.operation.BrokerRemovalContext;
import com.linkedin.kafka.cruisecontrol.operation.BrokerRemovalPhase;
import io.confluent.databalancer.operation.BrokerRemovalStateMachine;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerRemovalPhaseExecutor<T> {
    private final BrokerRemovalCallback progressCallback;
    private BrokerRemovalContext removalArgs;
    private final BrokerRemovalStateMachine.BrokerRemovalEvent successEvent;
    private final BrokerRemovalStateMachine.BrokerRemovalEvent failureEvent;
    private Function<Set<Integer>, String> errMsgSupplier;
    private Class<? extends Exception> exceptionWrapper;
    private static final Logger LOG = LoggerFactory.getLogger(BrokerRemovalPhaseExecutor.class);

    private BrokerRemovalPhaseExecutor(BrokerRemovalCallback progressCallback, BrokerRemovalContext removalArgs, BrokerRemovalStateMachine.BrokerRemovalEvent successEvent, BrokerRemovalStateMachine.BrokerRemovalEvent failureEvent, Function<Set<Integer>, String> errMsgSupplier, Class<? extends Exception> exceptionWrapper) {
        this.progressCallback = progressCallback;
        this.removalArgs = removalArgs;
        this.successEvent = successEvent;
        this.failureEvent = failureEvent;
        this.errMsgSupplier = errMsgSupplier;
        this.exceptionWrapper = exceptionWrapper;
    }

    public CompletableFuture<T> execute(BrokerRemovalPhase<T> phase) {
        CompletableFuture<T> future = new CompletableFuture<T>();
        try {
            T result = phase.execute(this.removalArgs);
            if (this.successEvent != null && !phase.hasSkippedExecution()) {
                this.progressCallback.registerEvent(this.successEvent);
            }
            future.complete(result);
        }
        catch (InterruptedException ie) {
            LOG.warn("Broker removal phase execution was interrupted", (Throwable)ie);
            future.completeExceptionally(ie);
        }
        catch (Exception e) {
            Exception exception = this.maybeWrapException(e);
            LOG.error(e.getMessage(), (Throwable)e);
            try {
                if (this.failureEvent != null) {
                    this.progressCallback.registerEvent(this.failureEvent, exception);
                }
            }
            catch (Exception registerException) {
                LOG.error("Caught exception while registering the {} event with failure {}. Cause: ", new Object[]{this.failureEvent, e, registerException});
            }
            future.completeExceptionally(exception);
        }
        return future;
    }

    private Exception maybeWrapException(Exception e) {
        if (this.exceptionWrapper != null && !this.exceptionWrapper.isInstance(e)) {
            try {
                Exception newException;
                String errMsg = this.errMsgSupplier.apply(this.removalArgs.brokersToRemove());
                e = newException = this.exceptionWrapper.getDeclaredConstructor(String.class, Throwable.class).newInstance(errMsg, e);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                LOG.error("Received an unexpected reflection exception when executing a broker removal phase.", (Throwable)e);
            }
        }
        return e;
    }

    public static class Builder<T> {
        private final BrokerRemovalStateMachine.BrokerRemovalEvent successEvent;
        private final BrokerRemovalStateMachine.BrokerRemovalEvent failureEvent;
        private final Function<Set<Integer>, String> errMsgSupplier;
        private final Class<? extends Exception> exceptionWrapper;

        public Builder(BrokerRemovalStateMachine.BrokerRemovalEvent successEvent, BrokerRemovalStateMachine.BrokerRemovalEvent failureEvent, Function<Set<Integer>, String> errMsgSupplier) {
            this(successEvent, failureEvent, errMsgSupplier, null);
        }

        public Builder(BrokerRemovalStateMachine.BrokerRemovalEvent successEvent, BrokerRemovalStateMachine.BrokerRemovalEvent failureEvent, Function<Set<Integer>, String> errMsgSupplier, Class<? extends Exception> exceptionWrapper) {
            this.successEvent = successEvent;
            this.failureEvent = failureEvent;
            this.errMsgSupplier = errMsgSupplier;
            this.exceptionWrapper = exceptionWrapper;
        }

        public BrokerRemovalPhaseExecutor<T> build(BrokerRemovalCallback progressCallback, BrokerRemovalContext removalArgs) {
            return new BrokerRemovalPhaseExecutor(progressCallback, removalArgs, this.successEvent, this.failureEvent, this.errMsgSupplier, this.exceptionWrapper);
        }
    }
}

