/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.ActionAcceptance;
import com.linkedin.kafka.cruisecontrol.analyzer.PartitionBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.ReplicaBalancingAction;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import io.confluent.cruisecontrol.analyzer.goals.AbstractAcceptanceGoal;

public class CrossRackMovementGoal
extends AbstractAcceptanceGoal {
    @Override
    public ActionAcceptance replicaActionAcceptance(ReplicaBalancingAction action, ClusterModel clusterModel) {
        switch (action.balancingAction()) {
            case LEADERSHIP_MOVEMENT: {
                return ActionAcceptance.ACCEPT;
            }
            case INTRA_BROKER_REPLICA_MOVEMENT: 
            case INTER_BROKER_REPLICA_MOVEMENT: 
            case INTER_BROKER_REPLICA_SWAP: 
            case INTRA_BROKER_REPLICA_SWAP: {
                if (!clusterModel.broker(action.sourceBrokerId()).rack().id().equals(clusterModel.broker(action.destinationBrokerId()).rack().id())) {
                    return ActionAcceptance.BROKER_REJECT;
                }
                return ActionAcceptance.ACCEPT;
            }
        }
        throw new IllegalArgumentException("Balancing action " + (Object)((Object)action.balancingAction()) + "is not supported across racks");
    }

    @Override
    public ActionAcceptance partitionActionAcceptance(PartitionBalancingAction action, ClusterModel clusterModel) {
        return ActionAcceptance.REPLICA_REJECT;
    }

    @Override
    public String name() {
        return CrossRackMovementGoal.class.getSimpleName();
    }
}

