/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.cruisecontrol.analyzer.history;

import io.confluent.cruisecontrol.analyzer.history.TopicPartitionHistory;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;

public abstract class AbstractTopicPartitionHistory
implements TopicPartitionHistory {
    private final Time time;
    private final TopicPartition tp;
    private final long deadlineMs;
    private final long epoch;

    AbstractTopicPartitionHistory(Time time, TopicPartition tp, long expirationMs, long epoch) {
        this.time = time;
        this.tp = Objects.requireNonNull(tp, "Cannot create TopicPartitionHistory with null TopicPartition");
        if (expirationMs <= 0L) {
            throw new IllegalArgumentException("Cannot create TopicPartitionHistory with expirationMs <= 0");
        }
        this.deadlineMs = time.hiResClockMs() + expirationMs;
        this.epoch = epoch;
    }

    @Override
    public TopicPartition topicPartition() {
        return this.tp;
    }

    @Override
    public long epoch() {
        return this.epoch;
    }

    @Override
    public long deadlineMs() {
        return this.deadlineMs;
    }

    @Override
    public long untilDeadline(TimeUnit unit) {
        return unit.convert(this.deadlineMs - this.time.hiResClockMs(), TimeUnit.MILLISECONDS);
    }
}

