/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.cruisecontrol.analyzer.history;

import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.TopicPartition;

public interface TopicPartitionHistory
extends Comparable<TopicPartitionHistory> {
    public TopicPartition topicPartition();

    public long epoch();

    public long deadlineMs();

    public long untilDeadline(TimeUnit var1);

    @Override
    default public int compareTo(TopicPartitionHistory that) {
        int result = Long.compare(this.epoch(), that.epoch());
        if (result == 0 && (result = Long.compare(this.deadlineMs(), that.deadlineMs())) == 0) {
            TopicPartition tp = this.topicPartition();
            TopicPartition thatTp = that.topicPartition();
            result = tp.topic().compareTo(thatTp.topic());
            if (result == 0) {
                result = Integer.compare(tp.partition(), thatTp.partition());
            }
        }
        return result;
    }
}

