/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.cruisecontrol.analyzer.history;

import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import io.confluent.cruisecontrol.analyzer.history.AbstractTopicPartitionHistory;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;

public final class TopicPartitionMovement
extends AbstractTopicPartitionHistory {
    private final int sourceBroker;
    private final int destinationBroker;
    private final Class<? extends Goal> proposingGoal;
    private final String movementReason;
    private final long timestampMs;

    public TopicPartitionMovement(TopicPartition tp, int sourceBroker, int destinationBroker, Class<? extends Goal> proposingGoal, String movementReason, long expirationMs, long epoch) {
        this(Time.SYSTEM, tp, sourceBroker, destinationBroker, proposingGoal, movementReason, expirationMs, epoch);
    }

    TopicPartitionMovement(Time time, TopicPartition tp, int sourceBroker, int destinationBroker, Class<? extends Goal> proposingGoal, String movementReason, long expirationMs, long epoch) {
        super(time, tp, expirationMs, epoch);
        this.sourceBroker = sourceBroker;
        this.destinationBroker = destinationBroker;
        this.proposingGoal = proposingGoal;
        this.movementReason = movementReason;
        this.timestampMs = time.milliseconds();
    }

    public int sourceBroker() {
        return this.sourceBroker;
    }

    public int destinationBroker() {
        return this.destinationBroker;
    }

    public Class<? extends Goal> proposingGoal() {
        return this.proposingGoal;
    }

    public String movementReason() {
        return this.movementReason;
    }

    public long timestampMs() {
        return this.timestampMs;
    }

    public String toString() {
        return "TopicPartitionMovement{sourceBroker=" + this.sourceBroker + ", destinationBroker=" + this.destinationBroker + ", proposingGoal='" + this.proposingGoal.getSimpleName() + '\'' + ", movementReason='" + this.movementReason + '\'' + ", timestampMs=" + this.timestampMs + ", tp=" + this.topicPartition() + ", deadlineMs=" + this.deadlineMs() + ", epoch=" + this.epoch() + '}';
    }
}

