/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer;

import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class BalancerEnabledConfig {
    private static final Logger LOG = LoggerFactory.getLogger(BalancerEnabledConfig.class);
    private boolean isConfiguredEnabled;
    private boolean demotedBrokersExist;
    private boolean demotionSupportEnabled;

    public BalancerEnabledConfig(boolean isEnabled, boolean isDemotionSupportEnabled) {
        this(false, isEnabled, isDemotionSupportEnabled);
    }

    BalancerEnabledConfig(boolean demotedBrokersExist, boolean isEnabled, boolean isDemotionSupportEnabled) {
        this.demotedBrokersExist = demotedBrokersExist;
        this.isConfiguredEnabled = isEnabled;
        this.demotionSupportEnabled = isDemotionSupportEnabled;
    }

    public synchronized boolean isConfiguredAsEnabled() {
        return this.isConfiguredEnabled;
    }

    public synchronized boolean shouldBeEnabled() {
        return this.isConfiguredAsEnabled() && (this.demotionSupportEnabled || !this.demotedBrokersExist);
    }

    public synchronized boolean maybeUpdateDemotedBrokers(boolean newDemotedBrokersExistValue) {
        return this.maybeUpdate(this.isConfiguredEnabled, newDemotedBrokersExistValue);
    }

    public synchronized boolean maybeUpdateConfigValue(boolean newIsEnabledValue) {
        return this.maybeUpdate(newIsEnabledValue, this.demotedBrokersExist);
    }

    public synchronized boolean maybeUpdate(boolean newEnabledValue, boolean newDemotedBrokersExistValue) {
        if (newEnabledValue == this.isConfiguredEnabled && newDemotedBrokersExistValue == this.demotedBrokersExist) {
            LOG.trace("Will not update balancer config {} as the supplied values are the same - enabled: {}, demotedBrokers: {}", new Object[]{this, newEnabledValue, newDemotedBrokersExistValue});
            return false;
        }
        String logMessage = newEnabledValue != this.isConfiguredEnabled && newDemotedBrokersExistValue != this.demotedBrokersExist ? "Changed both the configured SBC enabled value and the existence of demoted brokers." : (newDemotedBrokersExistValue != this.demotedBrokersExist ? "Changed the existence of demoted brokers" : "Changed the configured SBC enabled value");
        boolean oldShouldBeEnabled = this.shouldBeEnabled();
        this.isConfiguredEnabled = newEnabledValue;
        this.demotedBrokersExist = newDemotedBrokersExistValue;
        boolean newShouldBeEnabled = this.shouldBeEnabled();
        boolean shouldChange = newShouldBeEnabled != oldShouldBeEnabled;
        logMessage = shouldChange ? logMessage + String.format(" The Balancer should be %s", newShouldBeEnabled) : logMessage + String.format(" The Balancer should still stay as %s", newShouldBeEnabled);
        logMessage = logMessage + String.format(" (%s)", this);
        LOG.info(logMessage);
        return shouldChange;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BalancerEnabledConfig that = (BalancerEnabledConfig)o;
        return this.isConfiguredEnabled == that.isConfiguredEnabled && this.demotedBrokersExist == that.demotedBrokersExist && this.demotionSupportEnabled == that.demotionSupportEnabled;
    }

    public int hashCode() {
        return Objects.hash(this.isConfiguredEnabled, this.demotedBrokersExist, this.demotionSupportEnabled);
    }

    public String toString() {
        return "BalancerEnabledConfig{isEnabled=" + this.isConfiguredEnabled + ", demotedBrokersExist=" + this.demotedBrokersExist + ", demotionSupportEnabled=" + this.demotionSupportEnabled + "}";
    }
}

