/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.operation.BrokerRemovalFuture;
import io.confluent.databalancer.DataBalanceEngineContext;
import io.confluent.databalancer.metrics.DataBalancerMetricsRegistry;
import io.confluent.databalancer.operation.BalancerStatusTracker;
import io.confluent.databalancer.operation.BrokerAdditionStateManager;
import io.confluent.databalancer.operation.BrokerRemovalStateTracker;
import io.confluent.databalancer.operation.EvenClusterLoadStateManager;
import io.confluent.databalancer.persistence.ApiStatePersistenceStore;
import io.confluent.databalancer.utils.ImmutableSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.kafka.common.utils.Time;

public class ConfluentDataBalanceEngineContext
implements DataBalanceEngineContext {
    private final DataBalancerMetricsRegistry dataBalancerMetricsRegistry;
    private final Time time;
    final Map<ImmutableSet<Integer>, BrokerRemovalFuture> brokerRemovalFutures;
    Map<ImmutableSet<Integer>, BrokerRemovalStateTracker> brokerRemovalsStateTrackers;
    Map<Integer, BrokerAdditionStateManager> brokerAdditionsStateManagers;
    private volatile BalancerStatusTracker balancerStatusTracker;
    private volatile KafkaCruiseControl cruiseControl;
    private volatile ApiStatePersistenceStore persistenceStore;

    public ConfluentDataBalanceEngineContext(DataBalancerMetricsRegistry dataBalancerMetricsRegistry, KafkaCruiseControl cruiseControl, Time time) {
        this.dataBalancerMetricsRegistry = Objects.requireNonNull(dataBalancerMetricsRegistry, "DataBalancerMetricsRegistry must be non-null");
        this.cruiseControl = cruiseControl;
        this.time = time;
        this.brokerRemovalFutures = new ConcurrentHashMap<ImmutableSet<Integer>, BrokerRemovalFuture>();
        this.brokerRemovalsStateTrackers = new ConcurrentHashMap<ImmutableSet<Integer>, BrokerRemovalStateTracker>();
        this.brokerAdditionsStateManagers = new ConcurrentHashMap<Integer, BrokerAdditionStateManager>();
    }

    public Optional<KafkaCruiseControl> getCruiseControl() {
        return Optional.ofNullable(this.cruiseControl);
    }

    public boolean isCruiseControlInitialized() {
        return this.cruiseControl != null;
    }

    public void setCruiseControl(KafkaCruiseControl cruiseControl) {
        this.cruiseControl = cruiseControl;
    }

    private void closeAndClearCruiseControl() {
        KafkaCruiseControlUtils.executeSilently(this.cruiseControl, KafkaCruiseControl::shutdown);
        this.cruiseControl = null;
    }

    public Time getTime() {
        return this.time;
    }

    public DataBalancerMetricsRegistry getDataBalancerMetricsRegistry() {
        return this.dataBalancerMetricsRegistry;
    }

    @Override
    public ApiStatePersistenceStore getPersistenceStore() {
        return this.persistenceStore;
    }

    @Override
    public Map<ImmutableSet<Integer>, BrokerRemovalStateTracker> getBrokerRemovalsStateTrackers() {
        return this.brokerRemovalsStateTrackers;
    }

    @Override
    public Map<Integer, BrokerAdditionStateManager> getBrokerAdditionsStateManagers() {
        return this.brokerAdditionsStateManagers;
    }

    @Override
    public void putBrokerStateManager(BrokerAdditionStateManager stateManager) {
        this.brokerAdditionsStateManagers.put(stateManager.brokerId(), stateManager);
    }

    @Override
    public BalancerStatusTracker getBalancerStatusTracker() {
        return this.balancerStatusTracker;
    }

    public void setBalancerStatusTracker(BalancerStatusTracker balancerStatusTracker) {
        this.balancerStatusTracker = balancerStatusTracker;
    }

    @Override
    public EvenClusterLoadStateManager getEvenClusterLoadStateManager() {
        return this.cruiseControl.context().evenClusterLoadStateManager();
    }

    @Override
    public Set<Integer> brokersBeingAdded() {
        return this.brokerAdditionsStateManagers.values().stream().filter(manager -> !manager.isAtATerminalState()).map(BrokerAdditionStateManager::brokerId).collect(Collectors.toSet());
    }

    public void setPersistenceStore(ApiStatePersistenceStore persistenceStore) {
        this.persistenceStore = persistenceStore;
    }

    public void putBrokerRemovalFuture(ImmutableSet<Integer> brokerIds, BrokerRemovalFuture future) {
        this.brokerRemovalFutures.put(brokerIds, future);
    }

    public void removeBrokerRemovalFuture(ImmutableSet<Integer> brokerIds) {
        this.brokerRemovalFutures.remove(brokerIds);
    }

    public BrokerRemovalFuture brokerRemovalFuture(ImmutableSet<Integer> brokerIds) {
        return this.brokerRemovalFutures.get(brokerIds);
    }

    private void closeAndClearPersistenceStore() {
        KafkaCruiseControlUtils.closeSilently(this.persistenceStore);
        this.persistenceStore = null;
    }

    public void closeAndClearState() {
        this.closeAndClearCruiseControl();
        this.closeAndClearPersistenceStore();
        this.dataBalancerMetricsRegistry.clearShortLivedMetrics();
    }
}

