/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer;

import com.linkedin.kafka.cruisecontrol.exception.OptimizationFailureException;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.Cell;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.Partition;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import io.confluent.databalancer.BrokersMetadataSnapshot;
import io.confluent.databalancer.GoalConstraints;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kafka.common.AliveBrokersMetadata;
import kafka.common.TenantHelpers;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import org.apache.kafka.common.PartitionPlacementStrategy;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.image.BrokerReplicaExclusionsImage;
import org.apache.kafka.image.ClusterImage;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class DatabalancerUtils {
    private static final String START_ANCHOR = "^";
    private static final String END_ANCHOR = "$";
    private static final String WILDCARD_SUFFIX = ".*";

    public static Integer getBrokerId(KafkaConfig config) {
        return config.getInt(KafkaConfig$.MODULE$.BrokerIdProp());
    }

    public static long taskHistoryRetentionMs(KafkaConfig config) {
        return TimeUnit.DAYS.toMillis(config.getInt("confluent.balancer.task.history.retention.days").intValue());
    }

    public static List<String> getConfiguredLogDirs(KafkaConfig config) {
        return JavaConverters.seqAsJavaList((Seq)config.logDirs());
    }

    public static boolean anyUnevenLoadEnabled(KafkaConfig kafkaConfig) {
        String autoHealMode = kafkaConfig.getString("confluent.balancer.heal.uneven.load.trigger");
        return DatabalancerUtils.anyUnevenLoadEnabled(autoHealMode);
    }

    public static boolean anyUnevenLoadEnabled(String autoHealMode) {
        return autoHealMode.equals(ConfluentConfigs.BalancerSelfHealMode.ANY_UNEVEN_LOAD.toString());
    }

    public static String generateCcTopicExclusionRegex(KafkaConfig config) {
        List topicNames = config.getList("confluent.balancer.exclude.topic.names");
        List topicPrefixes = config.getList("confluent.balancer.exclude.topic.prefixes");
        return DatabalancerUtils.generateCcTopicExclusionRegex(topicNames, topicPrefixes);
    }

    public static String generateCcTopicExclusionRegex(List<String> topicNames, List<String> topicPrefixes) {
        Stream<String> topicNameRegexStream = topicNames.stream().map(topic -> START_ANCHOR + Pattern.quote(topic) + END_ANCHOR);
        Stream<String> topicPrefixRegexStream = topicPrefixes.stream().map(prefix -> START_ANCHOR + Pattern.quote(prefix) + WILDCARD_SUFFIX);
        return Stream.concat(topicNameRegexStream, topicPrefixRegexStream).collect(Collectors.joining("|"));
    }

    public static AliveBrokersMetadata buildAliveBrokerMetadata(ClusterImage clusterImage, BrokerReplicaExclusionsImage exclusionsImage) {
        return BrokersMetadataSnapshot.of(clusterImage.brokers(), exclusionsImage.activeBrokerReplicaExclusions().keySet());
    }

    public static void ensureConstraintsAreMet(GoalConstraints goalConstraints, ClusterModel clusterModel, Set<String> excludedTopics) throws OptimizationFailureException {
        if (!clusterModel.isCellEnabled()) {
            return;
        }
        for (Map.Entry<String, List<Partition>> partitionsByTopic : clusterModel.getPartitionsByTopic().entrySet()) {
            if (excludedTopics.contains(partitionsByTopic.getKey()) || TenantHelpers.extractTenantPrefix((String)partitionsByTopic.getKey()) == null) continue;
            Optional<String> tenantId = goalConstraints.equals((Object)GoalConstraints.VERIFY_TENANTS) ? Optional.ofNullable(TenantHelpers.extractTenantPrefix((String)partitionsByTopic.getKey(), (boolean)false)) : Optional.empty();
            Optional expectedCell = tenantId.flatMap(tId -> DatabalancerUtils.expectedCellForTenant(clusterModel, tId));
            for (Partition partition : partitionsByTopic.getValue()) {
                Set<Cell> cells = partition.partitionBrokers().stream().map(Broker::cell).collect(Collectors.toSet());
                switch (goalConstraints) {
                    case VERIFY_CELL: {
                        DatabalancerUtils.verifyCellsConstraint(cells, partition);
                        break;
                    }
                    case VERIFY_TENANTS: {
                        if (!expectedCell.isPresent() || !tenantId.isPresent()) break;
                        DatabalancerUtils.verifyTenantConstraint(cells, (Cell)expectedCell.get(), partition, (String)tenantId.get());
                        break;
                    }
                }
            }
        }
    }

    private static void verifyCellsConstraint(Set<Cell> cells, Partition partition) throws OptimizationFailureException {
        if (cells.size() > 1) {
            throw new OptimizationFailureException(String.format("Partition %d of topic %s has replicas in more than one cells: %s", partition.topicPartition().partition(), partition.topicPartition().topic(), cells));
        }
    }

    private static void verifyTenantConstraint(Set<Cell> cells, Cell expectedCell, Partition partition, String tenantId) throws OptimizationFailureException {
        if (cells.size() > 1 || !partition.leader().broker().cell().equals(expectedCell)) {
            throw new OptimizationFailureException(String.format("Partition %d of topic %s of tenant %s has replicas in multiple cells or situated in incorrect cell %s", partition.topicPartition().partition(), partition.topicPartition().topic(), tenantId, cells));
        }
    }

    public static String getTenantId(Replica replica) {
        Objects.requireNonNull(replica);
        return TenantHelpers.extractTenantPrefix((String)replica.topicPartition().topic(), (boolean)false);
    }

    public static Optional<Cell> expectedCellForTenant(ClusterModel clusterModel, String tenantId) {
        return clusterModel.tenant(tenantId).map(t -> {
            if (t.placementPolicy() == PartitionPlacementStrategy.TENANT_IN_CELL) {
                return t.cell();
            }
            return null;
        });
    }
}

