/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.event;

import io.confluent.databalancer.DatabalancerUtils;
import io.confluent.databalancer.SbcContext;
import io.confluent.databalancer.event.SbcAbstractBrokerAdditionEvent;
import io.confluent.databalancer.event.SbcEvent;
import io.confluent.databalancer.event.resource.SbcResources;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import kafka.common.AliveBrokersMetadata;
import org.apache.kafka.image.BrokerReplicaExclusionsImage;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.PartitionRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SbcKraftBrokerAdditionEvent
extends SbcAbstractBrokerAdditionEvent {
    protected static final Logger LOG = LoggerFactory.getLogger(SbcKraftBrokerAdditionEvent.class);
    private final Set<Integer> newBrokers;

    public SbcKraftBrokerAdditionEvent(SbcContext context, Set<Integer> newBrokers) {
        super(context);
        this.newBrokers = newBrokers;
    }

    @Override
    protected SbcEvent.SbcEventHandlerResult handleEvent() {
        Optional<ClusterImage> clusterImage = this.eventContext.resourceManager().maybeGetResourceValue(SbcResources.CLUSTER_IMAGE);
        if (!clusterImage.isPresent()) {
            LOG.info("Cluster Image not present, pausing broker addition event of brokers (new brokers: {}) until it is received.", this.newBrokers);
            return SbcEvent.SbcEventHandlerResult.needsResource(SbcResources.CLUSTER_IMAGE);
        }
        Optional<BrokerReplicaExclusionsImage> exclusionsImage = this.eventContext.resourceManager().maybeGetResourceValue(SbcResources.EXCLUSIONS_IMAGE);
        if (!exclusionsImage.isPresent()) {
            LOG.info("Exclusions Image not present, pausing broker addition event of brokers (new brokers: {}) until it is received.", this.newBrokers);
            return SbcEvent.SbcEventHandlerResult.needsResource(SbcResources.EXCLUSIONS_IMAGE);
        }
        Optional<TopicsImage> topicsImageOpt = this.eventContext.resourceManager().maybeGetResourceValue(SbcResources.TOPICS_IMAGE);
        if (!topicsImageOpt.isPresent()) {
            LOG.info("Topics Image not present, pausing broker addition event of brokers (new brokers: {}) until it is received.", this.newBrokers);
            return SbcEvent.SbcEventHandlerResult.needsResource(SbcResources.TOPICS_IMAGE);
        }
        TopicsImage topicsImage = topicsImageOpt.get();
        Set<Integer> emptyBrokers = this.findEmptyBrokers(topicsImage, this.newBrokers);
        AliveBrokersMetadata aliveBrokersMetadata = DatabalancerUtils.buildAliveBrokerMetadata(clusterImage.get(), exclusionsImage.get());
        this.notifyBrokerStartup(aliveBrokersMetadata, emptyBrokers, this.newBrokers);
        return SbcEvent.SbcEventHandlerResult.SUCCESS;
    }

    private Set<Integer> findEmptyBrokers(TopicsImage topicsImage, Set<Integer> newBrokers) {
        HashSet<Integer> brokersWithReplicas = new HashSet<Integer>();
        for (TopicImage image : topicsImage.topicsByName().values()) {
            if (brokersWithReplicas.size() == this.newBrokers.size()) break;
            for (PartitionRegistration partitionReg : image.partitions().values()) {
                for (int replica : partitionReg.replicas) {
                    if (!newBrokers.contains(replica)) continue;
                    brokersWithReplicas.add(replica);
                }
            }
        }
        HashSet<Integer> emptyBrokers = new HashSet<Integer>(newBrokers);
        emptyBrokers.removeAll(brokersWithReplicas);
        return emptyBrokers;
    }
}

