/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.event;

import io.confluent.databalancer.DataBalanceEngine;
import io.confluent.databalancer.SbcContext;
import io.confluent.databalancer.event.SbcEvent;
import io.confluent.databalancer.operation.BrokerAdditionStateMachine;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kafka.common.BrokerAdditionDescriptionInternal;
import kafka.controller.ClusterBalanceManager;
import org.apache.kafka.common.errors.BalancerOfflineException;
import org.apache.kafka.common.requests.ApiError;
import org.slf4j.event.Level;

public class SbcListBrokerAdditionsEvent
extends SbcEvent {
    private ClusterBalanceManager.BalanceManagerStatusQueryClientCallback<List<BrokerAdditionDescriptionInternal>> cb;

    public SbcListBrokerAdditionsEvent(SbcContext context, ClusterBalanceManager.BalanceManagerStatusQueryClientCallback<List<BrokerAdditionDescriptionInternal>> cb) {
        super(context);
        this.cb = cb;
    }

    @Override
    protected Level logLevel() {
        return Level.DEBUG;
    }

    @Override
    protected SbcEvent.SbcEventHandlerResult handleEvent() {
        DataBalanceEngine balanceEngine = this.eventContext.kafkaDataBalanceManager().getBalanceEngine();
        if (!balanceEngine.isActive()) {
            String msg = "Received request to describe broker additions while Databalancer is not started.";
            LOG.error(msg);
            throw new BalancerOfflineException(msg);
        }
        long now = this.eventContext.time().milliseconds();
        long historyCutOffTimeMs = now - this.eventContext.taskHistoryRetentionMs();
        List<BrokerAdditionDescriptionInternal> additions = balanceEngine.getDataBalanceEngineContext().getBrokerAdditionsStateManagers().values().stream().filter(stateManager -> stateManager.lastUpdateTimeMs() > historyCutOffTimeMs).map(brokerAdditionStateManager -> new BrokerAdditionDescriptionInternal(brokerAdditionStateManager.brokerId(), brokerAdditionStateManager.currentState().status(), BrokerAdditionStateMachine.convertBrokerAdditionStatus(brokerAdditionStateManager.currentState().status()), brokerAdditionStateManager.creationTimeMs(), brokerAdditionStateManager.lastUpdateTimeMs(), (Exception)brokerAdditionStateManager.exception().orElse(null))).collect(Collectors.toList());
        return new SbcListBrokerAdditionsEventResult(additions);
    }

    @Override
    public void respondToClient(ApiError error, SbcEvent.SbcEventHandlerResult result) {
        Optional<Object> brokerAdditionsOpt = Optional.ofNullable(result instanceof SbcListBrokerAdditionsEventResult ? ((SbcListBrokerAdditionsEventResult)result).brokerAdditions : null);
        this.cb.respond(error, brokerAdditionsOpt);
    }

    protected static class SbcListBrokerAdditionsEventResult
    extends SbcEvent.SbcEventHandlerResult {
        public final List<BrokerAdditionDescriptionInternal> brokerAdditions;

        public SbcListBrokerAdditionsEventResult(List<BrokerAdditionDescriptionInternal> additions) {
            this.brokerAdditions = additions;
        }
    }
}

