/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Timer;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.kafka.common.utils.Sanitizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DataBalancerMetricsRegistry {
    public static final String ACTIVE_BALANCER_COUNT_METRIC_NAME = "ActiveBalancerCount";
    public static final Set<String> LONG_LIVED_METRICS_WHITE_LIST = Collections.singleton("ActiveBalancerCount");
    private static final Logger LOG = LoggerFactory.getLogger(DataBalancerMetricsRegistry.class);
    private static final String GROUP = "kafka.databalancer";
    private final Set<String> longLivedMetricsWhiteList;
    private final MetricsRegistry metricsRegistry;
    private final Set<MetricName> longLivedMetrics;
    private final Set<MetricName> shortLivedMetrics;

    public DataBalancerMetricsRegistry(MetricsRegistry metricsRegistry) {
        this(metricsRegistry, LONG_LIVED_METRICS_WHITE_LIST);
    }

    public DataBalancerMetricsRegistry(MetricsRegistry metricsRegistry, Set<String> longLivedMetricsAllowlist) {
        this.metricsRegistry = metricsRegistry;
        this.longLivedMetricsWhiteList = longLivedMetricsAllowlist;
        this.shortLivedMetrics = new HashSet<MetricName>();
        this.longLivedMetrics = new HashSet<MetricName>();
    }

    public synchronized Histogram newHistogram(Class<?> klass, String name) {
        return this.newHistogram(klass, name, true, true, Collections.emptyMap());
    }

    private Histogram newHistogram(Class<?> klass, String name, boolean biasedTowardsNewerRecords, boolean isShortLivedMetric, Map<String, String> tags) {
        MetricName metricName = DataBalancerMetricsRegistry.metricName(GROUP, klass.getSimpleName(), name, tags);
        this.registerMetric(metricName, isShortLivedMetric);
        return this.metricsRegistry.newHistogram(metricName, biasedTowardsNewerRecords);
    }

    public synchronized <T> Gauge<T> newGauge(Class<?> klass, String name, Supplier<T> valueSupplier) {
        return this.newGauge(klass, name, valueSupplier, true);
    }

    public synchronized <T> Gauge<T> newGauge(Class<?> klass, String name, Supplier<T> valueSupplier, Map<String, String> tags) {
        return this.newGauge(klass, name, valueSupplier, true, tags);
    }

    public synchronized <T> Gauge<T> newGauge(Class<?> klass, String name, Supplier<T> valueSupplier, boolean isShortLivedMetric) {
        return this.newGauge(klass, name, valueSupplier, isShortLivedMetric, Collections.emptyMap());
    }

    public synchronized <T> Gauge<T> newGauge(Class<?> klass, String name, final Supplier<T> valueSupplier, boolean isShortLivedMetric, Map<String, String> tags) {
        MetricName metricName = DataBalancerMetricsRegistry.metricName(GROUP, klass.getSimpleName(), name, tags);
        this.registerMetric(metricName, isShortLivedMetric);
        return this.metricsRegistry.newGauge(metricName, new Gauge<T>(){

            public T value() {
                return valueSupplier.get();
            }
        });
    }

    public synchronized Timer newTimer(Class<?> klass, String name) {
        MetricName metricName = DataBalancerMetricsRegistry.metricName(GROUP, klass.getSimpleName(), name);
        this.registerMetric(metricName, true);
        return this.metricsRegistry.newTimer(metricName, TimeUnit.MILLISECONDS, TimeUnit.SECONDS);
    }

    public synchronized Meter newMeter(Class<?> klass, String name, String eventType, TimeUnit timeUnit) {
        MetricName metricName = DataBalancerMetricsRegistry.metricName(GROUP, klass.getSimpleName(), name);
        this.registerMetric(metricName, true);
        return this.metricsRegistry.newMeter(metricName, eventType, timeUnit);
    }

    public synchronized Meter newMeter(Class<?> klass, String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        MetricName metricName = DataBalancerMetricsRegistry.metricName(GROUP, klass.getSimpleName(), name, tags);
        this.registerMetric(metricName, true);
        return this.metricsRegistry.newMeter(metricName, eventType, timeUnit);
    }

    public synchronized void clearShortLivedMetric(Class<?> klass, String name, Map<String, String> tags) {
        MetricName metricName = DataBalancerMetricsRegistry.metricName(GROUP, klass.getSimpleName(), name, tags);
        LOG.debug("Attempting to clear short-lived metric {}", (Object)metricName);
        if (this.shortLivedMetrics.contains(metricName)) {
            this.metricsRegistry.removeMetric(metricName);
            this.shortLivedMetrics.remove(metricName);
        }
    }

    public synchronized void clearShortLivedMetrics() {
        LOG.debug("Attempting to clear metrics registry of metrics: {}. Will not clear metrics: {}", this.shortLivedMetrics, this.longLivedMetrics);
        this.shortLivedMetrics.forEach(arg_0 -> ((MetricsRegistry)this.metricsRegistry).removeMetric(arg_0));
        this.shortLivedMetrics.clear();
    }

    public synchronized void clearLongLivedMetric(Class<?> klass, String name) {
        MetricName metricName = DataBalancerMetricsRegistry.metricName(GROUP, klass.getSimpleName(), name, Collections.emptyMap());
        LOG.debug("Attempting to clear long-lived metric {}", (Object)metricName);
        if (!this.longLivedMetricsWhiteList.contains(name)) {
            throw new IllegalStateException(String.format("Attempting to remove metric %s from long-lived metrics, when it's not on the approved list.", name));
        }
        this.metricsRegistry.removeMetric(metricName);
        this.longLivedMetrics.remove(metricName);
    }

    private void registerMetric(MetricName metricName, boolean isShortLivedMetric) {
        Set<MetricName> addedElsewhereMetrics;
        boolean allowMetric;
        Set<MetricName> addedMetrics;
        Set<MetricName> set = addedMetrics = isShortLivedMetric ? this.shortLivedMetrics : this.longLivedMetrics;
        if (addedMetrics.contains(metricName)) {
            LOG.warn("Adding metric {} a second time is a no-op, ignoring", (Object)metricName);
            return;
        }
        boolean bl = allowMetric = isShortLivedMetric || this.longLivedMetricsWhiteList.contains(metricName.getName());
        if (!allowMetric) {
            throw new IllegalStateException("Attempt to add non-allow-listed databalancer metric to DataBalancerMetricsRegistry");
        }
        Set<MetricName> set2 = addedElsewhereMetrics = isShortLivedMetric ? this.longLivedMetrics : this.shortLivedMetrics;
        if (addedElsewhereMetrics.contains(metricName)) {
            throw new IllegalStateException(String.format("Attempt to add databalancer metric metric %s with different lifespan than current", metricName));
        }
        if (this.metricsRegistry.allMetrics().containsKey(metricName)) {
            LOG.warn("Adding metric {} a second time is a no-op, ignoring", (Object)metricName);
            return;
        }
        addedMetrics.add(metricName);
    }

    synchronized boolean containsShortLivedMetric(MetricName name) {
        return this.shortLivedMetrics.contains(name);
    }

    synchronized boolean containsLongLivedMetric(MetricName name) {
        return this.longLivedMetrics.contains(name);
    }

    static MetricName metricName(String group, String type, String name) {
        return DataBalancerMetricsRegistry.metricName(group, type, name, Collections.emptyMap());
    }

    static MetricName metricName(String group, String type, String name, Map<String, String> tags) {
        String mbeanName = String.format("%s:type=%s,name=%s", group, type, name);
        String tagsName = DataBalancerMetricsRegistry.tagsToMBeanName(tags);
        if (!tagsName.isEmpty()) {
            mbeanName = mbeanName + "," + tagsName;
        }
        return new MetricName(group, type, name, null, mbeanName);
    }

    private static String tagsToMBeanName(Map<String, String> tags) {
        List tagsList = tags.entrySet().stream().filter(x -> x.getValue() != null && !((String)x.getValue()).equals("")).map(kv -> String.format("%s=%s", kv.getKey(), Sanitizer.jmxSanitize((String)((String)kv.getValue())))).collect(Collectors.toList());
        return String.join((CharSequence)",", tagsList);
    }
}

