/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.operation;

import com.linkedin.kafka.cruisecontrol.operation.BalancerStatusCallback;
import io.confluent.databalancer.operation.BalancerStatusStateMachine;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class BalancerStatusTracker
implements BalancerStatusCallback {
    private static final Logger LOG = LoggerFactory.getLogger(BalancerStatusTracker.class);
    private final int brokerId;
    private final BalancerStatusStateMachine stateMachine;
    private final AtomicReference<Attributes> balancerStatusAttributes;
    private final AtomicReference<String> stateMetricReference;
    private volatile boolean initialized;

    public BalancerStatusTracker(int brokerId, AtomicReference<String> stateMetricReference, Time time) {
        this(brokerId, new BalancerStatusStateMachine(brokerId, time), stateMetricReference);
    }

    BalancerStatusTracker(int brokerId, BalancerStatusStateMachine stateMachine, AtomicReference<String> stateMetricReference) {
        this.brokerId = brokerId;
        this.stateMachine = stateMachine;
        this.stateMetricReference = stateMetricReference;
        this.balancerStatusAttributes = new AtomicReference<Attributes>(new Attributes((BalancerStatusStateMachine.BalancerState)stateMachine.currentState, null));
    }

    public void initialize() {
        if (this.isInitialized()) {
            throw new IllegalStateException("The balancer status state tracker was already initialized.");
        }
        this.balancerStatusAttributes.set(new Attributes((BalancerStatusStateMachine.BalancerState)this.stateMachine.currentState, null));
        this.stateMetricReference.set(((BalancerStatusStateMachine.BalancerState)this.stateMachine.currentState).name());
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isDisabled() {
        return BalancerStatusStateMachine.BalancerState.DISABLED.equals(this.currentState());
    }

    @Override
    public BalancerStatusStateMachine.BalancerState currentState() {
        return this.balancerStatusAttributes.get().state();
    }

    public int brokerId() {
        return this.brokerId;
    }

    public Optional<Exception> exception() {
        return Optional.ofNullable(this.balancerStatusAttributes.get().exception());
    }

    @Override
    public synchronized void registerEvent(BalancerStatusStateMachine.BalancerEvent event) {
        this.registerEvent(event, (Exception)null);
    }

    public synchronized void registerEnabledEventIfDisabled() {
        if (this.isDisabled()) {
            this.registerEvent(BalancerStatusStateMachine.BalancerEvent.BALANCER_ENABLED, (Exception)null);
        }
    }

    @Override
    public synchronized void registerEvent(BalancerStatusStateMachine.BalancerEvent event, Exception e) {
        this.processEvent(event, e);
    }

    private void processEvent(BalancerStatusStateMachine.BalancerEvent event, Exception eventException) {
        BalancerStatusStateMachine.BalancerState newState;
        if (!this.isInitialized()) {
            throw new IllegalStateException("Cannot process a balancer status event because state manager is not initialized.");
        }
        try {
            newState = (BalancerStatusStateMachine.BalancerState)this.stateMachine.advanceState(event);
        }
        catch (Exception exception) {
            if (eventException != null) {
                LOG.error("Unexpected exception while handling balancer status event {}. Event exception: {}", new Object[]{event, eventException, exception});
            } else {
                LOG.error("Unexpected exception while handling balancer status event {}.", (Object)event, (Object)exception);
            }
            throw exception;
        }
        this.balancerStatusAttributes.set(new Attributes(newState, eventException));
        this.stateMetricReference.set(newState.name());
    }

    @Immutable
    private static class Attributes {
        private final BalancerStatusStateMachine.BalancerState state;
        private final Exception exception;

        public Attributes(BalancerStatusStateMachine.BalancerState state, Exception exception) {
            this.state = state;
            this.exception = exception;
        }

        BalancerStatusStateMachine.BalancerState state() {
            return this.state;
        }

        Exception exception() {
            return this.exception;
        }
    }
}

