/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.operation;

import io.confluent.databalancer.operation.BalancerOperationEvent;
import io.confluent.databalancer.operation.BalancerOperationState;
import io.confluent.databalancer.operation.StateTransitioner;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class StateMachine<S extends BalancerOperationState, E extends BalancerOperationEvent> {
    private static final Logger log = LoggerFactory.getLogger(StateMachine.class);
    private final Set<Integer> brokerIds;
    private final String name;
    private final Time time;
    protected volatile S currentState;
    private volatile long lastUpdateTimeMs;
    private volatile long createTime;

    public StateMachine(int brokerId, String name, S startState, Time time) {
        this(brokerId, name, startState, time.milliseconds(), time.milliseconds(), time);
    }

    public StateMachine(int brokerId, String name, S startState, long createTimeMs, long lastUpdateTimeMs, Time time) {
        this(Collections.singleton(brokerId), name, startState, createTimeMs, lastUpdateTimeMs, time);
    }

    protected StateMachine(Set<Integer> brokerIds, String name, S startState, Time time) {
        this.brokerIds = brokerIds;
        this.name = name;
        this.currentState = startState;
        this.time = time;
        this.lastUpdateTimeMs = this.createTime = time.milliseconds();
    }

    StateMachine(Set<Integer> brokerIds, String name, S startState, long createTime, long lastUpdateTimeMs, Time time) {
        this.brokerIds = brokerIds;
        this.name = name;
        this.currentState = startState;
        this.time = time;
        this.createTime = createTime;
        this.lastUpdateTimeMs = lastUpdateTimeMs;
    }

    abstract StateTransitioner<S, E> transitioner();

    public boolean isTerminalState(S state) {
        return state.isTerminal();
    }

    public long createTime() {
        return this.createTime;
    }

    public long lastUpdateTime() {
        return this.lastUpdateTimeMs;
    }

    public synchronized S advanceState(E event) {
        if (this.isTerminalState(this.currentState)) {
            throw new IllegalStateException(String.format("Cannot advance the state as %s is a terminal state", this.currentState.name()));
        }
        Optional<S> nextState = this.transitioner().transition(this.currentState, event);
        if (!nextState.isPresent()) {
            throw new IllegalStateException(String.format("Cannot handle a %s %s event when in state %s", event, this.name, this.currentState.name()));
        }
        log.info("{} state for brokers {} transitioned from {} to {} due to event {}.", new Object[]{this.name, this.brokerIds, this.currentState, nextState.get(), event});
        this.currentState = (BalancerOperationState)nextState.get();
        this.lastUpdateTimeMs = this.time.milliseconds();
        return this.currentState;
    }
}

