/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.persistence;

import io.confluent.databalancer.operation.BrokerRemovalStateMachine;
import io.confluent.databalancer.persistence.ApiStatePersistenceStore;
import io.confluent.databalancer.persistence.BrokerRemovalStateRecord;
import io.confluent.databalancer.persistence.BrokerRemovalStateSerializer;
import io.confluent.databalancer.record.RemoveBroker;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerRemovalStateRecordProtoSerde {
    private static final Logger LOG = LoggerFactory.getLogger(ApiStatePersistenceStore.class);
    private static final int BROKER_REMOVAL_STATE_RECORD_VERSION_CURRENT = RemoveBroker.RemovalRecordVersion.remove_version_2.getNumber();
    private static final List<VersionMapping> VERSION_MAPPINGS = Arrays.asList(new VersionMapping(RemoveBroker.RemovalRecordVersion.remove_version_1.getNumber(), BrokerRemovalStateRecordProtoSerde::readFromV1Record), new VersionMapping(RemoveBroker.RemovalRecordVersion.remove_version_2.getNumber(), BrokerRemovalStateRecordProtoSerde::readFromV2Record));
    private static final Map<Integer, BrokerRemovalVersionConverter> VERSION_CONVERTERS;

    public static RemoveBroker.BrokerRemovalStateRecordProto serialize(BrokerRemovalStateRecord currentStateRecord, boolean isNew) {
        String error = "";
        if (currentStateRecord.exception() != null) {
            error = ApiStatePersistenceStore.serializeException(currentStateRecord.exception());
        }
        if (currentStateRecord.state() == BrokerRemovalStateMachine.BrokerRemovalState.CANCELED) {
            throw new IllegalStateException(String.format("Attempting to save a removal record in CANCELED state: %s", currentStateRecord));
        }
        long now = System.currentTimeMillis();
        RemoveBroker.BrokerRemovalStateRecordProto.Builder removeBrokerProtoBuilder = RemoveBroker.BrokerRemovalStateRecordProto.newBuilder().setVersion(BROKER_REMOVAL_STATE_RECORD_VERSION_CURRENT).addAllBrokerIds(currentStateRecord.brokerIds()).setError(error).setShouldShutDown(currentStateRecord.shouldShutdown()).setRemovalState(BrokerRemovalStateSerializer.serialize(currentStateRecord.state())).setLastUpdateTime(now);
        if (isNew) {
            if (currentStateRecord.startTime() > 0L) {
                LOG.error("Start time already set for a new Broker removal status: {}", (Object)currentStateRecord.startTime(), (Object)new RuntimeException());
            }
            removeBrokerProtoBuilder.setStartTime(now);
        } else {
            if (currentStateRecord.startTime() == 0L) {
                LOG.error("Start time should be set for an existing Broker removal status. Broker ids: {}", currentStateRecord.brokerIds(), (Object)new RuntimeException());
            }
            removeBrokerProtoBuilder.setStartTime(currentStateRecord.startTime());
        }
        return removeBrokerProtoBuilder.build();
    }

    public static BrokerRemovalStateRecord deserialize(RemoveBroker.BrokerRemovalStateRecordProto persistedRecord) {
        BrokerRemovalVersionConverter converter = VERSION_CONVERTERS.getOrDefault(persistedRecord.getVersion(), null);
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Invalid broker removal record version %d detected, ignoring (%s)", persistedRecord.getVersion(), persistedRecord));
        }
        return converter.convertRecordVersion(persistedRecord);
    }

    private static BrokerRemovalStateRecord readFromV1Record(RemoveBroker.BrokerRemovalStateRecordProto persistedRecord) {
        if (persistedRecord.getBrokerIdsCount() > 0) {
            throw new IllegalStateException(String.format("Malformed REMOVE_BROKER record: Did not expect multiple broker IDs (found %d)", persistedRecord.getBrokerIdsCount()));
        }
        boolean shouldShutdown = true;
        BrokerRemovalStateMachine.BrokerRemovalState savedState = BrokerRemovalStateSerializer.deserialize(persistedRecord.getRemovalState());
        if (!savedState.isTerminal()) {
            LOG.info("Loaded active V1 broker removal: marking this operation as CANCELED: (brokerID: {}, state: {})", (Object)persistedRecord.getBrokerId(), (Object)savedState);
            savedState = BrokerRemovalStateMachine.BrokerRemovalState.CANCELED;
        }
        return BrokerRemovalStateRecordProtoSerde.instantiateBrokerRemovalStateRecord(persistedRecord, Collections.singleton(persistedRecord.getBrokerId()), savedState, shouldShutdown);
    }

    private static BrokerRemovalStateRecord readFromV2Record(RemoveBroker.BrokerRemovalStateRecordProto persistedRecord) {
        if (persistedRecord.getBrokerIdsCount() == 0 || persistedRecord.getBrokerId() != 0) {
            throw new IllegalStateException(String.format("Malformed REMOVE_BROKER_V2 record: no broker IDs (%s) / unexpected single broker ID (%d)", persistedRecord.getBrokerIdsList(), persistedRecord.getBrokerId()));
        }
        return BrokerRemovalStateRecordProtoSerde.instantiateBrokerRemovalStateRecord(persistedRecord, new HashSet<Integer>(persistedRecord.getBrokerIdsList()), BrokerRemovalStateSerializer.deserialize(persistedRecord.getRemovalState()), persistedRecord.getShouldShutDown());
    }

    private static BrokerRemovalStateRecord instantiateBrokerRemovalStateRecord(RemoveBroker.BrokerRemovalStateRecordProto persistedRecord, Set<Integer> brokerIds, BrokerRemovalStateMachine.BrokerRemovalState savedState, boolean shutdownScheduled) {
        Exception ex = null;
        String serializedException = persistedRecord.getError();
        if (!serializedException.isEmpty()) {
            ex = ApiStatePersistenceStore.deserializeException(serializedException);
        }
        BrokerRemovalStateRecord stateRecord = new BrokerRemovalStateRecord(brokerIds, savedState, ex, shutdownScheduled);
        stateRecord.setStartTime(persistedRecord.getStartTime());
        stateRecord.setLastUpdateTime(persistedRecord.getLastUpdateTime());
        return stateRecord;
    }

    static {
        HashMap<Integer, BrokerRemovalVersionConverter> conversions = new HashMap<Integer, BrokerRemovalVersionConverter>();
        for (VersionMapping mapping : VERSION_MAPPINGS) {
            conversions.put(mapping.version, mapping.versionAdapter);
        }
        VERSION_CONVERTERS = Collections.unmodifiableMap(conversions);
    }

    private static class VersionMapping {
        private final int version;
        private BrokerRemovalVersionConverter versionAdapter;

        public VersionMapping(int version, BrokerRemovalVersionConverter versionAdapter) {
            this.version = version;
            this.versionAdapter = versionAdapter;
        }
    }

    private static interface BrokerRemovalVersionConverter {
        public BrokerRemovalStateRecord convertRecordVersion(RemoveBroker.BrokerRemovalStateRecordProto var1);
    }
}

