/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.persistence;

import io.confluent.databalancer.operation.EvenClusterLoadStateMachine;
import io.confluent.databalancer.record.EvenClusterLoad;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EvenClusterLoadStateSerializer {
    private static List<Mapping> stateMappings = Arrays.asList(new Mapping(EvenClusterLoadStateMachine.EvenClusterLoadState.INITIALIZING, EvenClusterLoad.EvenClusterLoadState.initializing), new Mapping(EvenClusterLoadStateMachine.EvenClusterLoadState.BALANCING, EvenClusterLoad.EvenClusterLoadState.balancing), new Mapping(EvenClusterLoadStateMachine.EvenClusterLoadState.BALANCED, EvenClusterLoad.EvenClusterLoadState.balanced), new Mapping(EvenClusterLoadStateMachine.EvenClusterLoadState.BALANCING_FAILED, EvenClusterLoad.EvenClusterLoadState.balancing_failed), new Mapping(EvenClusterLoadStateMachine.EvenClusterLoadState.ABORTED, EvenClusterLoad.EvenClusterLoadState.aborted));
    private static Map<EvenClusterLoadStateMachine.EvenClusterLoadState, Mapping> stateToMappings = new HashMap<EvenClusterLoadStateMachine.EvenClusterLoadState, Mapping>();
    private static Map<EvenClusterLoad.EvenClusterLoadState, Mapping> persistedStateToMappings = new HashMap<EvenClusterLoad.EvenClusterLoadState, Mapping>();

    public static EvenClusterLoad.EvenClusterLoadState serialize(EvenClusterLoadStateMachine.EvenClusterLoadState state) {
        if (state == null) {
            return EvenClusterLoad.EvenClusterLoadState.none;
        }
        if (!stateToMappings.containsKey(state)) {
            throw new IllegalArgumentException(String.format("Cannot serialize state %s as it is not recognized", state));
        }
        return stateToMappings.get(state).persistedState;
    }

    public static EvenClusterLoadStateMachine.EvenClusterLoadState deserialize(EvenClusterLoad.EvenClusterLoadState persistedState) {
        if (persistedState == EvenClusterLoad.EvenClusterLoadState.none) {
            return null;
        }
        if (!persistedStateToMappings.containsKey(persistedState)) {
            throw new IllegalArgumentException(String.format("Cannot deserialize persisted state %s as it is not recognized", persistedState));
        }
        return persistedStateToMappings.get(persistedState).state;
    }

    static {
        for (Mapping mapping : stateMappings) {
            stateToMappings.put(mapping.state, mapping);
            persistedStateToMappings.put(mapping.persistedState, mapping);
        }
        persistedStateToMappings = Collections.unmodifiableMap(persistedStateToMappings);
        stateToMappings = Collections.unmodifiableMap(stateToMappings);
    }

    private static class Mapping {
        private final EvenClusterLoadStateMachine.EvenClusterLoadState state;
        private final EvenClusterLoad.EvenClusterLoadState persistedState;

        private Mapping(EvenClusterLoadStateMachine.EvenClusterLoadState state, EvenClusterLoad.EvenClusterLoadState persistedState) {
            this.state = state;
            this.persistedState = persistedState;
        }
    }
}

