/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.utils;

import io.confluent.databalancer.startup.StartupCheckInterruptedException;
import io.confluent.databalancer.utils.RetryableOperation;
import io.confluent.databalancer.utils.RetryableResult;
import java.time.Duration;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationRetryer<T> {
    private final Time time;
    private final Duration maxRetryDuration;
    private final Duration retryWaitDuration;
    private final String operationDescription;
    private static final Logger LOG = LoggerFactory.getLogger(OperationRetryer.class);

    public OperationRetryer(Time time, Duration maxRetryDuration, Duration retryWaitDuration, String operationDescription) {
        this.time = time;
        this.maxRetryDuration = maxRetryDuration;
        this.retryWaitDuration = retryWaitDuration;
        this.operationDescription = operationDescription;
    }

    public T runWithRetries(RetryableOperation<T> operation) throws InterruptedException, StartupCheckInterruptedException, TimeoutException {
        long currentTimeNs = this.time.nanoseconds();
        long endTimeNs = currentTimeNs + this.maxRetryDuration.toNanos();
        int retryCount = -1;
        LOG.debug("Running operation {} for a max retry duration of {}", (Object)this.operationDescription, (Object)this.maxRetryDuration);
        do {
            ++retryCount;
            try {
                RetryableResult<T> retryableResult = operation.run();
                if (retryableResult.shouldStop()) {
                    return null;
                }
                if (!retryableResult.shouldRetry()) {
                    return retryableResult.get();
                }
            }
            catch (StartupCheckInterruptedException | InterruptedException interruptedException) {
                LOG.error("Interrupted while performing operation {} (retry count {})", (Object)this.operationDescription, (Object)retryCount);
                throw interruptedException;
            }
            catch (RuntimeException re) {
                LOG.warn("Caught an unexpected exception while performing operation {} (retry count {}). Will not be retrying the operation. The exception was:", new Object[]{this.operationDescription, retryCount, re});
                throw re;
            }
            catch (Exception e) {
                LOG.warn("Caught an unexpected exception while performing operation {} (retry count {}). Will not be retrying the operation. The exception was:", new Object[]{this.operationDescription, retryCount, e});
                throw new RuntimeException(e);
            }
            if (this.isExpired(endTimeNs)) continue;
            if (this.isExpired(endTimeNs + this.retryWaitDuration.toNanos())) break;
            LOG.info("Will be retrying operation {} in {} ms", (Object)this.operationDescription, (Object)this.retryWaitDuration.toMillis());
            this.time.sleep(this.retryWaitDuration.toMillis());
        } while (!this.isExpired(endTimeNs));
        throw new TimeoutException(String.format("Failed to complete operation %s after %d retries for a total duration of %d ms.", this.operationDescription, retryCount, this.maxRetryDuration.toMillis()));
    }

    private boolean isExpired(long endTimeNs) {
        return this.time.nanoseconds() >= endTimeNs;
    }
}

