/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hub.cli.commands;

import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.annotations.restrictions.Once;
import io.confluent.connect.hub.cli.ExitCode;
import io.confluent.connect.hub.exceptions.ConfluentHubClientException;
import io.confluent.connect.hub.utils.IOUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;

public abstract class BaseCommand
implements Callable {
    private static final String COMPLETED_MSG = "Completed";
    private static final String ERROR_FORMAT_MSG = "Error: %s";
    @Once
    @Option(name={"--verbose"}, description="More detailed output of a command.")
    protected boolean verbose = false;
    @Once
    @Option(name={"--no-prompt"}, description="Do not ask for user input, proceed with default and recommended values.")
    protected boolean noPrompt = false;
    @Once
    @Option(name={"--dry-run"}, description="Simulate an operation without making any changes, but instead simply reporting all of the steps and changes that would normally be made by the operation.")
    protected boolean dryRun = false;
    @Once
    @Option(name={"--worker-configs"}, description="Paths to one or more Connect Worker configuration files whose plugin path may be updated to include the newly installed component. Delimit multiple paths with a colon (:).")
    protected String workerConfigs;

    public List<String> getWorkerConfigs() {
        if (this.workerConfigs == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(this.workerConfigs, ":");
        ArrayList<String> workerConfigs = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            workerConfigs.add(tokenizer.nextToken());
        }
        return workerConfigs;
    }

    /*
     * Loose catch block
     */
    public final ExitCode call() {
        ExitCode exitCode = ExitCode.SUCCESSFUL_COMPLETION;
        IOUtils.setupLogger(this.verbose);
        try {
            if (this.verbose) {
                IOUtils.info("Running in a verbose mode", new Object[0]);
            }
            if (this.dryRun) {
                IOUtils.info("Doing a dry run of a command", new Object[0]);
            }
            if (this.noPrompt) {
                IOUtils.info("Running in a \"--no-prompt\" mode", new Object[0]);
            }
            exitCode = this.doCall();
        }
        catch (ConfluentHubClientException e) {
            IOUtils.error(e.getMessage(), new Object[0]);
            if (e.getCause() != null) {
                IOUtils.error(e.getCause().getMessage(), new Object[0]);
            }
            exitCode = e.getExitCode();
            IOUtils.info("", new Object[0]);
            if (ExitCode.SUCCESSFUL_COMPLETION.equals((Object)exitCode)) {
                IOUtils.info(COMPLETED_MSG, exitCode.getDescription());
            } else {
                IOUtils.info(String.format(ERROR_FORMAT_MSG, exitCode.getDescription()), new Object[0]);
            }
            return exitCode;
        }
        catch (Throwable t) {
            if (t.getMessage() != null) {
                IOUtils.error(t.getMessage(), new Object[0]);
            }
            exitCode = ExitCode.UNKNOWN_ERROR;
            {
                catch (Throwable throwable) {
                    IOUtils.info("", new Object[0]);
                    if (ExitCode.SUCCESSFUL_COMPLETION.equals((Object)exitCode)) {
                        IOUtils.info(COMPLETED_MSG, exitCode.getDescription());
                    } else {
                        IOUtils.info(String.format(ERROR_FORMAT_MSG, exitCode.getDescription()), new Object[0]);
                    }
                    return exitCode;
                }
            }
            IOUtils.info("", new Object[0]);
            if (ExitCode.SUCCESSFUL_COMPLETION.equals((Object)exitCode)) {
                IOUtils.info(COMPLETED_MSG, exitCode.getDescription());
            } else {
                IOUtils.info(String.format(ERROR_FORMAT_MSG, exitCode.getDescription()), new Object[0]);
            }
            return exitCode;
        }
        IOUtils.info("", new Object[0]);
        if (ExitCode.SUCCESSFUL_COMPLETION.equals((Object)exitCode)) {
            IOUtils.info(COMPLETED_MSG, exitCode.getDescription());
        } else {
            IOUtils.info(String.format(ERROR_FORMAT_MSG, exitCode.getDescription()), new Object[0]);
        }
        return exitCode;
    }

    protected abstract ExitCode doCall() throws ConfluentHubClientException;
}

