/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hub.cli.commands;

import com.github.rvesse.airline.annotations.Arguments;
import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.annotations.help.BashCompletion;
import com.github.rvesse.airline.annotations.help.ExitCodes;
import com.github.rvesse.airline.annotations.restrictions.Once;
import com.github.rvesse.airline.annotations.restrictions.Path;
import com.github.rvesse.airline.annotations.restrictions.Required;
import com.github.rvesse.airline.help.cli.bash.CompletionBehaviour;
import io.confluent.connect.hub.actions.ConfluentHubController;
import io.confluent.connect.hub.actions.Installable;
import io.confluent.connect.hub.cli.ExitCode;
import io.confluent.connect.hub.cli.commands.BaseCommand;
import io.confluent.connect.hub.cli.interaction.AssistedInstall;
import io.confluent.connect.hub.cli.interaction.AutoPilotInstall;
import io.confluent.connect.hub.io.StorageAdapter;
import io.confluent.connect.hub.platform.PlatformInspector;
import io.confluent.connect.hub.rest.PluginRegistryRepository;
import io.confluent.connect.hub.utils.IOUtils;

@Command(name="install", description="install a component from either Confluent Hub or from a local file")
@ExitCodes(codes={0, 1, 2, 3, 4, 5, 6, 7, 8, 9}, descriptions={"Successful completion", "Component not found, specify either valid name from Confluent Hub in format: <owner>/<name>:<version:latest> or path to a local file", "Invalid options or arguments", "Network problems", "Error while reading from/writing to filesystem", "Security issues", "Component is already installed", "Unknown error", "Component is not available for installation yet", "Action was cancelled by user"})
public class InstallCommand
extends BaseCommand {
    private static final String PLUGIN_REGISTRY_URL_DEFAULT = "https://api.hub.confluent.io";
    private static final String SUCCESSFUL_DRY_RUN_MSG = "A dry run has been completed successfully. All requirements are met. You can proceed with the installation.";
    @Once
    @Required
    @Arguments(title={"id"}, description="Identifier of the form 'owner/component-name:version' for the component in Confluent Hub, or the path to a local ZIP file that was downloaded from Confluent Hub.")
    protected String component;
    @Once
    @Option(name={"--component-dir"}, description="The local directory into which components are installed. Defaults to $share/confluent-hub-components for archive deployment,  and to /usr/share/confluent-hub-components for deb/rpm deployment.")
    @Path(mustExist=true)
    @BashCompletion(behaviour=CompletionBehaviour.DIRECTORIES)
    protected String componentDir;

    @Override
    protected ExitCode doCall() {
        StorageAdapter storage = new StorageAdapter(this.dryRun);
        PluginRegistryRepository repository = new PluginRegistryRepository(PLUGIN_REGISTRY_URL_DEFAULT);
        ConfluentHubController controller = new ConfluentHubController(storage, repository);
        PlatformInspector platformInspector = new PlatformInspector(storage, Runtime.getRuntime());
        Installable installable = this.noPrompt ? new AutoPilotInstall(this.component, this.componentDir, this.getWorkerConfigs(), platformInspector) : new AssistedInstall(this.component, this.componentDir, this.getWorkerConfigs(), platformInspector);
        ExitCode exitCode = controller.handle(installable);
        if (exitCode.equals((Object)ExitCode.SUCCESSFUL_COMPLETION) && this.dryRun) {
            IOUtils.info("", new Object[0]);
            IOUtils.info(SUCCESSFUL_DRY_RUN_MSG, this.component);
        }
        return exitCode;
    }
}

