/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hub.cli.interaction;

import io.confluent.connect.hub.actions.Installable;
import io.confluent.connect.hub.platform.Installation;
import io.confluent.connect.hub.platform.PlatformInspector;
import io.confluent.connect.hub.utils.IOUtils;
import io.confluent.pluginregistry.rest.entities.PluginLicense;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.Pair;

public class AssistedInstall
implements Installable {
    private static final String DETECTED_CONFIGS_MSG = "Detected Worker's configs:";
    private static final String UPDATE_ALL_CONFIGS_MSG = "Do you want to update all detected configs?";
    private static final String UPDATE_ONE_CONFIG_MSG_FORMAT = "Do you want to update %s?";
    private static final String CONTINUE_MSG = "Do you want to continue?";
    private static final String DEFAULT_INSTALLATION_DIRECTORY_MSG_FORMAT = "Do you want to install this into %s?";
    private static final String INSTALLATION_DIRECTORY_MSG = "Specify installation directory:";
    private static final String LICENSE_AGREEMENT_MSG = "I agree to the software license agreement";
    private static final String COMPONENTS_LICENSE = "Component's license:";
    private static final String DETECTED_INSTALLATION_MSG = "The component can be installed in any of the following Confluent Platform installations:";
    private static final String SELECT_INSTALLATION_MSG_FORMAT = "Choose one of these to continue the installation (%s):";
    private final PlatformInspector platformInspector;
    private final String component;
    private final String componentDir;
    private final List<String> workerConfigs;
    private Installation selectedInstallation;

    public AssistedInstall(String component, String componentDir, List<String> workerConfigs, PlatformInspector platformInspector) {
        this.component = component;
        this.componentDir = componentDir;
        this.workerConfigs = workerConfigs;
        this.platformInspector = platformInspector;
    }

    @Override
    public String getComponent() {
        return this.component;
    }

    @Override
    public String getComponentDir() {
        if (this.componentDir == null) {
            String defaultComponentDir = this.platformInspector.getComponentDir(this.getSelectedInstallation());
            boolean useDefault = IOUtils.readYesNoDefault(DEFAULT_INSTALLATION_DIRECTORY_MSG_FORMAT, defaultComponentDir);
            if (useDefault) {
                return defaultComponentDir;
            }
            return IOUtils.readString(INSTALLATION_DIRECTORY_MSG);
        }
        return this.componentDir;
    }

    @Override
    public Function<String, Boolean> getForce() {
        return q -> IOUtils.readYesNo(q);
    }

    @Override
    public List<String> getWorkerConfigs() {
        if (this.workerConfigs == null || this.workerConfigs.size() == 0) {
            List<Pair<String, String>> detectedConfigs = this.platformInspector.detectConfigs(this.getSelectedInstallation());
            IntStream multipleChoices = IOUtils.readMultipleChoices(detectedConfigs, DETECTED_CONFIGS_MSG, UPDATE_ALL_CONFIGS_MSG, UPDATE_ONE_CONFIG_MSG_FORMAT);
            List<String> selectedConfigs = multipleChoices.mapToObj(selectedIndex -> (String)((Pair)detectedConfigs.get(selectedIndex)).getValue()).collect(Collectors.toList());
            return selectedConfigs;
        }
        return this.workerConfigs;
    }

    private Installation getSelectedInstallation() {
        if (this.selectedInstallation == null) {
            List options = this.platformInspector.detectInstallations();
            if (options.size() == 1) {
                return (Installation)options.get(0).getKey();
            }
            this.selectedInstallation = (Installation)IOUtils.readOneChoice(options, DETECTED_INSTALLATION_MSG, SELECT_INSTALLATION_MSG_FORMAT).getKey();
        }
        return this.selectedInstallation;
    }

    @Override
    public Function<String, Boolean> getThirdPartyConfirmation() {
        return q -> {
            IOUtils.info(q, new Object[0]);
            return IOUtils.readYesNo(CONTINUE_MSG);
        };
    }

    @Override
    public Function<PluginLicense, Boolean> getLicenseAcceptedConfirmation() {
        return l -> {
            IOUtils.info("", new Object[0]);
            IOUtils.info(COMPONENTS_LICENSE, new Object[0]);
            IOUtils.info(l.getName(), new Object[0]);
            IOUtils.info(l.getUrl(), new Object[0]);
            return IOUtils.readYesNo(LICENSE_AGREEMENT_MSG);
        };
    }
}

