/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.pluginregistry;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum PluginType {
    SOURCE_CONNECTOR("source"),
    SINK_CONNECTOR("sink"),
    TRANSFORM("transform"),
    CONVERTER("converter");

    private static final Map<String, PluginType> TYPES_BY_NAME;
    private final String displayName;

    @JsonCreator
    public static PluginType parse(String displayName) {
        if (displayName != null) {
            displayName = displayName.toLowerCase();
        }
        return TYPES_BY_NAME.get(displayName);
    }

    private PluginType(String displayName) {
        this.displayName = displayName;
    }

    @JsonValue
    public String getDisplayName() {
        return this.displayName;
    }

    public String toString() {
        return this.getDisplayName();
    }

    static {
        TYPES_BY_NAME = new HashMap<String, PluginType>();
        for (PluginType type : PluginType.values()) {
            TYPES_BY_NAME.put(type.getDisplayName().toLowerCase(), type);
        }
    }
}

