/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.pluginregistry.rest.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.confluent.pluginregistry.util.JsonUtil;
import io.confluent.pluginregistry.util.ObjectUtil;
import java.io.IOException;

@JsonPropertyOrder(value={"name", "url", "mime_type", "md5", "sha1", "asc"})
public class PluginArchive
implements Comparable<PluginArchive> {
    @JsonProperty
    private String name;
    @JsonProperty
    private String url;
    @JsonProperty(value="mime_type")
    private String mimeType;
    @JsonProperty
    private String md5;
    @JsonProperty
    private String sha1;
    @JsonProperty
    private String asc;

    public static PluginArchive fromJson(String json) throws IOException {
        return (PluginArchive)JsonUtil.newObjectMapper().readValue(json, PluginArchive.class);
    }

    public PluginArchive() {
    }

    public PluginArchive(String name, String url, String mimeType, String md5, String sha1, String asc) {
        this.name = name;
        this.url = url;
        this.mimeType = mimeType;
        this.md5 = md5;
        this.sha1 = sha1;
        this.asc = asc;
    }

    public PluginArchive(PluginArchive original) {
        this.name = original.name;
        this.url = original.url;
        this.mimeType = original.mimeType;
        this.md5 = original.md5;
        this.sha1 = original.sha1;
        this.asc = original.asc;
    }

    public String toJson() throws IOException {
        return JsonUtil.newObjectMapper().writeValueAsString((Object)this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public String getSha1() {
        return this.sha1;
    }

    public void setSha1(String sha1) {
        this.sha1 = sha1;
    }

    public String getAsc() {
        return this.asc;
    }

    public void setAsc(String asc) {
        this.asc = asc;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.sha1 != null ? this.sha1.hashCode() : 0);
        result = 31 * result + (this.mimeType != null ? this.mimeType.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginArchive that = (PluginArchive)o;
        return ObjectUtil.equals(this.name, that.name) && ObjectUtil.equals(this.url, that.url) && ObjectUtil.equals(this.mimeType, that.mimeType) && ObjectUtil.equals(this.md5, that.md5) && ObjectUtil.equals(this.sha1, that.sha1) && ObjectUtil.equals(this.asc, that.asc);
    }

    @Override
    public int compareTo(PluginArchive that) {
        if (this == that) {
            return 0;
        }
        if (that == null) {
            return 1;
        }
        int diff = ObjectUtil.compareTo(this.name, that.name);
        if (diff != 0) {
            return diff;
        }
        diff = ObjectUtil.compareTo(this.mimeType, that.mimeType);
        if (diff != 0) {
            return diff;
        }
        diff = ObjectUtil.compareTo(this.md5, that.md5);
        if (diff != 0) {
            return diff;
        }
        diff = ObjectUtil.compareTo(this.sha1, that.sha1);
        return diff;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{name=" + this.name + ",");
        sb.append("url=" + this.url + ",");
        sb.append("mime_type=" + this.mimeType + ",");
        sb.append("md5=" + this.md5 + ",");
        sb.append("sha1=" + this.sha1 + ",");
        sb.append("asc=" + this.asc + "}");
        return sb.toString();
    }
}

