/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.pluginregistry.rest.entities;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum VerificationLevel {
    GOLD("gold"),
    STANDARD("standard");

    private static final Map<String, VerificationLevel> TYPES_BY_NAME;
    private final String displayName;

    public static VerificationLevel parse(String displayName) {
        return TYPES_BY_NAME.get(displayName.toLowerCase());
    }

    private VerificationLevel(String displayName) {
        this.displayName = displayName;
    }

    @JsonValue
    public String getDisplayName() {
        return this.displayName;
    }

    public String toString() {
        return this.getDisplayName();
    }

    static {
        TYPES_BY_NAME = new HashMap<String, VerificationLevel>();
        for (VerificationLevel type : VerificationLevel.values()) {
            TYPES_BY_NAME.put(type.getDisplayName().toLowerCase(), type);
        }
    }
}

